/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.utils;

import com.gitblit.models.DailyLogEntry;
import com.gitblit.models.PathModel;
import com.gitblit.models.RefLogEntry;
import com.gitblit.models.RefModel;
import com.gitblit.models.RepositoryCommit;
import com.gitblit.models.UserModel;
import com.gitblit.utils.ArrayUtils;
import com.gitblit.utils.CommitCache;
import com.gitblit.utils.JGitUtils;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeSet;
import org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefRename;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefLogUtils {
    private static final String GB_REFLOG = "refs/meta/gitblit/reflog";
    private static final Logger LOGGER = LoggerFactory.getLogger(RefLogUtils.class);

    private static void error(Throwable t, Repository repository, String pattern, Object ... objects) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        if (objects != null && objects.length > 0) {
            for (Object o : objects) {
                parameters.add(o);
            }
        }
        if (repository != null) {
            parameters.add(0, repository.getDirectory().getAbsolutePath());
        }
        LOGGER.error(MessageFormat.format(pattern, parameters.toArray()), t);
    }

    public static boolean hasRefLogBranch(Repository repository) {
        try {
            return repository.getRef(GB_REFLOG) != null;
        }
        catch (Exception e) {
            LOGGER.error("failed to determine hasRefLogBranch", (Throwable)e);
            return false;
        }
    }

    public static RefModel getRefLogBranch(Repository repository) {
        List<RefModel> refs = JGitUtils.getRefs(repository, "refs/");
        Ref oldRef = null;
        for (RefModel ref : refs) {
            if (ref.reference.getName().equals(GB_REFLOG)) {
                return ref;
            }
            if (ref.reference.getName().equals("refs/gitblit/reflog")) {
                oldRef = ref.reference;
                continue;
            }
            if (!ref.reference.getName().equals("refs/gitblit/pushes")) continue;
            oldRef = ref.reference;
        }
        if (oldRef != null) {
            try {
                RefRename cmd = repository.renameRef(oldRef.getName(), GB_REFLOG);
                cmd.setRefLogIdent(new PersonIdent("Gitblit", "gitblit@localhost"));
                cmd.setRefLogMessage("renamed " + oldRef.getName() + " => " + GB_REFLOG);
                RefUpdate.Result res = cmd.rename();
                switch (res) {
                    case RENAMED: {
                        LOGGER.info(repository.getDirectory() + " " + cmd.getRefLogMessage());
                        return RefLogUtils.getRefLogBranch(repository);
                    }
                }
                LOGGER.error("failed to rename " + oldRef.getName() + " => " + GB_REFLOG + " (" + res.name() + ")");
            }
            catch (IOException e) {
                LOGGER.error("failed to rename reflog", (Throwable)e);
            }
        }
        return null;
    }

    private static UserModel newUserModelFrom(PersonIdent ident) {
        String username;
        String displayname;
        String name = ident.getName();
        if (name.indexOf(47) > -1) {
            int slash = name.indexOf(47);
            displayname = name.substring(0, slash);
            username = name.substring(slash + 1);
        } else {
            displayname = name;
            username = ident.getEmailAddress();
        }
        UserModel user = new UserModel(username);
        user.displayName = displayname;
        user.emailAddress = ident.getEmailAddress();
        return user;
    }

    public static boolean deleteRef(UserModel user, Repository repository, Ref ref) {
        try {
            if (ref == null) {
                return false;
            }
            RefModel reflogBranch = RefLogUtils.getRefLogBranch(repository);
            if (reflogBranch == null) {
                return false;
            }
            List<RevCommit> log = JGitUtils.getRevLog(repository, reflogBranch.getName(), ref.getName(), 0, 1);
            if (log.isEmpty()) {
                return false;
            }
            ReceiveCommand cmd = new ReceiveCommand(ref.getObjectId(), ObjectId.zeroId(), ref.getName());
            return RefLogUtils.updateRefLog(user, repository, Arrays.asList(cmd));
        }
        catch (Throwable t) {
            RefLogUtils.error(t, repository, "Failed to commit reflog entry to {0}", new Object[0]);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean updateRefLog(UserModel user, Repository repository, Collection<ReceiveCommand> commands) {
        ArrayList<ReceiveCommand> filteredCommands = new ArrayList<ReceiveCommand>();
        for (ReceiveCommand cmd : commands) {
            if (!cmd.getRefName().startsWith("refs/heads/") && !cmd.getRefName().startsWith("refs/tags/")) continue;
            filteredCommands.add(cmd);
        }
        if (filteredCommands.isEmpty()) {
            return true;
        }
        RefModel reflogBranch = RefLogUtils.getRefLogBranch(repository);
        if (reflogBranch == null) {
            JGitUtils.createOrphanBranch(repository, GB_REFLOG, null);
        }
        boolean success = false;
        String message = "push";
        try {
            ObjectId headId = repository.resolve("refs/meta/gitblit/reflog^{commit}");
            try (ObjectInserter odi = repository.newObjectInserter();){
                DirCache index = RefLogUtils.createIndex(repository, headId, commands);
                ObjectId indexTreeId = index.writeTree(odi);
                PersonIdent ident = UserModel.ANONYMOUS.equals(user) ? new PersonIdent(user.username + "/" + user.username, user.username) : new PersonIdent(MessageFormat.format("{0}/{1}", user.getDisplayName(), user.username), user.emailAddress == null ? user.username : user.emailAddress);
                CommitBuilder commit = new CommitBuilder();
                commit.setAuthor(ident);
                commit.setCommitter(ident);
                commit.setEncoding("UTF-8");
                commit.setMessage(message);
                commit.setParentId((AnyObjectId)headId);
                commit.setTreeId((AnyObjectId)indexTreeId);
                ObjectId commitId = odi.insert(commit);
                odi.flush();
                try (RevWalk revWalk = new RevWalk(repository);){
                    RevCommit revCommit = revWalk.parseCommit((AnyObjectId)commitId);
                    RefUpdate ru = repository.updateRef(GB_REFLOG);
                    ru.setNewObjectId((AnyObjectId)commitId);
                    ru.setExpectedOldObjectId((AnyObjectId)headId);
                    ru.setRefLogMessage("commit: " + revCommit.getShortMessage(), false);
                    RefUpdate.Result rc = ru.forceUpdate();
                    switch (rc) {
                        case NEW: 
                        case FORCED: 
                        case FAST_FORWARD: {
                            success = true;
                            return success;
                        }
                        case REJECTED: 
                        case LOCK_FAILURE: {
                            throw new ConcurrentRefUpdateException(JGitText.get().couldNotLockHEAD, ru.getRef(), rc);
                        }
                        default: {
                            throw new JGitInternalException(MessageFormat.format(JGitText.get().updatingRefFailed, GB_REFLOG, commitId.toString(), rc));
                        }
                    }
                }
            }
        }
        catch (Throwable t) {
            RefLogUtils.error(t, repository, "Failed to commit reflog entry to {0}", new Object[0]);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DirCache createIndex(Repository repo, ObjectId headId, Collection<ReceiveCommand> commands) throws IOException {
        DirCache inCoreIndex = DirCache.newInCore();
        DirCacheBuilder dcBuilder = inCoreIndex.builder();
        ObjectInserter inserter = repo.newObjectInserter();
        long now = System.currentTimeMillis();
        TreeSet<String> ignorePaths = new TreeSet<String>();
        try {
            String path;
            for (ReceiveCommand command : commands) {
                path = command.getRefName();
                ignorePaths.add(path);
                StringBuilder change = new StringBuilder();
                change.append(command.getType().name()).append(' ');
                switch (command.getType()) {
                    case CREATE: {
                        change.append(ObjectId.zeroId().getName());
                        change.append(' ');
                        change.append(command.getNewId().getName());
                        break;
                    }
                    case UPDATE: 
                    case UPDATE_NONFASTFORWARD: {
                        change.append(command.getOldId().getName());
                        change.append(' ');
                        change.append(command.getNewId().getName());
                        break;
                    }
                    case DELETE: {
                        change = null;
                    }
                }
                if (change == null) continue;
                String content = change.toString();
                DirCacheEntry dcEntry = new DirCacheEntry(path);
                dcEntry.setLength(content.length());
                dcEntry.setLastModified(now);
                dcEntry.setFileMode(FileMode.REGULAR_FILE);
                dcEntry.setObjectId((AnyObjectId)inserter.insert(3, content.getBytes("UTF-8")));
                dcBuilder.add(dcEntry);
            }
            TreeWalk treeWalk = new TreeWalk(repo);
            int hIdx = -1;
            if (headId != null) {
                hIdx = treeWalk.addTree((AnyObjectId)new RevWalk(repo).parseTree((AnyObjectId)headId));
            }
            treeWalk.setRecursive(true);
            while (treeWalk.next()) {
                path = treeWalk.getPathString();
                CanonicalTreeParser hTree = null;
                if (hIdx != -1) {
                    hTree = (CanonicalTreeParser)treeWalk.getTree(hIdx, CanonicalTreeParser.class);
                }
                if (ignorePaths.contains(path) || hTree == null) continue;
                DirCacheEntry dcEntry = new DirCacheEntry(path);
                dcEntry.setObjectId((AnyObjectId)hTree.getEntryObjectId());
                dcEntry.setFileMode(hTree.getEntryFileMode());
                dcBuilder.add(dcEntry);
            }
            treeWalk.close();
            dcBuilder.finish();
        }
        finally {
            inserter.close();
        }
        return inCoreIndex;
    }

    public static List<RefLogEntry> getRefLog(String repositoryName, Repository repository) {
        return RefLogUtils.getRefLog(repositoryName, repository, null, 0, -1);
    }

    public static List<RefLogEntry> getRefLog(String repositoryName, Repository repository, int maxCount) {
        return RefLogUtils.getRefLog(repositoryName, repository, null, 0, maxCount);
    }

    public static List<RefLogEntry> getRefLog(String repositoryName, Repository repository, int offset, int maxCount) {
        return RefLogUtils.getRefLog(repositoryName, repository, null, offset, maxCount);
    }

    public static List<RefLogEntry> getRefLog(String repositoryName, Repository repository, Date minimumDate) {
        return RefLogUtils.getRefLog(repositoryName, repository, minimumDate, 0, -1);
    }

    public static List<RefLogEntry> getRefLog(String repositoryName, Repository repository, Date minimumDate, int offset, int maxCount) {
        ArrayList<RefLogEntry> list = new ArrayList<RefLogEntry>();
        RefModel ref = RefLogUtils.getRefLogBranch(repository);
        if (ref == null) {
            return list;
        }
        if (maxCount == 0) {
            return list;
        }
        Map<ObjectId, List<RefModel>> allRefs = JGitUtils.getAllRefs(repository);
        List<RevCommit> pushes = minimumDate == null ? JGitUtils.getRevLog(repository, GB_REFLOG, offset, maxCount) : JGitUtils.getRevLog(repository, GB_REFLOG, minimumDate);
        for (RevCommit push : pushes) {
            if (push.getAuthorIdent().getName().equalsIgnoreCase("gitblit")) continue;
            UserModel user = RefLogUtils.newUserModelFrom(push.getAuthorIdent());
            Date date = push.getAuthorIdent().getWhen();
            RefLogEntry log = new RefLogEntry(repositoryName, date, user);
            ArrayList<PathModel.PathChangeModel> changedRefs = new ArrayList<PathModel.PathChangeModel>();
            for (PathModel.PathChangeModel refChange : JGitUtils.getFilesInCommit(repository, push)) {
                if (!refChange.path.startsWith("refs/heads/") && !refChange.path.startsWith("refs/tags/")) continue;
                changedRefs.add(refChange);
            }
            if (changedRefs.isEmpty()) continue;
            list.add(log);
            block7: for (PathModel.PathChangeModel change : changedRefs) {
                switch (change.changeType) {
                    case DELETE: {
                        log.updateRef(change.path, ReceiveCommand.Type.DELETE);
                        continue block7;
                    }
                }
                String content = JGitUtils.getStringContent(repository, push.getTree(), change.path, new String[0]);
                String[] fields = content.split(" ");
                String oldId = fields[1];
                String newId = fields[2];
                log.updateRef(change.path, ReceiveCommand.Type.valueOf((String)fields[0]), oldId, newId);
                if (ObjectId.zeroId().getName().equals(newId)) continue;
                try {
                    List<RevCommit> pushedCommits = JGitUtils.getRevLog(repository, oldId, newId);
                    for (RevCommit pushedCommit : pushedCommits) {
                        RepositoryCommit repoCommit = log.addCommit(change.path, pushedCommit);
                        if (repoCommit == null) continue;
                        repoCommit.setRefs(allRefs.get(pushedCommit.getId()));
                    }
                }
                catch (Exception exception) {
                }
            }
        }
        Collections.sort(list);
        return list;
    }

    public static List<RefLogEntry> getLogByRef(String repositoryName, Repository repository, int maxCount) {
        return RefLogUtils.getLogByRef(repositoryName, repository, 0, maxCount);
    }

    public static List<RefLogEntry> getLogByRef(String repositoryName, Repository repository, int offset, int maxCount) {
        HashMap refMap = new HashMap();
        List<RefLogEntry> refLog = RefLogUtils.getRefLog(repositoryName, repository, offset, maxCount);
        for (RefLogEntry entry : refLog) {
            for (String ref : entry.getChangedRefs()) {
                if (!refMap.containsKey(ref)) {
                    refMap.put(ref, new ArrayList());
                }
                RefLogEntry refChange = entry instanceof DailyLogEntry ? new DailyLogEntry(entry.repository, entry.date) : new RefLogEntry(entry.repository, entry.date, entry.user);
                refChange.updateRef(ref, entry.getChangeType(ref), entry.getOldId(ref), entry.getNewId(ref));
                refChange.addCommits(entry.getCommits(ref));
                ((List)refMap.get(ref)).add(refChange);
            }
        }
        ArrayList<RefLogEntry> mergedRefLog = new ArrayList<RefLogEntry>();
        for (List refPush : refMap.values()) {
            mergedRefLog.addAll(refPush);
        }
        Collections.sort(mergedRefLog);
        return mergedRefLog;
    }

    public static List<RefLogEntry> getLogByRef(String repositoryName, Repository repository, Date minimumDate) {
        HashMap refMap = new HashMap();
        List<RefLogEntry> entries = RefLogUtils.getRefLog(repositoryName, repository, minimumDate);
        for (RefLogEntry entry : entries) {
            for (String ref : entry.getChangedRefs()) {
                if (!refMap.containsKey(ref)) {
                    refMap.put(ref, new ArrayList());
                }
                RefLogEntry refPush = new RefLogEntry(entry.repository, entry.date, entry.user);
                refPush.updateRef(ref, entry.getChangeType(ref), entry.getOldId(ref), entry.getNewId(ref));
                refPush.addCommits(entry.getCommits(ref));
                ((List)refMap.get(ref)).add(refPush);
            }
        }
        ArrayList<RefLogEntry> refLog = new ArrayList<RefLogEntry>();
        for (List entry : refMap.values()) {
            refLog.addAll(entry);
        }
        Collections.sort(refLog);
        return refLog;
    }

    public static List<DailyLogEntry> getDailyLog(String repositoryName, Repository repository, Date minimumDate, int offset, int maxCount, TimeZone timezone) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        df.setTimeZone(timezone);
        Map<ObjectId, List<RefModel>> allRefs = JGitUtils.getAllRefs(repository);
        HashMap<String, DailyLogEntry> tags = new HashMap<String, DailyLogEntry>();
        HashMap<String, DailyLogEntry> pulls = new HashMap<String, DailyLogEntry>();
        HashMap<String, DailyLogEntry> dailydigests = new HashMap<String, DailyLogEntry>();
        String linearParent = null;
        for (RefModel local : JGitUtils.getLocalBranches(repository, true, -1)) {
            if (!local.getDate().after(minimumDate)) continue;
            String branch = local.getName();
            List<RepositoryCommit> commits = CommitCache.instance().getCommits(repositoryName, repository, branch, minimumDate);
            linearParent = null;
            for (RepositoryCommit commit : commits) {
                RepositoryCommit repoCommit;
                if (linearParent != null && !commit.getName().equals(linearParent)) continue;
                Date date = commit.getCommitDate();
                String dateStr = df.format(date);
                if (!dailydigests.containsKey(dateStr)) {
                    dailydigests.put(dateStr, new DailyLogEntry(repositoryName, date));
                }
                DailyLogEntry digest = (DailyLogEntry)dailydigests.get(dateStr);
                if (commit.getParentCount() == 0) {
                    linearParent = null;
                    digest.updateRef(branch, ReceiveCommand.Type.CREATE);
                } else {
                    linearParent = commit.getParents()[0].getId().getName();
                    digest.updateRef(branch, ReceiveCommand.Type.UPDATE, linearParent, commit.getName());
                }
                if ((repoCommit = digest.addCommit(commit)) == null) continue;
                List<RefModel> matchedRefs = allRefs.get(commit.getId());
                repoCommit.setRefs(matchedRefs);
                if (ArrayUtils.isEmpty(matchedRefs)) continue;
                for (RefModel ref : matchedRefs) {
                    RepositoryCommit rc;
                    if (ref.getName().startsWith("refs/tags/")) {
                        if (!tags.containsKey(dateStr)) {
                            UserModel tagUser = RefLogUtils.newUserModelFrom(ref.getAuthorIdent());
                            Date tagDate = commit.getAuthorIdent().getWhen();
                            tags.put(dateStr, new DailyLogEntry(repositoryName, tagDate, tagUser));
                        }
                        RefLogEntry tagEntry = (RefLogEntry)tags.get(dateStr);
                        tagEntry.updateRef(ref.getName(), ReceiveCommand.Type.CREATE);
                        rc = repoCommit.clone(ref.getName());
                        tagEntry.addCommit(rc);
                        continue;
                    }
                    if (!ref.getName().startsWith("refs/pull/")) continue;
                    if (!pulls.containsKey(dateStr)) {
                        UserModel commitUser = RefLogUtils.newUserModelFrom(ref.getAuthorIdent());
                        Date commitDate = commit.getAuthorIdent().getWhen();
                        pulls.put(dateStr, new DailyLogEntry(repositoryName, commitDate, commitUser));
                    }
                    RefLogEntry pullEntry = (RefLogEntry)pulls.get(dateStr);
                    pullEntry.updateRef(ref.getName(), ReceiveCommand.Type.CREATE);
                    rc = repoCommit.clone(ref.getName());
                    pullEntry.addCommit(rc);
                }
            }
        }
        ArrayList<DailyLogEntry> list = new ArrayList<DailyLogEntry>(dailydigests.values());
        list.addAll(tags.values());
        Collections.sort(list);
        return list;
    }

    public static List<DailyLogEntry> getDailyLogByRef(String repositoryName, Repository repository, Date minimumDate, TimeZone timezone) {
        HashMap refMap = new HashMap();
        List<DailyLogEntry> entries = RefLogUtils.getDailyLog(repositoryName, repository, minimumDate, 0, -1, timezone);
        for (DailyLogEntry entry : entries) {
            for (String ref : entry.getChangedRefs()) {
                if (!refMap.containsKey(ref)) {
                    refMap.put(ref, new ArrayList());
                }
                DailyLogEntry refEntry = new DailyLogEntry(entry.repository, entry.date, entry.user);
                refEntry.updateRef(ref, entry.getChangeType(ref), entry.getOldId(ref), entry.getNewId(ref));
                refEntry.addCommits(entry.getCommits(ref));
                ((List)refMap.get(ref)).add(refEntry);
            }
        }
        ArrayList<DailyLogEntry> refLog = new ArrayList<DailyLogEntry>();
        for (List refEntry : refMap.values()) {
            for (DailyLogEntry entry : refEntry) {
                if (entry.getCommitCount() <= 0) continue;
                refLog.add(entry);
            }
        }
        Collections.sort(refLog);
        return refLog;
    }
}

