/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.utils;

import com.gitblit.Constants;
import com.gitblit.GitBlitException;
import com.gitblit.models.FederationModel;
import com.gitblit.models.FederationProposal;
import com.gitblit.models.FederationSet;
import com.gitblit.models.FeedModel;
import com.gitblit.models.RegistrantAccessPermission;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.ServerSettings;
import com.gitblit.models.ServerStatus;
import com.gitblit.models.TeamModel;
import com.gitblit.models.UserModel;
import com.gitblit.utils.JsonUtils;
import com.gitblit.utils.StringUtils;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class RpcUtils {
    public static final Type NAMES_TYPE = new TypeToken<Collection<String>>(){}.getType();
    public static final Type SETTINGS_TYPE = new TypeToken<Map<String, String>>(){}.getType();
    private static final Type REPOSITORIES_TYPE = new TypeToken<Map<String, RepositoryModel>>(){}.getType();
    private static final Type USERS_TYPE = new TypeToken<Collection<UserModel>>(){}.getType();
    private static final Type TEAMS_TYPE = new TypeToken<Collection<TeamModel>>(){}.getType();
    private static final Type REGISTRATIONS_TYPE = new TypeToken<Collection<FederationModel>>(){}.getType();
    private static final Type PROPOSALS_TYPE = new TypeToken<Collection<FederationProposal>>(){}.getType();
    private static final Type SETS_TYPE = new TypeToken<Collection<FederationSet>>(){}.getType();
    private static final Type BRANCHES_TYPE = new TypeToken<Map<String, Collection<String>>>(){}.getType();
    public static final Type REGISTRANT_PERMISSIONS_TYPE = new TypeToken<Collection<RegistrantAccessPermission>>(){}.getType();

    public static String asLink(String remoteURL, Constants.RpcRequest req) {
        return RpcUtils.asLink(remoteURL, req, null);
    }

    public static String asLink(String remoteURL, Constants.RpcRequest req, String name) {
        if (remoteURL.length() > 0 && remoteURL.charAt(remoteURL.length() - 1) == '/') {
            remoteURL = remoteURL.substring(0, remoteURL.length() - 1);
        }
        if (req == null) {
            req = Constants.RpcRequest.LIST_REPOSITORIES;
        }
        return remoteURL + "/rpc/" + "?req=" + req.name().toLowerCase() + (name == null ? "" : "&name=" + StringUtils.encodeURL(name));
    }

    public static int getProtocolVersion(String serverUrl, String account, char[] password) throws IOException {
        String url = RpcUtils.asLink(serverUrl, Constants.RpcRequest.GET_PROTOCOL);
        int protocol = 1;
        try {
            protocol = JsonUtils.retrieveJson(url, Integer.class, account, password);
        }
        catch (GitBlitException.UnknownRequestException unknownRequestException) {
            // empty catch block
        }
        return protocol;
    }

    public static Map<String, RepositoryModel> getRepositories(String serverUrl, String account, char[] password) throws IOException {
        String url = RpcUtils.asLink(serverUrl, Constants.RpcRequest.LIST_REPOSITORIES);
        Map models = (Map)JsonUtils.retrieveJson(url, REPOSITORIES_TYPE, account, password);
        return models;
    }

    public static List<UserModel> getUsers(String serverUrl, String account, char[] password) throws IOException {
        String url = RpcUtils.asLink(serverUrl, Constants.RpcRequest.LIST_USERS);
        Collection models = (Collection)JsonUtils.retrieveJson(url, USERS_TYPE, account, password);
        ArrayList<UserModel> list = new ArrayList<UserModel>(models);
        return list;
    }

    public static List<TeamModel> getTeams(String serverUrl, String account, char[] password) throws IOException {
        String url = RpcUtils.asLink(serverUrl, Constants.RpcRequest.LIST_TEAMS);
        Collection models = (Collection)JsonUtils.retrieveJson(url, TEAMS_TYPE, account, password);
        ArrayList<TeamModel> list = new ArrayList<TeamModel>(models);
        return list;
    }

    public static boolean createRepository(RepositoryModel repository, String serverUrl, String account, char[] password) throws IOException {
        if (!repository.name.endsWith(".git")) {
            repository.name = repository.name + ".git";
        }
        return RpcUtils.doAction(Constants.RpcRequest.CREATE_REPOSITORY, null, repository, serverUrl, account, password);
    }

    public static boolean forkRepository(RepositoryModel repository, String serverUrl, String account, char[] password) throws IOException {
        return RpcUtils.doAction(Constants.RpcRequest.FORK_REPOSITORY, repository.name, null, serverUrl, account, password);
    }

    public static boolean updateRepository(String repositoryName, RepositoryModel repository, String serverUrl, String account, char[] password) throws IOException {
        return RpcUtils.doAction(Constants.RpcRequest.EDIT_REPOSITORY, repositoryName, repository, serverUrl, account, password);
    }

    public static boolean deleteRepository(RepositoryModel repository, String serverUrl, String account, char[] password) throws IOException {
        return RpcUtils.doAction(Constants.RpcRequest.DELETE_REPOSITORY, null, repository, serverUrl, account, password);
    }

    public static boolean clearRepositoryCache(String serverUrl, String account, char[] password) throws IOException {
        return RpcUtils.doAction(Constants.RpcRequest.CLEAR_REPOSITORY_CACHE, null, null, serverUrl, account, password);
    }

    public static boolean reindexTickets(String serverUrl, String account, char[] password) throws IOException {
        return RpcUtils.doAction(Constants.RpcRequest.REINDEX_TICKETS, null, null, serverUrl, account, password);
    }

    public static boolean reindexTickets(String serverUrl, String repositoryName, String account, char[] password) throws IOException {
        return RpcUtils.doAction(Constants.RpcRequest.REINDEX_TICKETS, repositoryName, null, serverUrl, account, password);
    }

    public static boolean createUser(UserModel user, String serverUrl, String account, char[] password) throws IOException {
        return RpcUtils.doAction(Constants.RpcRequest.CREATE_USER, null, user, serverUrl, account, password);
    }

    public static boolean updateUser(String username, UserModel user, String serverUrl, String account, char[] password) throws IOException {
        return RpcUtils.doAction(Constants.RpcRequest.EDIT_USER, username, user, serverUrl, account, password);
    }

    public static boolean deleteUser(UserModel user, String serverUrl, String account, char[] password) throws IOException {
        return RpcUtils.doAction(Constants.RpcRequest.DELETE_USER, null, user, serverUrl, account, password);
    }

    public static UserModel getUser(String username, String serverUrl, String account, char[] password) throws IOException {
        String url = RpcUtils.asLink(serverUrl, Constants.RpcRequest.GET_USER);
        UserModel model = JsonUtils.retrieveJson(url, UserModel.class, account, password);
        return model;
    }

    public static boolean createTeam(TeamModel team, String serverUrl, String account, char[] password) throws IOException {
        return RpcUtils.doAction(Constants.RpcRequest.CREATE_TEAM, null, team, serverUrl, account, password);
    }

    public static boolean updateTeam(String teamname, TeamModel team, String serverUrl, String account, char[] password) throws IOException {
        return RpcUtils.doAction(Constants.RpcRequest.EDIT_TEAM, teamname, team, serverUrl, account, password);
    }

    public static boolean deleteTeam(TeamModel team, String serverUrl, String account, char[] password) throws IOException {
        return RpcUtils.doAction(Constants.RpcRequest.DELETE_TEAM, null, team, serverUrl, account, password);
    }

    public static List<String> getRepositoryMembers(RepositoryModel repository, String serverUrl, String account, char[] password) throws IOException {
        String url = RpcUtils.asLink(serverUrl, Constants.RpcRequest.LIST_REPOSITORY_MEMBERS, repository.name);
        Collection list = (Collection)JsonUtils.retrieveJson(url, NAMES_TYPE, account, password);
        return new ArrayList<String>(list);
    }

    public static List<RegistrantAccessPermission> getRepositoryMemberPermissions(RepositoryModel repository, String serverUrl, String account, char[] password) throws IOException {
        String url = RpcUtils.asLink(serverUrl, Constants.RpcRequest.LIST_REPOSITORY_MEMBER_PERMISSIONS, repository.name);
        Collection list = (Collection)JsonUtils.retrieveJson(url, REGISTRANT_PERMISSIONS_TYPE, account, password);
        return new ArrayList<RegistrantAccessPermission>(list);
    }

    public static boolean setRepositoryMemberPermissions(RepositoryModel repository, List<RegistrantAccessPermission> permissions, String serverUrl, String account, char[] password) throws IOException {
        return RpcUtils.doAction(Constants.RpcRequest.SET_REPOSITORY_MEMBER_PERMISSIONS, repository.name, permissions, serverUrl, account, password);
    }

    public static List<String> getRepositoryTeams(RepositoryModel repository, String serverUrl, String account, char[] password) throws IOException {
        String url = RpcUtils.asLink(serverUrl, Constants.RpcRequest.LIST_REPOSITORY_TEAMS, repository.name);
        Collection list = (Collection)JsonUtils.retrieveJson(url, NAMES_TYPE, account, password);
        return new ArrayList<String>(list);
    }

    public static List<RegistrantAccessPermission> getRepositoryTeamPermissions(RepositoryModel repository, String serverUrl, String account, char[] password) throws IOException {
        String url = RpcUtils.asLink(serverUrl, Constants.RpcRequest.LIST_REPOSITORY_TEAM_PERMISSIONS, repository.name);
        Collection list = (Collection)JsonUtils.retrieveJson(url, REGISTRANT_PERMISSIONS_TYPE, account, password);
        return new ArrayList<RegistrantAccessPermission>(list);
    }

    public static boolean setRepositoryTeamPermissions(RepositoryModel repository, List<RegistrantAccessPermission> permissions, String serverUrl, String account, char[] password) throws IOException {
        return RpcUtils.doAction(Constants.RpcRequest.SET_REPOSITORY_TEAM_PERMISSIONS, repository.name, permissions, serverUrl, account, password);
    }

    public static List<FederationModel> getFederationRegistrations(String serverUrl, String account, char[] password) throws IOException {
        String url = RpcUtils.asLink(serverUrl, Constants.RpcRequest.LIST_FEDERATION_REGISTRATIONS);
        Collection registrations = (Collection)JsonUtils.retrieveJson(url, REGISTRATIONS_TYPE, account, password);
        ArrayList<FederationModel> list = new ArrayList<FederationModel>(registrations);
        return list;
    }

    public static List<FederationModel> getFederationResultRegistrations(String serverUrl, String account, char[] password) throws IOException {
        String url = RpcUtils.asLink(serverUrl, Constants.RpcRequest.LIST_FEDERATION_RESULTS);
        Collection registrations = (Collection)JsonUtils.retrieveJson(url, REGISTRATIONS_TYPE, account, password);
        ArrayList<FederationModel> list = new ArrayList<FederationModel>(registrations);
        return list;
    }

    public static List<FederationProposal> getFederationProposals(String serverUrl, String account, char[] password) throws IOException {
        String url = RpcUtils.asLink(serverUrl, Constants.RpcRequest.LIST_FEDERATION_PROPOSALS);
        Collection proposals = (Collection)JsonUtils.retrieveJson(url, PROPOSALS_TYPE, account, password);
        ArrayList<FederationProposal> list = new ArrayList<FederationProposal>(proposals);
        return list;
    }

    public static List<FederationSet> getFederationSets(String serverUrl, String account, char[] password) throws IOException {
        String url = RpcUtils.asLink(serverUrl, Constants.RpcRequest.LIST_FEDERATION_SETS);
        Collection sets = (Collection)JsonUtils.retrieveJson(url, SETS_TYPE, account, password);
        ArrayList<FederationSet> list = new ArrayList<FederationSet>(sets);
        return list;
    }

    public static ServerSettings getSettings(String serverUrl, String account, char[] password) throws IOException {
        String url = RpcUtils.asLink(serverUrl, Constants.RpcRequest.LIST_SETTINGS);
        ServerSettings settings = JsonUtils.retrieveJson(url, ServerSettings.class, account, password);
        return settings;
    }

    public static boolean updateSettings(Map<String, String> settings, String serverUrl, String account, char[] password) throws IOException {
        return RpcUtils.doAction(Constants.RpcRequest.EDIT_SETTINGS, null, settings, serverUrl, account, password);
    }

    public static ServerStatus getStatus(String serverUrl, String account, char[] password) throws IOException {
        String url = RpcUtils.asLink(serverUrl, Constants.RpcRequest.LIST_STATUS);
        ServerStatus status = JsonUtils.retrieveJson(url, ServerStatus.class, account, password);
        return status;
    }

    public static Map<String, Collection<String>> getBranches(String serverUrl, String account, char[] password) throws IOException {
        String url = RpcUtils.asLink(serverUrl, Constants.RpcRequest.LIST_BRANCHES);
        Map branches = (Map)JsonUtils.retrieveJson(url, BRANCHES_TYPE, account, password);
        return branches;
    }

    public static List<FeedModel> getBranchFeeds(String serverUrl, String account, char[] password) throws IOException {
        ArrayList<FeedModel> feeds = new ArrayList<FeedModel>();
        Map<String, Collection<String>> allBranches = RpcUtils.getBranches(serverUrl, account, password);
        for (Map.Entry<String, Collection<String>> entry : allBranches.entrySet()) {
            for (String branch : entry.getValue()) {
                FeedModel feed = new FeedModel();
                feed.repository = entry.getKey();
                feed.branch = branch;
                feeds.add(feed);
            }
        }
        return feeds;
    }

    protected static boolean doAction(Constants.RpcRequest request, String name, Object object, String serverUrl, String account, char[] password) throws IOException {
        String json;
        String url = RpcUtils.asLink(serverUrl, request, name);
        int resultCode = JsonUtils.sendJsonString(url, json = JsonUtils.toJsonString(object), account, password);
        return resultCode == 200;
    }
}

