/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.utils;

public class SecureRandom {
    private static final long RESEED_PERIOD = 86400000L;
    private long last;
    private java.security.SecureRandom random;

    public SecureRandom() {
        this.seed();
    }

    public byte[] randomBytes(int num) {
        byte[] bytes = new byte[num];
        this.nextBytes(bytes);
        return bytes;
    }

    public void nextBytes(byte[] bytes) {
        this.random.nextBytes(bytes);
        this.reseed(false);
    }

    void reseed(boolean forced) {
        long ts = System.currentTimeMillis();
        if (forced || ts - this.last > 86400000L) {
            this.last = ts;
            this.runReseed();
        }
    }

    private void seed() {
        this.random = new java.security.SecureRandom();
        this.random.nextBytes(new byte[0]);
        this.last = System.currentTimeMillis();
    }

    private void runReseed() {
        new Thread(){

            @Override
            public void run() {
                SecureRandom.this.seed();
            }
        }.start();
    }
}

