/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.utils;

import com.gitblit.utils.IdGenerator;
import com.gitblit.utils.TaskInfoFactory;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkQueue {
    private static final Logger log = LoggerFactory.getLogger(WorkQueue.class);
    private static final Thread.UncaughtExceptionHandler LOG_UNCAUGHT_EXCEPTION = new Thread.UncaughtExceptionHandler(){

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            log.error("WorkQueue thread " + t.getName() + " threw exception", e);
        }
    };
    private Executor defaultQueue;
    private final IdGenerator idGenerator;
    private final int defaultQueueSize;
    private final CopyOnWriteArrayList<Executor> queues;

    public WorkQueue(IdGenerator idGenerator, int defaultQueueSize) {
        this.idGenerator = idGenerator;
        this.defaultQueueSize = defaultQueueSize;
        this.queues = new CopyOnWriteArrayList();
    }

    public synchronized Executor getDefaultQueue() {
        if (this.defaultQueue == null) {
            this.defaultQueue = this.createQueue(this.defaultQueueSize, "WorkQueue");
        }
        return this.defaultQueue;
    }

    public Executor createQueue(int poolsize, String prefix) {
        Executor r = new Executor(poolsize, prefix);
        r.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        r.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.queues.add(r);
        return r;
    }

    public List<Task<?>> getTasks() {
        ArrayList r = new ArrayList();
        for (Executor e : this.queues) {
            e.addAllTo(r);
        }
        return r;
    }

    public <T> List<T> getTaskInfos(TaskInfoFactory<T> factory) {
        ArrayList taskInfos = Lists.newArrayList();
        for (Executor exe : this.queues) {
            for (Task<?> task : exe.getTasks()) {
                taskInfos.add(factory.getTaskInfo(task));
            }
        }
        return taskInfos;
    }

    public Task<?> getTask(int id) {
        Task<?> result = null;
        for (Executor e : this.queues) {
            Task<?> t = e.getTask(id);
            if (t == null) continue;
            if (result != null) {
                return null;
            }
            result = t;
        }
        return result;
    }

    public void stop() {
        for (Executor p : this.queues) {
            boolean isTerminated;
            p.shutdown();
            do {
                try {
                    isTerminated = p.awaitTermination(10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException ie) {
                    isTerminated = false;
                }
            } while (!isTerminated);
        }
        this.queues.clear();
    }

    public static class Task<V>
    implements RunnableScheduledFuture<V> {
        private final Runnable runnable;
        private final RunnableScheduledFuture<V> task;
        private final Executor executor;
        private final int taskId;
        private final AtomicBoolean running;
        private final Date startTime;

        Task(Runnable runnable, RunnableScheduledFuture<V> task, Executor executor, int taskId) {
            this.runnable = runnable;
            this.task = task;
            this.executor = executor;
            this.taskId = taskId;
            this.running = new AtomicBoolean();
            this.startTime = new Date();
        }

        public int getTaskId() {
            return this.taskId;
        }

        public State getState() {
            if (this.isCancelled()) {
                return State.CANCELLED;
            }
            if (this.isDone() && !this.isPeriodic()) {
                return State.DONE;
            }
            if (this.running.get()) {
                return State.RUNNING;
            }
            long delay = this.getDelay(TimeUnit.MILLISECONDS);
            if (delay <= 0L) {
                return State.READY;
            }
            if (0L < delay) {
                return State.SLEEPING;
            }
            return State.OTHER;
        }

        public Date getStartTime() {
            return this.startTime;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            if (this.task.cancel(mayInterruptIfRunning)) {
                if (this.runnable instanceof CancelableRunnable && this.running.compareAndSet(false, true)) {
                    ((CancelableRunnable)this.runnable).cancel();
                }
                this.executor.remove(this);
                this.executor.purge();
                return true;
            }
            return false;
        }

        @Override
        public int compareTo(Delayed o) {
            return this.task.compareTo(o);
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            return this.task.get();
        }

        @Override
        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.task.get(timeout, unit);
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return this.task.getDelay(unit);
        }

        @Override
        public boolean isCancelled() {
            return this.task.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.task.isDone();
        }

        @Override
        public boolean isPeriodic() {
            return this.task.isPeriodic();
        }

        @Override
        public void run() {
            if (this.running.compareAndSet(false, true)) {
                try {
                    this.task.run();
                }
                finally {
                    if (this.isPeriodic()) {
                        this.running.set(false);
                    } else {
                        this.executor.remove(this);
                    }
                }
            }
        }

        public String toString() {
            return this.runnable.toString();
        }

        public static enum State {
            DONE,
            CANCELLED,
            RUNNING,
            READY,
            SLEEPING,
            OTHER;

        }
    }

    public static interface CancelableRunnable
    extends Runnable {
        public void cancel();
    }

    public class Executor
    extends ScheduledThreadPoolExecutor {
        private final ConcurrentHashMap<Integer, Task<?>> all;

        Executor(int corePoolSize, final String prefix) {
            super(corePoolSize, new ThreadFactory(){
                private final ThreadFactory parent = Executors.defaultThreadFactory();
                private final AtomicInteger tid = new AtomicInteger(1);

                @Override
                public Thread newThread(Runnable task) {
                    Thread t = this.parent.newThread(task);
                    t.setName(prefix + "-" + this.tid.getAndIncrement());
                    t.setUncaughtExceptionHandler(LOG_UNCAUGHT_EXCEPTION);
                    return t;
                }
            });
            this.all = new ConcurrentHashMap(corePoolSize << 1, 0.75f, corePoolSize + 4);
        }

        public void unregisterWorkQueue() {
            WorkQueue.this.queues.remove(this);
        }

        @Override
        protected <V> RunnableScheduledFuture<V> decorateTask(Runnable runnable, RunnableScheduledFuture<V> r) {
            int id;
            Task<V> task;
            r = super.decorateTask(runnable, r);
            while (this.all.putIfAbsent((task = new Task<V>(runnable, r, this, id = WorkQueue.this.idGenerator.next())).getTaskId(), task) != null) {
            }
            return task;
        }

        @Override
        protected <V> RunnableScheduledFuture<V> decorateTask(Callable<V> callable, RunnableScheduledFuture<V> task) {
            throw new UnsupportedOperationException("Callable not implemented");
        }

        void remove(Task<?> task) {
            this.all.remove(task.getTaskId(), task);
        }

        Task<?> getTask(int id) {
            return this.all.get(id);
        }

        void addAllTo(List<Task<?>> list) {
            list.addAll(this.all.values());
        }

        Collection<Task<?>> getTasks() {
            return this.all.values();
        }
    }
}

