/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket;

import com.gitblit.IStoredSettings;
import com.gitblit.utils.XssFilter;
import java.util.HashSet;
import java.util.Map;
import org.apache.wicket.IRequestTarget;
import org.apache.wicket.Page;
import org.apache.wicket.request.RequestParameters;
import org.apache.wicket.request.target.coding.MixedParamUrlCodingStrategy;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitblitParamUrlCodingStrategy
extends MixedParamUrlCodingStrategy {
    private final String[] parameterNames;
    private Logger logger = LoggerFactory.getLogger(GitblitParamUrlCodingStrategy.class);
    private IStoredSettings settings;
    private XssFilter xssFilter;

    public <C extends Page> GitblitParamUrlCodingStrategy(IStoredSettings settings, XssFilter xssFilter, String mountPath, Class<C> bookmarkablePageClass, String[] parameterNames) {
        super(mountPath, bookmarkablePageClass, parameterNames);
        this.parameterNames = parameterNames;
        this.settings = settings;
        this.xssFilter = xssFilter;
    }

    protected String urlEncodePathComponent(String string) {
        char altChar = this.settings.getChar("web.forwardSlashCharacter", '/');
        if (altChar != '/') {
            string = string.replace('/', altChar);
        }
        return super.urlEncodePathComponent(string);
    }

    protected String urlDecodePathComponent(String value) {
        char altChar = this.settings.getChar("web.forwardSlashCharacter", '/');
        if (altChar != '/') {
            value = value.replace(altChar, '/');
        }
        return super.urlDecodePathComponent(value);
    }

    public IRequestTarget decode(RequestParameters requestParameters) {
        Map parameterMap = requestParameters.getParameters();
        for (Map.Entry entry : parameterMap.entrySet()) {
            String parameter = (String)entry.getKey();
            if (parameter.startsWith("wicket:")) continue;
            Object o = entry.getValue();
            if (o instanceof String) {
                String safeValue;
                String value = o.toString();
                if (value.equals(safeValue = this.xssFilter.none(value))) continue;
                this.logger.warn("XSS filter triggered on {} URL parameter: {}={}", new Object[]{this.getMountPath(), parameter, value});
                parameterMap.put(parameter, safeValue);
                continue;
            }
            if (!(o instanceof String[])) continue;
            String[] values = (String[])o;
            for (int i = 0; i < values.length; ++i) {
                String safeValue;
                String value = values[i].toString();
                if (value.equals(safeValue = this.xssFilter.none(value))) continue;
                this.logger.warn("XSS filter triggered on {} URL parameter: {}={}", new Object[]{this.getMountPath(), parameter, value});
                values[i] = safeValue;
            }
        }
        return super.decode(requestParameters);
    }

    protected void appendParameters(AppendingStringBuffer url, Map<String, ?> parameters) {
        if (!url.endsWith((CharSequence)"/")) {
            url.append("/");
        }
        HashSet<String> parameterNamesToAdd = new HashSet<String>(parameters.keySet());
        boolean foundParameter = false;
        int lastSpecifiedParameter = this.parameterNames.length;
        while (lastSpecifiedParameter != 0 && !foundParameter) {
            foundParameter = parameters.containsKey(this.parameterNames[--lastSpecifiedParameter]);
        }
        if (foundParameter) {
            for (int i = 0; i <= lastSpecifiedParameter; ++i) {
                String value;
                String parameterName = this.parameterNames[i];
                Object param = parameters.get(parameterName);
                String string = param instanceof String[] ? ((String[])param)[0] : (value = param == null ? null : param.toString());
                if (value == null) {
                    value = "";
                }
                if (!url.endsWith((CharSequence)"/")) {
                    url.append("/");
                }
                url.append(this.urlEncodePathComponent(value));
                parameterNamesToAdd.remove(parameterName);
            }
        }
        if (!parameterNamesToAdd.isEmpty()) {
            boolean first = true;
            for (String parameterName : parameterNamesToAdd) {
                Object param = parameters.get(parameterName);
                if (param instanceof String[]) {
                    String[] values;
                    for (String value : values = (String[])param) {
                        url.append(first ? (char)'?' : '&');
                        url.append(this.urlEncodeQueryComponent(parameterName)).append("=").append(this.urlEncodeQueryComponent(value));
                        first = false;
                    }
                } else {
                    url.append(first ? (char)'?' : '&');
                    String value = String.valueOf(param);
                    url.append(this.urlEncodeQueryComponent(parameterName)).append("=").append(this.urlEncodeQueryComponent(value));
                }
                first = false;
            }
        }
    }
}

