/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.wicket.Session;
import org.apache.wicket.markup.html.form.AbstractTextComponent;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.convert.converters.DateConverter;

public class Html5DateField
extends TextField<Date>
implements AbstractTextComponent.ITextFormatProvider {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_PATTERN = "MM/dd/yyyy";
    private String datePattern = null;
    private IConverter converter = null;

    public Html5DateField(String id) {
        this(id, null, Html5DateField.defaultDatePattern());
    }

    public Html5DateField(String id, IModel<Date> model) {
        this(id, model, Html5DateField.defaultDatePattern());
    }

    public Html5DateField(String id, String datePattern) {
        this(id, null, datePattern);
    }

    public Html5DateField(String id, IModel<Date> model, String datePattern) {
        super(id, model, Date.class);
        this.datePattern = datePattern;
        this.converter = new DateConverter(){
            private static final long serialVersionUID = 1L;

            public DateFormat getDateFormat(Locale locale) {
                if (locale == null) {
                    locale = Locale.getDefault();
                }
                return new SimpleDateFormat(Html5DateField.this.datePattern, locale);
            }
        };
    }

    public IConverter getConverter(Class<?> type) {
        if (this.converter == null) {
            return super.getConverter(type);
        }
        return this.converter;
    }

    public String getTextFormat() {
        return this.datePattern;
    }

    private static String defaultDatePattern() {
        DateFormat format;
        Locale locale = Session.get().getLocale();
        if (locale != null && (format = DateFormat.getDateInstance(3, locale)) instanceof SimpleDateFormat) {
            return ((SimpleDateFormat)format).toPattern();
        }
        return DEFAULT_PATTERN;
    }

    protected String getInputType() {
        return "date";
    }
}

