/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket;

import com.gitblit.manager.IPluginManager;
import com.gitblit.wicket.UrlExternalFormComparator;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.application.IClassResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.fortsoft.pf4j.PluginState;
import ro.fortsoft.pf4j.PluginWrapper;

public class PluginClassResolver
implements IClassResolver {
    private static final Logger logger = LoggerFactory.getLogger(PluginClassResolver.class);
    private final IClassResolver coreResolver;
    private final IPluginManager pluginManager;

    public PluginClassResolver(IClassResolver coreResolver, IPluginManager pluginManager) {
        this.coreResolver = coreResolver;
        this.pluginManager = pluginManager;
    }

    public Class<?> resolveClass(String className) throws ClassNotFoundException {
        boolean debugEnabled = logger.isDebugEnabled();
        for (PluginWrapper plugin : this.pluginManager.getPlugins()) {
            if (PluginState.STARTED != plugin.getPluginState()) continue;
            try {
                return plugin.getPluginClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException cnfx) {
                if (!debugEnabled) continue;
                logger.debug("ClassResolver '{}' cannot find class: '{}'", (Object)plugin.getPluginId(), (Object)className);
            }
        }
        return this.coreResolver.resolveClass(className);
    }

    public Iterator<URL> getResources(String name) {
        TreeSet<URL> urls = new TreeSet<URL>(new UrlExternalFormComparator());
        for (PluginWrapper plugin : this.pluginManager.getPlugins()) {
            if (PluginState.STARTED != plugin.getPluginState()) continue;
            Iterator<URL> it = this.getResources(name, plugin);
            while (it.hasNext()) {
                URL url = it.next();
                urls.add(url);
            }
        }
        Iterator it = this.coreResolver.getResources(name);
        while (it.hasNext()) {
            URL url = (URL)it.next();
            urls.add(url);
        }
        return urls.iterator();
    }

    protected Iterator<URL> getResources(String name, PluginWrapper plugin) {
        HashSet<URL> loadedFiles = new HashSet<URL>();
        try {
            Enumeration resources = plugin.getPluginClassLoader().getResources(name);
            this.loadResources(resources, loadedFiles);
        }
        catch (IOException e) {
            throw new WicketRuntimeException((Throwable)e);
        }
        return loadedFiles.iterator();
    }

    private void loadResources(Enumeration<URL> resources, Set<URL> loadedFiles) {
        if (resources != null) {
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                if (loadedFiles.contains(url)) continue;
                loadedFiles.add(url);
            }
        }
    }
}

