/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket;

import com.gitblit.wicket.GitBlitWebApp;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.lang.Objects;
import org.parboiled.common.StringUtils;
import org.slf4j.LoggerFactory;

public class SafeTextModel
implements IModel<String> {
    private static final long serialVersionUID = 1L;
    private final Mode mode;
    private String value;

    public static SafeTextModel none() {
        return new SafeTextModel(Mode.none);
    }

    public static SafeTextModel none(String value) {
        return new SafeTextModel(value, Mode.none);
    }

    public static SafeTextModel relaxed() {
        return new SafeTextModel(Mode.relaxed);
    }

    public static SafeTextModel relaxed(String value) {
        return new SafeTextModel(value, Mode.relaxed);
    }

    public SafeTextModel(Mode mode) {
        this.mode = mode;
    }

    public SafeTextModel(String value, Mode mode) {
        this.value = value;
        this.mode = mode;
    }

    public void detach() {
    }

    public String getObject() {
        String safeValue;
        if (StringUtils.isEmpty((String)this.value)) {
            return this.value;
        }
        switch (this.mode) {
            case none: {
                safeValue = GitBlitWebApp.get().xssFilter().none(this.value);
                break;
            }
            default: {
                safeValue = GitBlitWebApp.get().xssFilter().relaxed(this.value);
            }
        }
        if (!this.value.equals(safeValue)) {
            LoggerFactory.getLogger(this.getClass()).warn("XSS filter trigggered on suspicious form field value {}", (Object)this.value);
        }
        return safeValue;
    }

    public void setObject(String input) {
        this.value = input;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.value});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Model)) {
            return false;
        }
        Model that = (Model)obj;
        return Objects.equal((Object)this.value, (Object)that.getObject());
    }

    public static enum Mode {
        relaxed,
        none;

    }
}

