/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket;

import com.gitblit.models.TicketModel;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.WicketUtils;
import java.io.Serializable;
import java.text.MessageFormat;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;

public class TicketsUI {
    public static final String[] openStatii = new String[]{TicketModel.Status.New.name().toLowerCase(), TicketModel.Status.Open.name().toLowerCase()};
    public static final String[] closedStatii = new String[]{"!" + TicketModel.Status.New.name().toLowerCase(), "!" + TicketModel.Status.Open.name().toLowerCase()};

    public static Label getStateIcon(String wicketId, TicketModel ticket) {
        return TicketsUI.getStateIcon(wicketId, ticket.type, ticket.status, ticket.severity);
    }

    public static Label getStateIcon(String wicketId, TicketModel.Type type, TicketModel.Status state, TicketModel.Severity severity) {
        Label label = new Label(wicketId);
        if (type == null) {
            type = TicketModel.Type.defaultType;
        }
        switch (type) {
            case Proposal: {
                WicketUtils.setCssClass((Component)label, "fa fa-code-fork fa-fw");
                break;
            }
            case Bug: {
                WicketUtils.setCssClass((Component)label, "fa fa-bug fa-fw");
                break;
            }
            case Enhancement: {
                WicketUtils.setCssClass((Component)label, "fa fa-magic fa-fw");
                break;
            }
            case Question: {
                WicketUtils.setCssClass((Component)label, "fa fa-question fa-fw");
                break;
            }
            case Maintenance: {
                WicketUtils.setCssClass((Component)label, "fa fa-cogs fa-fw");
                break;
            }
            default: {
                WicketUtils.setCssClass((Component)label, "fa fa-ticket fa-fw");
            }
        }
        WicketUtils.setHtmlTooltip((Component)label, TicketsUI.getTypeState(type, state, severity));
        return label;
    }

    public static Label getPriorityIcon(String wicketId, TicketModel.Priority priority) {
        Label label = new Label(wicketId);
        if (priority == null) {
            priority = TicketModel.Priority.defaultPriority;
        }
        switch (priority) {
            case Urgent: {
                WicketUtils.setCssClass((Component)label, "fa fa-step-forward fa-rotate-270");
                break;
            }
            case High: {
                WicketUtils.setCssClass((Component)label, "fa fa-caret-up fa-lg");
                break;
            }
            case Low: {
                WicketUtils.setCssClass((Component)label, "fa fa-caret-down fa-lg");
                break;
            }
        }
        WicketUtils.setHtmlTooltip((Component)label, priority.toString());
        return label;
    }

    public static String getPriorityClass(TicketModel.Priority priority) {
        return String.format("priority-%s", new Object[]{priority});
    }

    public static String getSeverityClass(TicketModel.Severity severity) {
        return String.format("severity-%s", new Object[]{severity});
    }

    public static String getTypeState(TicketModel.Type type, TicketModel.Status state, TicketModel.Severity severity) {
        if (TicketModel.Severity.Unrated == severity) {
            return state.toString() + " " + type.toString();
        }
        return state.toString() + " " + type.toString() + ", " + severity.toString();
    }

    public static String getLozengeClass(TicketModel.Status status, boolean subtle) {
        if (status == null) {
            status = TicketModel.Status.New;
        }
        String css = "";
        switch (status) {
            case Declined: 
            case Duplicate: 
            case Invalid: 
            case Wontfix: 
            case Abandoned: {
                css = "aui-lozenge-error";
                break;
            }
            case Fixed: 
            case Merged: 
            case Resolved: {
                css = "aui-lozenge-success";
                break;
            }
            case New: {
                css = "aui-lozenge-complete";
                break;
            }
            case On_Hold: 
            case No_Change_Required: {
                css = "aui-lozenge-current";
                break;
            }
            default: {
                css = "";
            }
        }
        return "aui-lozenge" + (subtle ? " aui-lozenge-subtle" : "") + (css.isEmpty() ? "" : " ") + css;
    }

    public static String getStatusClass(TicketModel.Status status) {
        String css = "";
        switch (status) {
            case Declined: 
            case Duplicate: 
            case Invalid: 
            case Wontfix: 
            case Abandoned: {
                css = "resolution-error";
                break;
            }
            case Fixed: 
            case Merged: 
            case Resolved: {
                css = "resolution-success";
                break;
            }
            case New: {
                css = "resolution-complete";
                break;
            }
            case On_Hold: 
            case No_Change_Required: {
                css = "resolution-current";
                break;
            }
            default: {
                css = "";
            }
        }
        return "resolution" + (css.isEmpty() ? "" : " ") + css;
    }

    public static class TicketQuery
    implements Serializable,
    Comparable<TicketQuery> {
        private static final long serialVersionUID = 1L;
        public final String name;
        public final String query;
        public String color;

        public TicketQuery(String name, String query) {
            this.name = name;
            this.query = query;
        }

        public TicketQuery color(String value) {
            this.color = value;
            return this;
        }

        public boolean equals(Object o) {
            if (o instanceof TicketQuery) {
                return ((TicketQuery)o).query.equals(this.query);
            }
            return false;
        }

        public int hashCode() {
            return this.query.hashCode();
        }

        @Override
        public int compareTo(TicketQuery o) {
            return this.query.compareTo(o.query);
        }
    }

    public static class Indicator
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final String css;
        public final int count;
        public final String tooltip;

        public Indicator(String css, String tooltip) {
            this.css = css;
            this.tooltip = tooltip;
            this.count = 0;
        }

        public Indicator(String css, int count, String pattern) {
            this.css = css;
            this.count = count;
            this.tooltip = StringUtils.isEmpty(pattern) ? "" : MessageFormat.format(pattern, count);
        }

        public String getTooltip() {
            return this.tooltip;
        }
    }

    public static class TicketSort
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final String name;
        public final String sortBy;
        public final boolean desc;

        public TicketSort(String name, String sortBy, boolean desc) {
            this.name = name;
            this.sortBy = sortBy;
            this.desc = desc;
        }
    }
}

