/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket;

import com.gitblit.Constants;
import com.gitblit.IStoredSettings;
import com.gitblit.models.FederationModel;
import com.gitblit.models.Metric;
import com.gitblit.utils.DiffUtils;
import com.gitblit.utils.HttpUtils;
import com.gitblit.utils.StringUtils;
import com.gitblit.utils.TimeUtils;
import com.gitblit.wicket.GitBlitWebApp;
import com.gitblit.wicket.MarkupProcessor;
import com.gitblit.wicket.TicketsUI;
import java.io.Serializable;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.Request;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.HeaderContributor;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.behavior.SimpleAttributeModifier;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.image.ContextImage;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.protocol.http.WebRequest;
import org.apache.wicket.resource.ContextRelativeResource;
import org.eclipse.jgit.diff.DiffEntry;

public class WicketUtils {
    public static void setCssClass(Component container2, String value) {
        container2.add(new IBehavior[]{new SimpleAttributeModifier("class", (CharSequence)value)});
    }

    public static void addCssClass(Component container2, String value) {
        container2.add(new IBehavior[]{new AttributeAppender("class", (IModel)new Model((Serializable)((Object)value)), " ")});
    }

    public static void setCssStyle(Component container2, String value) {
        container2.add(new IBehavior[]{new SimpleAttributeModifier("style", (CharSequence)value)});
    }

    public static void setCssBackground(Component container2, String value) {
        String background = MessageFormat.format("background-color:{0};", StringUtils.getColor(value));
        container2.add(new IBehavior[]{new SimpleAttributeModifier("style", (CharSequence)background)});
    }

    public static Component setHtmlTooltip(Component container2, String value) {
        return container2.add(new IBehavior[]{new SimpleAttributeModifier("title", (CharSequence)value)});
    }

    public static void setInputPlaceholder(Component container2, String value) {
        container2.add(new IBehavior[]{new SimpleAttributeModifier("placeholder", (CharSequence)value)});
    }

    public static void setChangeTypeCssClass(Component container2, DiffEntry.ChangeType type) {
        switch (type) {
            case ADD: {
                WicketUtils.setCssClass(container2, "addition");
                break;
            }
            case COPY: 
            case RENAME: {
                WicketUtils.setCssClass(container2, "rename");
                break;
            }
            case DELETE: {
                WicketUtils.setCssClass(container2, "deletion");
                break;
            }
            case MODIFY: {
                WicketUtils.setCssClass(container2, "modification");
            }
        }
    }

    public static void setPermissionClass(Component container2, Constants.AccessPermission permission) {
        if (permission == null) {
            WicketUtils.setCssClass(container2, "badge");
            return;
        }
        switch (permission) {
            case REWIND: 
            case DELETE: 
            case CREATE: {
                WicketUtils.setCssClass(container2, "badge badge-success");
                break;
            }
            case PUSH: {
                WicketUtils.setCssClass(container2, "badge badge-info");
                break;
            }
            case CLONE: {
                WicketUtils.setCssClass(container2, "badge badge-inverse");
                break;
            }
            default: {
                WicketUtils.setCssClass(container2, "badge");
            }
        }
    }

    public static void setAlternatingBackground(Component c, int i) {
        String clazz = i % 2 == 0 ? "light" : "dark";
        WicketUtils.setCssClass(c, clazz);
    }

    public static Label createAuthorLabel(String wicketId, String author) {
        Label label = new Label(wicketId, author);
        WicketUtils.setHtmlTooltip((Component)label, author);
        return label;
    }

    public static ContextImage getPullStatusImage(String wicketId, Constants.FederationPullStatus status) {
        String filename = null;
        switch (status) {
            case MIRRORED: 
            case PULLED: {
                filename = "bullet_green.png";
                break;
            }
            case SKIPPED: {
                filename = "bullet_yellow.png";
                break;
            }
            case FAILED: {
                filename = "bullet_red.png";
                break;
            }
            case EXCLUDED: {
                filename = "bullet_white.png";
                break;
            }
            default: {
                filename = "bullet_black.png";
            }
        }
        return WicketUtils.newImage(wicketId, filename, status.name());
    }

    public static ContextImage getFileImage(String wicketId, String filename) {
        if ((filename = filename.toLowerCase()).endsWith(".java")) {
            return WicketUtils.newImage(wicketId, "file_java_16x16.png");
        }
        if (filename.endsWith(".rb")) {
            return WicketUtils.newImage(wicketId, "file_ruby_16x16.png");
        }
        if (filename.endsWith(".php")) {
            return WicketUtils.newImage(wicketId, "file_php_16x16.png");
        }
        if (filename.endsWith(".cs")) {
            return WicketUtils.newImage(wicketId, "file_cs_16x16.png");
        }
        if (filename.endsWith(".cpp")) {
            return WicketUtils.newImage(wicketId, "file_cpp_16x16.png");
        }
        if (filename.endsWith(".c")) {
            return WicketUtils.newImage(wicketId, "file_c_16x16.png");
        }
        if (filename.endsWith(".h")) {
            return WicketUtils.newImage(wicketId, "file_h_16x16.png");
        }
        if (filename.endsWith(".sln")) {
            return WicketUtils.newImage(wicketId, "file_vs_16x16.png");
        }
        if (filename.endsWith(".csv") || filename.endsWith(".xls") || filename.endsWith(".xlsx")) {
            return WicketUtils.newImage(wicketId, "file_excel_16x16.png");
        }
        if (filename.endsWith(".doc") || filename.endsWith(".docx")) {
            return WicketUtils.newImage(wicketId, "file_doc_16x16.png");
        }
        if (filename.endsWith(".ppt") || filename.endsWith(".pptx")) {
            return WicketUtils.newImage(wicketId, "file_ppt_16x16.png");
        }
        if (filename.endsWith(".zip")) {
            return WicketUtils.newImage(wicketId, "file_zip_16x16.png");
        }
        if (filename.endsWith(".pdf")) {
            return WicketUtils.newImage(wicketId, "file_acrobat_16x16.png");
        }
        if (filename.endsWith(".htm") || filename.endsWith(".html")) {
            return WicketUtils.newImage(wicketId, "file_world_16x16.png");
        }
        if (filename.endsWith(".xml")) {
            return WicketUtils.newImage(wicketId, "file_code_16x16.png");
        }
        if (filename.endsWith(".properties")) {
            return WicketUtils.newImage(wicketId, "file_settings_16x16.png");
        }
        String ext = StringUtils.getFileExtension(filename).toLowerCase();
        IStoredSettings settings = GitBlitWebApp.get().settings();
        if (MarkupProcessor.getMarkupExtensions(settings).contains(ext)) {
            return WicketUtils.newImage(wicketId, "file_world_16x16.png");
        }
        return WicketUtils.newImage(wicketId, "file_16x16.png");
    }

    public static ContextImage getRegistrationImage(String wicketId, FederationModel registration, Component c) {
        if (registration.isResultData()) {
            return WicketUtils.newImage(wicketId, "information_16x16.png", c.getString("gb.federationResults"));
        }
        return WicketUtils.newImage(wicketId, "arrow_left.png", c.getString("gb.federationRegistration"));
    }

    public static ContextImage newClearPixel(String wicketId) {
        return WicketUtils.newImage(wicketId, "pixel.png");
    }

    public static ContextImage newBlankImage(String wicketId) {
        return WicketUtils.newImage(wicketId, "blank.png");
    }

    public static ContextImage newImage(String wicketId, String file) {
        return WicketUtils.newImage(wicketId, file, null);
    }

    public static ContextImage newImage(String wicketId, String file, String tooltip) {
        ContextImage img = new ContextImage(wicketId, file);
        if (!StringUtils.isEmpty(tooltip)) {
            WicketUtils.setHtmlTooltip((Component)img, tooltip);
        }
        return img;
    }

    public static Label newIcon(String wicketId, String css) {
        Label lbl = new Label(wicketId);
        WicketUtils.setCssClass((Component)lbl, css);
        return lbl;
    }

    public static Label newBlankIcon(String wicketId) {
        Label lbl = new Label(wicketId);
        WicketUtils.setCssClass((Component)lbl, "");
        lbl.setRenderBodyOnly(true);
        return lbl;
    }

    public static ContextRelativeResource getResource(String file) {
        return new ContextRelativeResource(file);
    }

    public static String getGitblitURL(Request request) {
        HttpServletRequest req = ((WebRequest)request).getHttpServletRequest();
        return HttpUtils.getGitblitURL(req);
    }

    public static HeaderContributor syndicationDiscoveryLink(final String feedTitle, final String url) {
        return new HeaderContributor(new IHeaderContributor(){
            private static final long serialVersionUID = 1L;

            public void renderHead(IHeaderResponse response) {
                String contentType = "application/rss+xml";
                StringBuilder buffer = new StringBuilder();
                buffer.append("<link rel=\"alternate\" ");
                buffer.append("type=\"").append(contentType).append("\" ");
                buffer.append("title=\"").append(feedTitle).append("\" ");
                buffer.append("href=\"").append(url).append("\" />");
                response.renderString((CharSequence)buffer.toString());
            }
        });
    }

    public static PageParameters newTokenParameter(String token) {
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        parameterMap.put("t", token);
        return new PageParameters(parameterMap);
    }

    public static PageParameters newRegistrationParameter(String url, String name) {
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        parameterMap.put("u", url);
        parameterMap.put("n", name);
        return new PageParameters(parameterMap);
    }

    public static PageParameters newUsernameParameter(String username) {
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        parameterMap.put("user", username);
        return new PageParameters(parameterMap);
    }

    public static PageParameters newTeamnameParameter(String teamname) {
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        parameterMap.put("team", teamname);
        return new PageParameters(parameterMap);
    }

    public static PageParameters newProjectParameter(String projectName) {
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        parameterMap.put("p", projectName);
        return new PageParameters(parameterMap);
    }

    public static PageParameters newRepositoryParameter(String repositoryName) {
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        if (!StringUtils.isEmpty(repositoryName)) {
            parameterMap.put("r", repositoryName);
        }
        return new PageParameters(parameterMap);
    }

    public static PageParameters newObjectParameter(String objectId) {
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        parameterMap.put("h", objectId);
        return new PageParameters(parameterMap);
    }

    public static PageParameters newObjectParameter(String repositoryName, String objectId) {
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        if (StringUtils.isEmpty(objectId)) {
            return WicketUtils.newRepositoryParameter(repositoryName);
        }
        parameterMap.put("r", repositoryName);
        parameterMap.put("h", objectId);
        return new PageParameters(parameterMap);
    }

    public static PageParameters newDiffParameter(String repositoryName, String objectId, DiffUtils.DiffComparator diffComparator) {
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        if (StringUtils.isEmpty(objectId)) {
            return WicketUtils.newRepositoryParameter(repositoryName);
        }
        parameterMap.put("r", repositoryName);
        parameterMap.put("h", objectId);
        parameterMap.put("w", "" + diffComparator.ordinal());
        return new PageParameters(parameterMap);
    }

    public static PageParameters newDiffParameter(String repositoryName, String objectId, DiffUtils.DiffComparator diffComparator, String blobPath) {
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        if (StringUtils.isEmpty(objectId)) {
            return WicketUtils.newRepositoryParameter(repositoryName);
        }
        parameterMap.put("r", repositoryName);
        parameterMap.put("h", objectId);
        parameterMap.put("w", "" + diffComparator.ordinal());
        parameterMap.put("f", blobPath);
        return new PageParameters(parameterMap);
    }

    public static PageParameters newRangeParameter(String repositoryName, String startRange, String endRange) {
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        parameterMap.put("r", repositoryName);
        parameterMap.put("h", startRange + ".." + endRange);
        return new PageParameters(parameterMap);
    }

    public static PageParameters newPathParameter(String repositoryName, String objectId, String path) {
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        if (StringUtils.isEmpty(path)) {
            return WicketUtils.newObjectParameter(repositoryName, objectId);
        }
        if (StringUtils.isEmpty(objectId)) {
            parameterMap.put("r", repositoryName);
            parameterMap.put("f", path);
            return new PageParameters(parameterMap);
        }
        parameterMap.put("r", repositoryName);
        parameterMap.put("h", objectId);
        parameterMap.put("f", path);
        return new PageParameters(parameterMap);
    }

    public static PageParameters newLogPageParameter(String repositoryName, String objectId, int pageNumber) {
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        if (pageNumber <= 1) {
            return WicketUtils.newObjectParameter(repositoryName, objectId);
        }
        if (StringUtils.isEmpty(objectId)) {
            parameterMap.put("r", repositoryName);
            parameterMap.put("pg", String.valueOf(pageNumber));
            return new PageParameters(parameterMap);
        }
        parameterMap.put("r", repositoryName);
        parameterMap.put("h", objectId);
        parameterMap.put("pg", String.valueOf(pageNumber));
        return new PageParameters(parameterMap);
    }

    public static PageParameters newHistoryPageParameter(String repositoryName, String objectId, String path, int pageNumber) {
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        if (pageNumber <= 1) {
            return WicketUtils.newObjectParameter(repositoryName, objectId);
        }
        if (StringUtils.isEmpty(objectId)) {
            parameterMap.put("r", repositoryName);
            parameterMap.put("f", path);
            parameterMap.put("pg", String.valueOf(pageNumber));
            return new PageParameters(parameterMap);
        }
        parameterMap.put("r", repositoryName);
        parameterMap.put("h", objectId);
        parameterMap.put("f", path);
        parameterMap.put("pg", String.valueOf(pageNumber));
        return new PageParameters(parameterMap);
    }

    public static PageParameters newFilestorePageParameter(int pageNumber, String filter) {
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        if (pageNumber > 1) {
            parameterMap.put("pg", String.valueOf(pageNumber));
        }
        if (filter != null) {
            parameterMap.put("s", String.valueOf(filter));
        }
        return new PageParameters(parameterMap);
    }

    public static PageParameters newBlobDiffParameter(String repositoryName, String baseCommitId, String commitId, String path) {
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        if (StringUtils.isEmpty(commitId)) {
            parameterMap.put("r", repositoryName);
            parameterMap.put("f", path);
            parameterMap.put("hb", baseCommitId);
            return new PageParameters(parameterMap);
        }
        parameterMap.put("r", repositoryName);
        parameterMap.put("h", commitId);
        parameterMap.put("f", path);
        parameterMap.put("hb", baseCommitId);
        return new PageParameters(parameterMap);
    }

    public static PageParameters newSearchParameter(String repositoryName, String commitId, String search, Constants.SearchType type) {
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        if (StringUtils.isEmpty(commitId)) {
            parameterMap.put("r", repositoryName);
            parameterMap.put("s", search);
            parameterMap.put("st", type.name());
            return new PageParameters(parameterMap);
        }
        parameterMap.put("r", repositoryName);
        parameterMap.put("h", commitId);
        parameterMap.put("s", search);
        parameterMap.put("st", type.name());
        return new PageParameters(parameterMap);
    }

    public static PageParameters newSearchParameter(String repositoryName, String commitId, String search, Constants.SearchType type, int pageNumber) {
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        if (StringUtils.isEmpty(commitId)) {
            parameterMap.put("r", repositoryName);
            parameterMap.put("s", search);
            parameterMap.put("st", type.name());
            parameterMap.put("pg", String.valueOf(pageNumber));
            return new PageParameters(parameterMap);
        }
        parameterMap.put("r", repositoryName);
        parameterMap.put("h", commitId);
        parameterMap.put("s", search);
        parameterMap.put("st", type.name());
        parameterMap.put("pg", String.valueOf(pageNumber));
        return new PageParameters(parameterMap);
    }

    public static PageParameters newBlameTypeParameter(String repositoryName, String commitId, String path, String blameType) {
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        parameterMap.put("r", repositoryName);
        parameterMap.put("h", commitId);
        parameterMap.put("f", path);
        parameterMap.put("blametype", blameType);
        return new PageParameters(parameterMap);
    }

    public static PageParameters newTicketsParameters(String repositoryName, String ... states) {
        PageParameters tParams = WicketUtils.newRepositoryParameter(repositoryName);
        if (states != null) {
            for (String state : states) {
                tParams.add("status", state);
            }
        }
        return tParams;
    }

    public static PageParameters newOpenTicketsParameter(String repositoryName) {
        return WicketUtils.newTicketsParameters(repositoryName, TicketsUI.openStatii);
    }

    public static String getProjectName(PageParameters params) {
        return params.getString("p", "");
    }

    public static String getRepositoryName(PageParameters params) {
        return params.getString("r", "");
    }

    public static String getObject(PageParameters params) {
        return params.getString("h", null);
    }

    public static String getPath(PageParameters params) {
        return params.getString("f", null);
    }

    public static String getBaseObjectId(PageParameters params) {
        return params.getString("hb", null);
    }

    public static String getSearchString(PageParameters params) {
        return params.getString("s", null);
    }

    public static String getSearchType(PageParameters params) {
        return params.getString("st", null);
    }

    public static DiffUtils.DiffComparator getDiffComparator(PageParameters params) {
        int ordinal = params.getInt("w", 0);
        return DiffUtils.DiffComparator.values()[ordinal];
    }

    public static int getPage(PageParameters params) {
        return params.getInt("pg", 1);
    }

    public static String getRegEx(PageParameters params) {
        return params.getString("x", "");
    }

    public static String getSet(PageParameters params) {
        return params.getString("set", "");
    }

    public static String getTeam(PageParameters params) {
        return params.getString("team", "");
    }

    public static int getDaysBack(PageParameters params) {
        return params.getInt("db", 0);
    }

    public static String getUsername(PageParameters params) {
        return params.getString("user", "");
    }

    public static String getTeamname(PageParameters params) {
        return params.getString("team", "");
    }

    public static String getToken(PageParameters params) {
        return params.getString("t", "");
    }

    public static String getUrlParameter(PageParameters params) {
        return params.getString("u", "");
    }

    public static String getNameParameter(PageParameters params) {
        return params.getString("n", "");
    }

    public static Label createDateLabel(String wicketId, Date date, TimeZone timeZone, TimeUtils timeUtils) {
        return WicketUtils.createDateLabel(wicketId, date, timeZone, timeUtils, true);
    }

    public static Label createDateLabel(String wicketId, Date date, TimeZone timeZone, TimeUtils timeUtils, boolean setCss) {
        String format = GitBlitWebApp.get().settings().getString("web.datestampShortFormat", "MM/dd/yy");
        SimpleDateFormat df = new SimpleDateFormat(format);
        if (timeZone == null) {
            timeZone = GitBlitWebApp.get().getTimezone();
        }
        df.setTimeZone(timeZone);
        String dateString = date.getTime() == 0L ? "--" : df.format(date);
        String title = null;
        if (date.getTime() <= System.currentTimeMillis()) {
            title = timeUtils.timeAgo(date);
        }
        if (title != null && System.currentTimeMillis() - date.getTime() < 864000000L) {
            String tmp = dateString;
            dateString = title;
            title = tmp;
        }
        Label label = new Label(wicketId, dateString);
        if (setCss) {
            WicketUtils.setCssClass((Component)label, timeUtils.timeAgoCss(date));
        }
        if (!StringUtils.isEmpty(title)) {
            WicketUtils.setHtmlTooltip((Component)label, title);
        }
        return label;
    }

    public static Label createTimeLabel(String wicketId, Date date, TimeZone timeZone, TimeUtils timeUtils) {
        String format = GitBlitWebApp.get().settings().getString("web.timeFormat", "HH:mm");
        SimpleDateFormat df = new SimpleDateFormat(format);
        if (timeZone == null) {
            timeZone = GitBlitWebApp.get().getTimezone();
        }
        df.setTimeZone(timeZone);
        String timeString = date.getTime() == 0L ? "--" : df.format(date);
        String title = timeUtils.timeAgo(date);
        Label label = new Label(wicketId, timeString);
        if (!StringUtils.isEmpty(title)) {
            WicketUtils.setHtmlTooltip((Component)label, title);
        }
        return label;
    }

    public static Label createDatestampLabel(String wicketId, Date date, TimeZone timeZone, TimeUtils timeUtils) {
        String format = GitBlitWebApp.get().settings().getString("web.datestampLongFormat", "EEEE, MMMM d, yyyy");
        SimpleDateFormat df = new SimpleDateFormat(format);
        if (timeZone == null) {
            timeZone = GitBlitWebApp.get().getTimezone();
        }
        df.setTimeZone(timeZone);
        String dateString = date.getTime() == 0L ? "--" : df.format(date);
        String title = null;
        title = TimeUtils.isToday(date, timeZone) ? timeUtils.today() : (TimeUtils.isYesterday(date, timeZone) ? timeUtils.yesterday() : (date.getTime() <= System.currentTimeMillis() ? timeUtils.timeAgo(date) : timeUtils.inFuture(date)));
        if (System.currentTimeMillis() - date.getTime() < 864000000L) {
            String tmp = dateString;
            dateString = title;
            title = tmp;
        }
        Label label = new Label(wicketId, dateString);
        if (!StringUtils.isEmpty(title)) {
            WicketUtils.setHtmlTooltip((Component)label, title);
        }
        return label;
    }

    public static Label createTimestampLabel(String wicketId, Date date, TimeZone timeZone, TimeUtils timeUtils) {
        String format = GitBlitWebApp.get().settings().getString("web.datetimestampLongFormat", "EEEE, MMMM d, yyyy HH:mm Z");
        SimpleDateFormat df = new SimpleDateFormat(format);
        if (timeZone == null) {
            timeZone = GitBlitWebApp.get().getTimezone();
        }
        df.setTimeZone(timeZone);
        String dateString = date.getTime() == 0L ? "--" : df.format(date);
        String title = null;
        if (date.getTime() <= System.currentTimeMillis()) {
            title = timeUtils.timeAgo(date);
        }
        Label label = new Label(wicketId, dateString);
        if (!StringUtils.isEmpty(title)) {
            WicketUtils.setHtmlTooltip((Component)label, title);
        }
        return label;
    }

    public static double maxValue(Collection<Metric> metrics) {
        double max = Double.MIN_VALUE;
        for (Metric m : metrics) {
            if (!(m.count > max)) continue;
            max = m.count;
        }
        return max;
    }
}

