/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.charting;

import com.gitblit.wicket.charting.Chart;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;

public class Flotr2BarChart
extends Chart {
    private static final long serialVersionUID = 1L;
    boolean xAxisIsDate = false;

    public Flotr2BarChart(String tagId, String title, String keyName, String valueName) {
        super(tagId, title, keyName, valueName);
    }

    @Override
    protected void appendChart(StringBuilder sb) {
        String dName = "data_" + this.dataName;
        sb.append("var labels_" + this.dataName + " = [");
        if (this.xAxisIsDate) {
            SimpleDateFormat df = new SimpleDateFormat(this.dateFormat);
            df.setTimeZone(this.getTimeZone());
            Collections.sort(this.values, new Comparator<Chart.ChartValue>(){

                @Override
                public int compare(Chart.ChartValue o1, Chart.ChartValue o2) {
                    long long1 = Long.parseLong(o1.name);
                    long long2 = Long.parseLong(o2.name);
                    return (int)(long2 - long1);
                }
            });
            for (int i = 0; i < this.values.size(); ++i) {
                Chart.ChartValue value = (Chart.ChartValue)this.values.get(i);
                Date date = new Date(Long.parseLong(value.name));
                String label = df.format(date);
                if (i > 0) {
                    sb.append(",");
                }
                sb.append("[\"" + label + "\", " + value.name + "]");
            }
        } else {
            for (int i = 0; i < this.values.size(); ++i) {
                Chart.ChartValue value = (Chart.ChartValue)this.values.get(i);
                if (i > 0) {
                    sb.append(",");
                }
                sb.append("\"" + value.name + "\"");
            }
        }
        this.line(sb, "];");
        this.line(sb, MessageFormat.format("var {0} = Flotr.draw(document.getElementById(''{1}''),", dName, this.tagId));
        this.line(sb, "[");
        this.line(sb, "{ data : [ ");
        for (int i = 0; i < this.values.size(); ++i) {
            Chart.ChartValue value = (Chart.ChartValue)this.values.get(i);
            if (i > 0) {
                sb.append(",");
            }
            if (this.xAxisIsDate) {
                this.line(sb, MessageFormat.format("[{0}, {1}] ", value.name, Float.toString(value.value)));
                continue;
            }
            this.line(sb, MessageFormat.format("[{0}, {1}] ", Integer.toString(i), Float.toString(value.value)));
        }
        this.line(sb, MessageFormat.format(" ], label : \"{0}\", color: ''#FF9900'' '}'", this.valueName));
        this.line(sb, "]");
        this.line(sb, ", {");
        if (this.title != null && !this.title.isEmpty()) {
            this.line(sb, MessageFormat.format("title : \"{0}\",", this.title));
        }
        this.line(sb, "bars : {");
        this.line(sb, "  show : true,");
        this.line(sb, "  horizontal : false,");
        this.line(sb, "  barWidth : 1");
        this.line(sb, "},");
        this.line(sb, "points: { show: false },");
        this.line(sb, "mouse: {");
        this.line(sb, "  track: true,");
        this.line(sb, "  lineColor: '#002060',");
        this.line(sb, "  position: 'ne',");
        this.line(sb, "  trackFormatter: function (obj) {");
        this.line(sb, "    return labels_" + this.dataName + "[obj.index] + ': ' + parseInt(obj.y) + ' ' +  obj.series.label;");
        this.line(sb, "  }");
        this.line(sb, "},");
        this.line(sb, "xaxis: {");
        this.line(sb, "  showLabels: true,");
        this.line(sb, "  showMinorLabels: false,");
        this.line(sb, "  tickFormatter: function (x) {");
        this.line(sb, "   var index = parseInt(x);");
        this.line(sb, "    if(x % 1 == 0 && labels_" + this.dataName + "[index])");
        this.line(sb, "      return labels_" + this.dataName + "[index];");
        this.line(sb, "    return \"\";");
        this.line(sb, "  },");
        this.line(sb, "  margin: 10");
        this.line(sb, "},");
        this.line(sb, "yaxis: {");
        this.line(sb, "  showLabels: false,");
        this.line(sb, "  showMinorLabels: false,");
        this.line(sb, "  tickDecimals: 0,");
        this.line(sb, "  margin: 10");
        this.line(sb, "},");
        this.line(sb, "grid: {");
        this.line(sb, "  verticalLines: false,");
        this.line(sb, "  minorVerticalLines: null,");
        this.line(sb, "  horizontalLines: true,");
        this.line(sb, "  minorHorizontalLines: null,");
        this.line(sb, "  outlineWidth: 1,");
        this.line(sb, "  outline: 's'");
        this.line(sb, "},");
        this.line(sb, "legend: {");
        this.line(sb, "  show: false");
        this.line(sb, "}");
        this.line(sb, "});");
    }

    @Override
    public void addValue(Date date, int value) {
        this.xAxisIsDate = true;
        String name = String.valueOf(date.getTime());
        super.addValue(name, value);
    }
}

