/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.charting;

import com.gitblit.wicket.charting.Chart;
import com.gitblit.wicket.charting.Charts;
import com.gitblit.wicket.charting.Flotr2BarChart;
import com.gitblit.wicket.charting.Flotr2LineChart;
import com.gitblit.wicket.charting.Flotr2PieChart;
import javax.servlet.ServletContext;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.protocol.http.WebApplication;

public class Flotr2Charts
extends Charts {
    private static final long serialVersionUID = 1L;

    public void renderHead(IHeaderResponse response) {
        ServletContext servletContext = WebApplication.get().getServletContext();
        String contextPath = servletContext.getContextPath();
        response.renderJavascriptReference(contextPath + "/bootstrap/js/jquery.js");
        response.renderJavascriptReference(contextPath + "/flotr2/flotr2.min.js");
        response.renderCSSReference(contextPath + "/flotr2/flotr2.custom.css");
        StringBuilder sb = new StringBuilder();
        this.line(sb, "$( document ).ready(function() {");
        this.line(sb, "try {");
        for (Chart chart : this.charts) {
            chart.appendChart(sb);
        }
        this.line(sb, "} catch (exception) {");
        this.line(sb, "  if (window.console && window.console.log) {");
        this.line(sb, "    window.console.log('flotr2 exception');");
        this.line(sb, "    window.console.log(exception);");
        this.line(sb, "  }");
        this.line(sb, "}");
        this.line(sb, "});");
        response.renderJavascript((CharSequence)sb.toString(), null);
    }

    @Override
    public Chart createPieChart(String tagId, String title, String keyName, String valueName) {
        return new Flotr2PieChart(tagId, title, keyName, valueName);
    }

    @Override
    public Chart createLineChart(String tagId, String title, String keyName, String valueName) {
        return new Flotr2LineChart(tagId, title, keyName, valueName);
    }

    @Override
    public Chart createBarChart(String tagId, String title, String keyName, String valueName) {
        return new Flotr2BarChart(tagId, title, keyName, valueName);
    }
}

