/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.charting;

import com.gitblit.wicket.charting.Chart;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Flotr2LineChart
extends Chart {
    private static final long serialVersionUID = 1L;
    boolean xAxisIsDate = false;

    public Flotr2LineChart(String tagId, String title, String keyName, String valueName) {
        super(tagId, title, keyName, valueName);
    }

    @Override
    protected void appendChart(StringBuilder sb) {
        int i;
        String dName = "data_" + this.dataName;
        sb.append("var labels_" + this.dataName + " = [");
        if (this.xAxisIsDate) {
            SimpleDateFormat df = new SimpleDateFormat(this.dateFormat);
            df.setTimeZone(this.getTimeZone());
            for (int i2 = 0; i2 < this.values.size(); ++i2) {
                Chart.ChartValue value = (Chart.ChartValue)this.values.get(i2);
                Date date = new Date(Long.parseLong(value.name));
                String label = df.format(date);
                if (i2 > 0) {
                    sb.append(",");
                }
                sb.append("\"" + label + "\"");
            }
        } else {
            for (int i3 = 0; i3 < this.values.size(); ++i3) {
                Chart.ChartValue value = (Chart.ChartValue)this.values.get(i3);
                if (i3 > 0) {
                    sb.append(",");
                }
                sb.append("\"" + value.name + "\"");
            }
        }
        this.line(sb, "];");
        this.line(sb, MessageFormat.format("var {0} = Flotr.draw(document.getElementById(''{1}''),", dName, this.tagId));
        this.line(sb, "[");
        this.line(sb, "{ data : [ ");
        for (i = 0; i < this.values.size(); ++i) {
            Chart.ChartValue value = (Chart.ChartValue)this.values.get(i);
            if (i > 0) {
                sb.append(",");
            }
            this.line(sb, MessageFormat.format("[{0}, {1}] ", value.name, Float.toString(value.value)));
        }
        this.line(sb, MessageFormat.format(" ], label : \"{0}\", lines : '{' show : true '}', color: ''#ff9900'' '}'", this.valueName));
        if (this.highlights.size() > 0) {
            this.line(sb, ", { data : [ ");
            for (i = 0; i < this.highlights.size(); ++i) {
                Chart.ChartValue value = (Chart.ChartValue)this.highlights.get(i);
                if (i > 0) {
                    sb.append(",");
                }
                this.line(sb, MessageFormat.format("[{0}, {1}] ", value.name, Float.toString(value.value)));
            }
            this.line(sb, MessageFormat.format(" ], label : \"{0}\", points : '{' show : true, fill: true, fillColor:''#002060'' '}', color: ''#ff9900'' '}'", this.valueName));
        }
        this.line(sb, "]");
        this.line(sb, ", {");
        if (this.title != null && !this.title.isEmpty()) {
            this.line(sb, MessageFormat.format("title : \"{0}\",", this.title));
        }
        this.line(sb, "mouse: {");
        this.line(sb, "  track: true,");
        this.line(sb, "  lineColor: '#002060',");
        this.line(sb, "  position: 'ne',");
        this.line(sb, "  trackFormatter: function (obj) {");
        this.line(sb, "    return labels_" + this.dataName + "[obj.index] + ': ' + parseInt(obj.y) + ' ' +  obj.series.label;");
        this.line(sb, "  }");
        this.line(sb, "},");
        this.line(sb, "xaxis: {");
        this.line(sb, "  showLabels: false,");
        this.line(sb, "  showMinorLabels: false,");
        this.line(sb, "  autoscale: true,");
        this.line(sb, "  autoscaleMargin: 0,");
        this.line(sb, "  margin: 10");
        this.line(sb, "},");
        this.line(sb, "yaxis: {");
        this.line(sb, "  showLabels: false,");
        this.line(sb, "  showMinorLabels: false,");
        this.line(sb, "  tickDecimals: 0,");
        this.line(sb, "  autoscale: true,");
        this.line(sb, "  autoscaleMargin: 1,");
        this.line(sb, "  margin: 10");
        this.line(sb, "},");
        this.line(sb, "grid: {");
        this.line(sb, "  verticalLines: false,");
        this.line(sb, "  minorVerticalLines: null,");
        this.line(sb, "  horizontalLines: true,");
        this.line(sb, "  minorHorizontalLines: null,");
        this.line(sb, "  outlineWidth: 1,");
        this.line(sb, "  outline: 's'");
        this.line(sb, "},");
        this.line(sb, "legend: {");
        this.line(sb, "  show: false");
        this.line(sb, "}");
        this.line(sb, "});");
    }

    @Override
    public void addValue(Date date, int value) {
        this.xAxisIsDate = true;
        super.addValue(date, value);
    }
}

