/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.servlet.RawServlet;
import com.gitblit.utils.JGitUtils;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.CacheControl;
import com.gitblit.wicket.ExternalImage;
import com.gitblit.wicket.MarkupProcessor;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.BasePage;
import com.gitblit.wicket.pages.BlamePage;
import com.gitblit.wicket.pages.DocPage;
import com.gitblit.wicket.pages.HistoryPage;
import com.gitblit.wicket.pages.RepositoryPage;
import com.gitblit.wicket.pages.TreePage;
import com.gitblit.wicket.panels.CommitHeaderPanel;
import com.gitblit.wicket.panels.PathBreadcrumbsPanel;
import java.text.MessageFormat;
import java.util.HashMap;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.RedirectException;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.link.ExternalLink;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;

@CacheControl(value=CacheControl.LastModified.BOOT)
public class BlobPage
extends RepositoryPage {
    protected String fileExtension;

    public BlobPage(PageParameters params) {
        super(params);
        Repository r = this.getRepository();
        String blobPath = WicketUtils.getPath(params);
        String[] encodings = this.getEncodings();
        if (StringUtils.isEmpty(this.objectId) && StringUtils.isEmpty(blobPath)) {
            throw new RedirectException(TreePage.class, WicketUtils.newRepositoryParameter(this.repositoryName));
        }
        if (StringUtils.isEmpty(blobPath)) {
            this.add(new Component[]{new BookmarkablePageLink("blameLink", BlamePage.class, WicketUtils.newPathParameter(this.repositoryName, this.objectId, blobPath)).setEnabled(false)});
            this.add(new Component[]{new BookmarkablePageLink("historyLink", HistoryPage.class).setEnabled(false)});
            String rawUrl = RawServlet.asLink(this.getContextUrl(), this.repositoryName, this.objectId, blobPath);
            this.add(new Component[]{new ExternalLink("rawLink", rawUrl)});
            this.add(new Component[]{new CommitHeaderPanel("commitHeader", this.objectId)});
            this.add(new Component[]{new PathBreadcrumbsPanel("breadcrumbs", this.repositoryName, blobPath, this.objectId)});
            Label c = new Label("blobText", JGitUtils.getStringContent(r, this.objectId, encodings));
            WicketUtils.setCssClass((Component)c, "plainprint");
            this.add(new Component[]{c});
        } else {
            String extension = null;
            if (blobPath.lastIndexOf(46) > -1) {
                extension = blobPath.substring(blobPath.lastIndexOf(46) + 1).toLowerCase();
            }
            MarkupProcessor processor = new MarkupProcessor(this.app().settings(), this.app().xssFilter());
            for (String ext : processor.getMarkupExtensions()) {
                if (!ext.equals(extension)) continue;
                this.setResponsePage(DocPage.class, params);
                return;
            }
            RevCommit commit = this.getCommit();
            this.add(new Component[]{new BookmarkablePageLink("blameLink", BlamePage.class, WicketUtils.newPathParameter(this.repositoryName, this.objectId, blobPath))});
            this.add(new Component[]{new BookmarkablePageLink("historyLink", HistoryPage.class, WicketUtils.newPathParameter(this.repositoryName, this.objectId, blobPath))});
            String rawUrl = RawServlet.asLink(this.getContextUrl(), this.repositoryName, this.objectId, blobPath);
            this.add(new Component[]{new ExternalLink("rawLink", rawUrl)});
            this.add(new Component[]{new CommitHeaderPanel("commitHeader", this.repositoryName, commit)});
            this.add(new Component[]{new PathBreadcrumbsPanel("breadcrumbs", this.repositoryName, blobPath, this.objectId)});
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            for (String ext : this.app().settings().getStrings("web.prettyPrintExtensions")) {
                map.put(ext.toLowerCase(), 1);
            }
            for (String ext : this.app().settings().getStrings("web.imageExtensions")) {
                map.put(ext.toLowerCase(), 2);
            }
            for (String ext : this.app().settings().getStrings("web.binaryExtensions")) {
                map.put(ext.toLowerCase(), 3);
            }
            if (extension != null) {
                int type = 0;
                if (map.containsKey(extension)) {
                    type = (Integer)map.get(extension);
                }
                switch (type) {
                    case 2: {
                        this.add(new Component[]{new Label("blobText").setVisible(false)});
                        this.add(new Component[]{new ExternalImage("blobImage", rawUrl)});
                        break;
                    }
                    case 3: {
                        this.add(new Component[]{new Label("blobText", "Binary File")});
                        this.add(new Component[]{new Image("blobImage").setVisible(false)});
                        break;
                    }
                    default: {
                        String table;
                        String source = JGitUtils.getStringContent(r, commit.getTree(), blobPath, encodings);
                        if (source == null) {
                            table = this.missingBlob(blobPath, commit);
                        } else {
                            table = this.generateSourceView(source, extension, type == 1);
                            this.addBottomScriptInline("jQuery(prettyPrint);");
                        }
                        this.add(new Component[]{new Label("blobText", table).setEscapeModelStrings(false)});
                        this.add(new Component[]{new Image("blobImage").setVisible(false)});
                        this.fileExtension = extension;
                        break;
                    }
                }
            } else {
                String table;
                String source = JGitUtils.getStringContent(r, commit.getTree(), blobPath, encodings);
                if (source == null) {
                    table = this.missingBlob(blobPath, commit);
                } else {
                    table = this.generateSourceView(source, null, false);
                    this.addBottomScriptInline("jQuery(prettyPrint);");
                }
                this.add(new Component[]{new Label("blobText", table).setEscapeModelStrings(false)});
                this.add(new Component[]{new Image("blobImage").setVisible(false)});
            }
        }
    }

    protected String missingBlob(String blobPath, RevCommit commit) {
        StringBuilder sb = new StringBuilder();
        sb.append("<div class=\"alert alert-error\">");
        String pattern = this.getString("gb.doesNotExistInTree").replace("{0}", "<b>{0}</b>").replace("{1}", "<b>{1}</b>");
        sb.append(MessageFormat.format(pattern, blobPath, commit.getTree().getId().getName()));
        sb.append("</div>");
        return sb.toString();
    }

    protected String generateSourceView(String source, String extension, boolean prettyPrint) {
        String[] lines = source.split("\n");
        StringBuilder sb = new StringBuilder();
        sb.append("<!-- start blob table -->");
        sb.append("<table width=\"100%\"><tbody><tr>");
        sb.append("<!-- start nums column -->");
        sb.append("<td id=\"nums\">");
        sb.append("<pre>");
        String numPattern = "<span id=\"L{0}\" class=\"jump\"></span><a href=\"#L{0}\">{0}</a>\n";
        for (int i = 0; i < lines.length; ++i) {
            sb.append(MessageFormat.format(numPattern, "" + (i + 1)));
        }
        sb.append("</pre>");
        sb.append("<!-- end nums column -->");
        sb.append("</td>");
        sb.append("<!-- start lines column -->");
        sb.append("<td id=\"lines\">");
        sb.append("<div class=\"sourceview\">");
        if (prettyPrint) {
            sb.append("<pre class=\"prettyprint lang-" + extension + "\">");
        } else {
            sb.append("<pre class=\"plainprint\">");
        }
        int tabLength = this.app().settings().getInteger("web.tabLength", 4);
        lines = StringUtils.escapeForHtml(source, true, tabLength).split("\n");
        sb.append("<table width=\"100%\"><tbody>");
        String linePattern = "<tr class=\"{0}\"><td><div><span class=\"line\">{1}</span></div>\r</tr>";
        for (int i = 0; i < lines.length; ++i) {
            String cssClass;
            String line = lines[i].replace('\r', ' ');
            String string = cssClass = i % 2 == 0 ? "even" : "odd";
            if (StringUtils.isEmpty(line.trim())) {
                line = "&nbsp;";
            }
            sb.append(MessageFormat.format(linePattern, cssClass, line, "" + (i + 1)));
        }
        sb.append("</tbody></table></pre>");
        sb.append("</pre>");
        sb.append("</div>");
        sb.append("</td>");
        sb.append("<!-- end lines column -->");
        sb.append("</tr></tbody></table>");
        sb.append("<!-- end blob table -->");
        return sb.toString();
    }

    @Override
    protected String getPageName() {
        return this.getString("gb.view");
    }

    @Override
    protected boolean isCommitPage() {
        return true;
    }

    @Override
    protected Class<? extends BasePage> getRepoNavPageClass() {
        return TreePage.class;
    }
}

