/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.models.PathModel;
import com.gitblit.models.RefModel;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.SubmoduleModel;
import com.gitblit.servlet.RawServlet;
import com.gitblit.utils.DiffUtils;
import com.gitblit.utils.JGitUtils;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.SessionlessForm;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.BasePage;
import com.gitblit.wicket.pages.BlamePage;
import com.gitblit.wicket.pages.BlobPage;
import com.gitblit.wicket.pages.CommitPage;
import com.gitblit.wicket.pages.HistoryPage;
import com.gitblit.wicket.pages.ImageDiffHandler;
import com.gitblit.wicket.pages.PatchPage;
import com.gitblit.wicket.pages.RepositoryPage;
import com.gitblit.wicket.pages.TreePage;
import com.gitblit.wicket.panels.CommitLegendPanel;
import com.gitblit.wicket.panels.DiffStatPanel;
import com.gitblit.wicket.panels.LinkPanel;
import com.gitblit.wicket.panels.LogPanel;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.IRequestTarget;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.PageParameters;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.link.ExternalLink;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.markup.repeater.data.ListDataProvider;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.protocol.http.RequestUtils;
import org.apache.wicket.request.target.basic.RedirectRequestTarget;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;

public class ComparePage
extends RepositoryPage {
    IModel<String> fromCommitId = new Model((Serializable)((Object)""));
    IModel<String> toCommitId = new Model((Serializable)((Object)""));
    IModel<String> fromRefId = new Model((Serializable)((Object)""));
    IModel<String> toRefId = new Model((Serializable)((Object)""));
    IModel<Boolean> ignoreWhitespace = Model.of((Serializable)Boolean.valueOf(true));

    public ComparePage(PageParameters params) {
        super(params);
        Repository r = this.getRepository();
        RepositoryModel repository = this.getRepositoryModel();
        if (StringUtils.isEmpty(this.objectId)) {
            this.add(new Component[]{new Label("comparison").setVisible(false)});
        } else {
            RevCommit toCommit;
            RevCommit fromCommit;
            Fragment comparison = new Fragment("comparison", "comparisonFragment", (MarkupContainer)this);
            this.add(new Component[]{comparison});
            String[] parts = this.objectId.split("\\.\\.");
            if (parts[0].startsWith("refs/") && parts[1].startsWith("refs/")) {
                this.fromRefId.setObject((Object)parts[0]);
                this.toRefId.setObject((Object)parts[1]);
                fromCommit = this.getCommit(r, (String)this.fromRefId.getObject());
                toCommit = this.getCommit(r, (String)this.toRefId.getObject());
            } else {
                this.fromCommitId.setObject((Object)parts[0]);
                this.toCommitId.setObject((Object)parts[1]);
                fromCommit = this.getCommit(r, (String)this.fromCommitId.getObject());
                toCommit = this.getCommit(r, (String)this.toCommitId.getObject());
            }
            this.getSubmodules(toCommit);
            final String startId = fromCommit.getId().getName();
            final String endId = toCommit.getId().getName();
            this.fromCommitId.setObject((Object)startId);
            this.toCommitId.setObject((Object)endId);
            List<String> imageExtensions = this.app().settings().getStrings("web.imageExtensions");
            ImageDiffHandler handler = new ImageDiffHandler(this, this.repositoryName, fromCommit.getName(), toCommit.getName(), imageExtensions);
            DiffUtils.DiffComparator diffComparator = WicketUtils.getDiffComparator(params);
            int tabLength = this.app().settings().getInteger("web.tabLength", 4);
            DiffUtils.DiffOutput diff = DiffUtils.getDiff(r, fromCommit, toCommit, diffComparator, DiffUtils.DiffOutputType.HTML, (DiffUtils.BinaryDiffHandler)handler, tabLength);
            if (handler.getImgDiffCount() > 0) {
                this.addBottomScript("scripts/imgdiff.js");
            }
            int insertions = 0;
            int deletions = 0;
            for (PathModel.PathChangeModel pcm : diff.stat.paths) {
                insertions += pcm.insertions;
                deletions += pcm.deletions;
            }
            comparison.add(new Component[]{new DiffStatPanel("diffStat", insertions, deletions)});
            comparison.add(new Component[]{new LogPanel("commitList", this.repositoryName, this.objectId, r, 0, 0, repository.showRemoteBranches)});
            comparison.add(new Component[]{new CommitLegendPanel("commitLegend", diff.stat.paths)});
            ListDataProvider pathsDp = new ListDataProvider(diff.stat.paths);
            DataView<PathModel.PathChangeModel> pathsView = new DataView<PathModel.PathChangeModel>("changedPath", (IDataProvider)pathsDp){
                private static final long serialVersionUID = 1L;
                int counter;

                public void populateItem(Item<PathModel.PathChangeModel> item) {
                    PathModel.PathChangeModel entry = (PathModel.PathChangeModel)item.getModelObject();
                    Label changeType = new Label("changeType", "");
                    WicketUtils.setChangeTypeCssClass((Component)changeType, entry.changeType);
                    ComparePage.this.setChangeTypeTooltip((Component)changeType, entry.changeType);
                    item.add(new Component[]{changeType});
                    item.add(new Component[]{new DiffStatPanel("diffStat", entry.insertions, entry.deletions, true)});
                    boolean hasSubmodule = false;
                    String submodulePath = null;
                    if (entry.isTree()) {
                        item.add(new Component[]{new LinkPanel("pathName", null, entry.path, TreePage.class, WicketUtils.newPathParameter(ComparePage.this.repositoryName, endId, entry.path))});
                    } else if (entry.isSubmodule()) {
                        String submoduleId = entry.objectId;
                        SubmoduleModel submodule = ComparePage.this.getSubmodule(entry.path);
                        submodulePath = submodule.gitblitPath;
                        hasSubmodule = submodule.hasSubmodule;
                        item.add(new Component[]{new LinkPanel("pathName", "list", entry.path + " @ " + ComparePage.this.getShortObjectId(submoduleId), "#n" + entry.objectId)});
                    } else {
                        item.add(new Component[]{new LinkPanel("pathName", "list", entry.path, "#n" + entry.objectId)});
                    }
                    if (entry.isSubmodule()) {
                        item.add(new Component[]{new ExternalLink("patch", "").setEnabled(false)});
                        item.add(new Component[]{new BookmarkablePageLink("view", CommitPage.class, WicketUtils.newObjectParameter(submodulePath, entry.objectId)).setEnabled(hasSubmodule)});
                        item.add(new Component[]{new ExternalLink("raw", "").setEnabled(false)});
                        item.add(new Component[]{new ExternalLink("blame", "").setEnabled(false)});
                        item.add(new Component[]{new BookmarkablePageLink("history", HistoryPage.class, WicketUtils.newPathParameter(ComparePage.this.repositoryName, endId, entry.path)).setEnabled(!entry.changeType.equals((Object)DiffEntry.ChangeType.ADD))});
                    } else {
                        item.add(new Component[]{new BookmarkablePageLink("patch", PatchPage.class, WicketUtils.newBlobDiffParameter(ComparePage.this.repositoryName, startId, endId, entry.path)).setEnabled(!entry.changeType.equals((Object)DiffEntry.ChangeType.DELETE))});
                        item.add(new Component[]{new BookmarkablePageLink("view", BlobPage.class, WicketUtils.newPathParameter(ComparePage.this.repositoryName, endId, entry.path)).setEnabled(!entry.changeType.equals((Object)DiffEntry.ChangeType.DELETE))});
                        String rawUrl = RawServlet.asLink(ComparePage.this.getContextUrl(), ComparePage.this.repositoryName, endId, entry.path);
                        item.add(new Component[]{new ExternalLink("raw", rawUrl).setEnabled(!entry.changeType.equals((Object)DiffEntry.ChangeType.DELETE))});
                        item.add(new Component[]{new BookmarkablePageLink("blame", BlamePage.class, WicketUtils.newPathParameter(ComparePage.this.repositoryName, endId, entry.path)).setEnabled(!entry.changeType.equals((Object)DiffEntry.ChangeType.ADD) && !entry.changeType.equals((Object)DiffEntry.ChangeType.DELETE))});
                        item.add(new Component[]{new BookmarkablePageLink("history", HistoryPage.class, WicketUtils.newPathParameter(ComparePage.this.repositoryName, endId, entry.path)).setEnabled(!entry.changeType.equals((Object)DiffEntry.ChangeType.ADD))});
                    }
                    WicketUtils.setAlternatingBackground(item, this.counter);
                    ++this.counter;
                }
            };
            comparison.add(new Component[]{pathsView});
            comparison.add(new Component[]{new Label("diffText", diff.content).setEscapeModelStrings(false)});
        }
        DiffUtils.DiffComparator diffComparator = WicketUtils.getDiffComparator(params);
        this.ignoreWhitespace.setObject((Object)(DiffUtils.DiffComparator.IGNORE_WHITESPACE == diffComparator ? 1 : 0));
        SessionlessForm<Void> refsForm = new SessionlessForm<Void>("compareRefsForm", ((Object)((Object)this)).getClass(), this.getPageParameters()){
            private static final long serialVersionUID = 1L;

            public void onSubmit() {
                String from = (String)ComparePage.this.fromRefId.getObject();
                String to = (String)ComparePage.this.toRefId.getObject();
                boolean ignoreWS = (Boolean)ComparePage.this.ignoreWhitespace.getObject();
                PageParameters params = WicketUtils.newRangeParameter(ComparePage.this.repositoryName, from, to);
                if (ignoreWS) {
                    params.put("w", (Object)1);
                }
                String relativeUrl = this.urlFor(ComparePage.class, params).toString();
                String absoluteUrl = RequestUtils.toAbsolutePath((String)relativeUrl);
                this.getRequestCycle().setRequestTarget((IRequestTarget)new RedirectRequestTarget(absoluteUrl));
            }
        };
        ArrayList<String> refs = new ArrayList<String>();
        for (RefModel ref : JGitUtils.getLocalBranches(r, true, -1)) {
            refs.add(ref.getName());
        }
        if (repository.showRemoteBranches) {
            for (RefModel ref : JGitUtils.getRemoteBranches(r, true, -1)) {
                refs.add(ref.getName());
            }
        }
        for (RefModel ref : JGitUtils.getTags(r, true, -1)) {
            refs.add(ref.getName());
        }
        refsForm.add(new Component[]{new DropDownChoice("fromRef", this.fromRefId, refs).setEnabled(refs.size() > 0)});
        refsForm.add(new Component[]{new DropDownChoice("toRef", this.toRefId, refs).setEnabled(refs.size() > 0)});
        refsForm.add(new Component[]{new Label("ignoreWhitespaceLabel", this.getString(DiffUtils.DiffComparator.IGNORE_WHITESPACE.getTranslationKey()))});
        refsForm.add(new Component[]{new CheckBox("ignoreWhitespaceCheckbox", this.ignoreWhitespace)});
        this.add(new Component[]{refsForm});
        SessionlessForm<Void> idsForm = new SessionlessForm<Void>("compareIdsForm", ((Object)((Object)this)).getClass(), this.getPageParameters()){
            private static final long serialVersionUID = 1L;

            public void onSubmit() {
                String from = (String)ComparePage.this.fromCommitId.getObject();
                String to = (String)ComparePage.this.toCommitId.getObject();
                boolean ignoreWS = (Boolean)ComparePage.this.ignoreWhitespace.getObject();
                PageParameters params = WicketUtils.newRangeParameter(ComparePage.this.repositoryName, from, to);
                if (ignoreWS) {
                    params.put("w", (Object)1);
                }
                String relativeUrl = this.urlFor(ComparePage.class, params).toString();
                String absoluteUrl = RequestUtils.toAbsolutePath((String)relativeUrl);
                this.getRequestCycle().setRequestTarget((IRequestTarget)new RedirectRequestTarget(absoluteUrl));
            }
        };
        TextField fromIdField = new TextField("fromId", this.fromCommitId);
        WicketUtils.setInputPlaceholder((Component)fromIdField, this.getString("gb.from") + "...");
        idsForm.add(new Component[]{fromIdField});
        TextField toIdField = new TextField("toId", this.toCommitId);
        WicketUtils.setInputPlaceholder((Component)toIdField, this.getString("gb.to") + "...");
        idsForm.add(new Component[]{toIdField});
        idsForm.add(new Component[]{new Label("ignoreWhitespaceLabel", this.getString(DiffUtils.DiffComparator.IGNORE_WHITESPACE.getTranslationKey()))});
        idsForm.add(new Component[]{new CheckBox("ignoreWhitespaceCheckbox", this.ignoreWhitespace)});
        this.add(new Component[]{idsForm});
        r.close();
    }

    @Override
    protected String getPageName() {
        return this.getString("gb.compare");
    }

    @Override
    protected Class<? extends BasePage> getRepoNavPageClass() {
        return ComparePage.class;
    }

    private RevCommit getCommit(Repository r, String rev) {
        RevCommit otherCommit = JGitUtils.getCommit(r, rev);
        if (otherCommit == null) {
            this.error(MessageFormat.format(this.getString("gb.failedToFindCommit"), rev, this.repositoryName, this.getPageName()), true);
        }
        return otherCommit;
    }
}

