/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.models.DailyLogEntry;
import com.gitblit.models.Menu;
import com.gitblit.models.Metric;
import com.gitblit.models.NavLink;
import com.gitblit.models.RefLogEntry;
import com.gitblit.models.RepositoryCommit;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.UserModel;
import com.gitblit.utils.ArrayUtils;
import com.gitblit.utils.RefLogUtils;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.GitBlitWebApp;
import com.gitblit.wicket.charting.Chart;
import com.gitblit.wicket.charting.Charts;
import com.gitblit.wicket.charting.Flotr2Charts;
import com.gitblit.wicket.pages.RepositoriesPage;
import com.gitblit.wicket.pages.RootPage;
import com.gitblit.wicket.pages.SummaryPage;
import com.gitblit.wicket.panels.DigestsPanel;
import com.gitblit.wicket.panels.LinkPanel;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.PageParameters;
import org.apache.wicket.behavior.HeaderContributor;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Fragment;
import org.eclipse.jgit.lib.Repository;

public abstract class DashboardPage
extends RootPage {
    public DashboardPage() {
    }

    public DashboardPage(PageParameters params) {
        super(params);
    }

    @Override
    protected boolean reusePageParameters() {
        return true;
    }

    protected void addActivity(UserModel user, Collection<RepositoryModel> repositories, String feedTitle, int daysBack) {
        Calendar c = Calendar.getInstance();
        c.add(5, -1 * daysBack);
        Date minimumDate = c.getTime();
        TimeZone timezone = this.getTimeZone();
        ArrayList<DailyLogEntry> digests = new ArrayList<DailyLogEntry>();
        for (RepositoryModel model : repositories) {
            if (model.isCollectingGarbage || !model.hasCommits || !model.lastChange.after(minimumDate)) continue;
            Repository repository = this.app().repositories().getRepository(model.name);
            List<DailyLogEntry> entries = RefLogUtils.getDailyLogByRef(model.name, repository, minimumDate, timezone);
            digests.addAll(entries);
            repository.close();
        }
        Fragment activityFragment = new Fragment("activity", "activityFragment", (MarkupContainer)this);
        this.add(new Component[]{activityFragment});
        activityFragment.add(new Component[]{new Label("feedTitle", feedTitle)});
        if (digests.size() == 0) {
            if (repositories.size() == 0) {
                if (UserModel.ANONYMOUS.equals(user)) {
                    if (daysBack == 1) {
                        activityFragment.add(new Component[]{new Label("digests", this.getString("gb.noActivityToday"))});
                    } else {
                        activityFragment.add(new Component[]{new Label("digests", MessageFormat.format(this.getString("gb.noActivity"), daysBack))});
                    }
                } else {
                    activityFragment.add(new Component[]{new LinkPanel("digests", null, this.getString("gb.findSomeRepositories"), RepositoriesPage.class)});
                }
            } else if (daysBack == 1) {
                activityFragment.add(new Component[]{new Label("digests", this.getString("gb.noActivityToday"))});
            } else {
                activityFragment.add(new Component[]{new Label("digests", MessageFormat.format(this.getString("gb.noActivity"), daysBack))});
            }
        } else {
            Collections.sort(digests);
            DigestsPanel digestsPanel = new DigestsPanel("digests", digests);
            activityFragment.add(new Component[]{digestsPanel});
        }
        if (!ArrayUtils.isEmpty(digests)) {
            TreeSet<String> authorExclusions = new TreeSet<String>();
            for (String author : this.app().settings().getStrings("web.metricAuthorExclusions")) {
                authorExclusions.add(author.toLowerCase());
            }
            for (RepositoryModel model : repositories) {
                if (ArrayUtils.isEmpty(model.metricAuthorExclusions)) continue;
                for (String author : model.metricAuthorExclusions) {
                    authorExclusions.add(author.toLowerCase());
                }
            }
            this.addCharts(activityFragment, digests, authorExclusions, daysBack);
        } else {
            activityFragment.add(new Component[]{new Label("charts").setVisible(false)});
            activityFragment.add(new Component[]{new Label("feedheader").setVisible(false)});
        }
    }

    @Override
    protected void addDropDownMenus(List<NavLink> navLinks) {
        PageParameters params = this.getPageParameters();
        NavLink.DropDownPageMenuNavLink menu = new NavLink.DropDownPageMenuNavLink("gb.filters", GitBlitWebApp.get().getHomePage());
        menu.menuItems.addAll(this.getTimeFilterItems(params));
        if (menu.menuItems.size() > 0) {
            menu.menuItems.add(new Menu.ParameterMenuItem(this.getString("gb.reset")));
        }
        navLinks.add(menu);
    }

    protected void addCharts(Fragment frag, List<DailyLogEntry> recentChanges, Set<String> authorExclusions, int daysBack) {
        HashMap<String, Metric> repositoryMetrics = new HashMap<String, Metric>();
        HashMap<String, Metric> authorMetrics = new HashMap<String, Metric>();
        int totalCommits = 0;
        for (RefLogEntry refLogEntry : recentChanges) {
            String repository = StringUtils.stripDotGit(refLogEntry.repository);
            if (!repositoryMetrics.containsKey(repository)) {
                repositoryMetrics.put(repository, new Metric(repository));
            }
            ((Metric)repositoryMetrics.get((Object)repository)).count += 1.0;
            for (RepositoryCommit commit : refLogEntry.getCommits()) {
                ++totalCommits;
                String author = StringUtils.removeNewlines(commit.getAuthorIdent().getName());
                String authorName = author.toLowerCase();
                String authorEmail = StringUtils.removeNewlines(commit.getAuthorIdent().getEmailAddress()).toLowerCase();
                if (authorExclusions.contains(authorName) || authorExclusions.contains(authorEmail)) continue;
                if (!authorMetrics.containsKey(author)) {
                    authorMetrics.put(author, new Metric(author));
                }
                ((Metric)authorMetrics.get((Object)author)).count += 1.0;
            }
        }
        String headerPattern = daysBack == 1 ? (totalCommits == 0 ? this.getString("gb.todaysActivityNone") : this.getString("gb.todaysActivityStats")) : (totalCommits == 0 ? this.getString("gb.recentActivityNone") : this.getString("gb.recentActivityStats"));
        frag.add(new Component[]{new Label("feedheader", MessageFormat.format(headerPattern, daysBack, totalCommits, authorMetrics.size()))});
        if (this.app().settings().getBoolean("web.generateActivityGraph", true)) {
            Flotr2Charts flotr2Charts = new Flotr2Charts();
            Chart chart = ((Charts)flotr2Charts).createPieChart("chartRepositories", this.getString("gb.activeRepositories"), this.getString("gb.repository"), this.getString("gb.commits"));
            for (Metric metric : repositoryMetrics.values()) {
                chart.addValue(metric.name, metric.count);
            }
            chart.setShowLegend(false);
            String url = this.urlFor(SummaryPage.class, null).toString() + "?r=";
            chart.setClickUrl(url);
            flotr2Charts.addChart(chart);
            chart = ((Charts)flotr2Charts).createPieChart("chartAuthors", this.getString("gb.activeAuthors"), this.getString("gb.author"), this.getString("gb.commits"));
            for (Metric metric : authorMetrics.values()) {
                chart.addValue(metric.name, metric.count);
            }
            chart.setShowLegend(false);
            flotr2Charts.addChart(chart);
            this.add(new IBehavior[]{new HeaderContributor((IHeaderContributor)flotr2Charts)});
            frag.add(new Component[]{new Fragment("charts", "chartsFragment", (MarkupContainer)this)});
        } else {
            frag.add(new Component[]{new Label("charts").setVisible(false)});
        }
    }
}

