/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.models.UserModel;
import com.gitblit.servlet.RawServlet;
import com.gitblit.utils.BugtraqProcessor;
import com.gitblit.utils.JGitUtils;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.CacheControl;
import com.gitblit.wicket.GitBlitWebSession;
import com.gitblit.wicket.MarkupProcessor;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.BasePage;
import com.gitblit.wicket.pages.BlamePage;
import com.gitblit.wicket.pages.DocsPage;
import com.gitblit.wicket.pages.EditFilePage;
import com.gitblit.wicket.pages.HistoryPage;
import com.gitblit.wicket.pages.NoDocsPage;
import com.gitblit.wicket.pages.RepositoryPage;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.PageParameters;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.link.ExternalLink;
import org.apache.wicket.markup.html.panel.Fragment;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;

@CacheControl(value=CacheControl.LastModified.BOOT)
public class DocPage
extends RepositoryPage {
    public DocPage(PageParameters params) {
        super(params);
        String path = WicketUtils.getPath(params).replace("%2f", "/").replace("%2F", "/");
        MarkupProcessor processor = new MarkupProcessor(this.app().settings(), this.app().xssFilter());
        UserModel currentUser = GitBlitWebSession.get().getUser() != null ? GitBlitWebSession.get().getUser() : UserModel.ANONYMOUS;
        boolean userCanEdit = currentUser.canEdit(this.getRepositoryModel());
        Repository r = this.getRepository();
        RevCommit commit = JGitUtils.getCommit(r, this.objectId);
        if (commit == null) {
            this.setResponsePage(NoDocsPage.class, params);
            return;
        }
        String[] encodings = this.getEncodings();
        String documentPath = path;
        String markupText = JGitUtils.getStringContent(r, commit.getTree(), path, encodings);
        if (StringUtils.isEmpty(markupText)) {
            String name = StringUtils.stripFileExtension(path);
            List<String> docExtensions = processor.getAllExtensions();
            for (String ext : docExtensions) {
                String checkName = name + "." + ext;
                markupText = JGitUtils.getStringContent(r, commit.getTree(), checkName, encodings);
                if (StringUtils.isEmpty(markupText)) continue;
                documentPath = path;
                break;
            }
        }
        if (markupText == null) {
            markupText = "";
        }
        BugtraqProcessor bugtraq = new BugtraqProcessor(this.app().settings());
        markupText = bugtraq.processText(this.getRepository(), this.repositoryName, markupText);
        MarkupProcessor.MarkupDocument markupDoc = processor.parse(this.repositoryName, this.getBestCommitId(commit), documentPath, markupText);
        Fragment fragment = MarkupProcessor.MarkupSyntax.PLAIN.equals((Object)markupDoc.syntax) ? new Fragment("doc", "plainContent", (MarkupContainer)this) : new Fragment("doc", "markupContent", (MarkupContainer)this);
        fragment.add(new Component[]{new BookmarkablePageLink("editLink", EditFilePage.class, WicketUtils.newPathParameter(this.repositoryName, this.objectId, documentPath)).setEnabled(userCanEdit)});
        fragment.add(new Component[]{new BookmarkablePageLink("blameLink", BlamePage.class, WicketUtils.newPathParameter(this.repositoryName, this.objectId, documentPath))});
        fragment.add(new Component[]{new BookmarkablePageLink("historyLink", HistoryPage.class, WicketUtils.newPathParameter(this.repositoryName, this.objectId, documentPath))});
        String rawUrl = RawServlet.asLink(this.getContextUrl(), this.repositoryName, this.objectId, documentPath);
        fragment.add(new Component[]{new ExternalLink("rawLink", rawUrl)});
        fragment.add(new Component[]{new Label("content", markupDoc.html).setEscapeModelStrings(false)});
        this.add(new Component[]{fragment});
    }

    @Override
    protected String getPageName() {
        return this.getString("gb.docs");
    }

    @Override
    protected boolean isCommitPage() {
        return true;
    }

    @Override
    protected Class<? extends BasePage> getRepoNavPageClass() {
        return DocsPage.class;
    }
}

