/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.models.PathModel;
import com.gitblit.models.UserModel;
import com.gitblit.servlet.RawServlet;
import com.gitblit.utils.ByteFormat;
import com.gitblit.utils.JGitUtils;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.CacheControl;
import com.gitblit.wicket.GitBlitWebSession;
import com.gitblit.wicket.MarkupProcessor;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.BlamePage;
import com.gitblit.wicket.pages.DocPage;
import com.gitblit.wicket.pages.EditFilePage;
import com.gitblit.wicket.pages.HistoryPage;
import com.gitblit.wicket.pages.NoDocsPage;
import com.gitblit.wicket.pages.RepositoryPage;
import com.gitblit.wicket.panels.LinkPanel;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.PageParameters;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.behavior.SimpleAttributeModifier;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.link.ExternalLink;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.markup.repeater.data.ListDataProvider;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;

@CacheControl(value=CacheControl.LastModified.REPOSITORY)
public class DocsPage
extends RepositoryPage {
    public DocsPage(PageParameters params) {
        super(params);
        String objectId = WicketUtils.getObject(params);
        MarkupProcessor processor = new MarkupProcessor(this.app().settings(), this.app().xssFilter());
        Repository r = this.getRepository();
        UserModel currentUser = GitBlitWebSession.get().getUser() != null ? GitBlitWebSession.get().getUser() : UserModel.ANONYMOUS;
        final boolean userCanEdit = currentUser.canEdit(this.getRepositoryModel());
        RevCommit head = JGitUtils.getCommit(r, objectId);
        if (head == null) {
            this.setResponsePage(NoDocsPage.class, params);
            return;
        }
        final String commitId = this.getBestCommitId(head);
        List<String> extensions = processor.getAllExtensions();
        List<PathModel> paths = JGitUtils.getDocuments(r, extensions);
        List<MarkupProcessor.MarkupDocument> roots = processor.getRootDocs(r, this.repositoryName, commitId);
        Fragment fragment = null;
        if (roots.isEmpty()) {
            fragment = new Fragment("docs", "noIndexFragment", (MarkupContainer)this);
            this.setResponsePage(NoDocsPage.class, params);
        } else {
            fragment = new Fragment("docs", "tabsFragment", (MarkupContainer)this);
            ListDataProvider docDp = new ListDataProvider(roots);
            DataView<MarkupProcessor.MarkupDocument> tabTitles = new DataView<MarkupProcessor.MarkupDocument>("tabTitle", (IDataProvider)docDp){
                private static final long serialVersionUID = 1L;
                int counter;

                public void populateItem(Item<MarkupProcessor.MarkupDocument> item) {
                    MarkupProcessor.MarkupDocument doc = (MarkupProcessor.MarkupDocument)item.getModelObject();
                    String file = StringUtils.getLastPathElement(doc.documentPath);
                    file = StringUtils.stripFileExtension(file);
                    String name = file.replace('_', ' ').replace('-', ' ');
                    ExternalLink link = new ExternalLink("link", "#" + file);
                    link.add(new Component[]{new Label("label", name.toUpperCase()).setRenderBodyOnly(true)});
                    item.add(new Component[]{link});
                    if (this.counter == 0) {
                        ++this.counter;
                        item.add(new IBehavior[]{new SimpleAttributeModifier("class", (CharSequence)"active")});
                    }
                }
            };
            fragment.add(new Component[]{tabTitles});
            DataView<MarkupProcessor.MarkupDocument> tabsView = new DataView<MarkupProcessor.MarkupDocument>("tabContent", (IDataProvider)docDp){
                private static final long serialVersionUID = 1L;
                int counter;

                public void populateItem(Item<MarkupProcessor.MarkupDocument> item) {
                    MarkupProcessor.MarkupDocument doc = (MarkupProcessor.MarkupDocument)item.getModelObject();
                    item.add(new Component[]{new BookmarkablePageLink("editLink", EditFilePage.class, WicketUtils.newPathParameter(DocsPage.this.repositoryName, commitId, doc.documentPath)).setEnabled(userCanEdit)});
                    item.add(new Component[]{new BookmarkablePageLink("blameLink", BlamePage.class, WicketUtils.newPathParameter(DocsPage.this.repositoryName, commitId, doc.documentPath))});
                    item.add(new Component[]{new BookmarkablePageLink("historyLink", HistoryPage.class, WicketUtils.newPathParameter(DocsPage.this.repositoryName, commitId, doc.documentPath))});
                    String rawUrl = RawServlet.asLink(DocsPage.this.getContextUrl(), DocsPage.this.repositoryName, commitId, doc.documentPath);
                    item.add(new Component[]{new ExternalLink("rawLink", rawUrl)});
                    String file = StringUtils.getLastPathElement(doc.documentPath);
                    file = StringUtils.stripFileExtension(file);
                    Component content = new Label("content", doc.html).setEscapeModelStrings(false);
                    if (!MarkupProcessor.MarkupSyntax.PLAIN.equals((Object)doc.syntax)) {
                        content.add(new IBehavior[]{new SimpleAttributeModifier("class", (CharSequence)"markdown")});
                    }
                    item.add(new Component[]{content});
                    item.add(new IBehavior[]{new SimpleAttributeModifier("id", (CharSequence)file)});
                    if (this.counter == 0) {
                        ++this.counter;
                        item.add(new IBehavior[]{new SimpleAttributeModifier("class", (CharSequence)"tab-pane active")});
                    }
                }
            };
            fragment.add(new Component[]{tabsView});
        }
        final ByteFormat byteFormat = new ByteFormat();
        Fragment docs = new Fragment("documents", "documentsFragment", (MarkupContainer)this);
        ListDataProvider pathsDp = new ListDataProvider(paths);
        DataView<PathModel> pathsView = new DataView<PathModel>("document", (IDataProvider)pathsDp){
            private static final long serialVersionUID = 1L;
            int counter;

            public void populateItem(Item<PathModel> item) {
                PathModel entry = (PathModel)item.getModelObject();
                item.add(new Component[]{WicketUtils.newImage("docIcon", "file_world_16x16.png")});
                item.add(new Component[]{new Label("docSize", byteFormat.format(entry.size))});
                item.add(new Component[]{new LinkPanel("docName", "list", StringUtils.stripFileExtension(entry.name), DocPage.class, WicketUtils.newPathParameter(DocsPage.this.repositoryName, commitId, entry.path))});
                item.add(new Component[]{new BookmarkablePageLink("view", DocPage.class, WicketUtils.newPathParameter(DocsPage.this.repositoryName, commitId, entry.path))});
                item.add(new Component[]{new BookmarkablePageLink("edit", EditFilePage.class, WicketUtils.newPathParameter(DocsPage.this.repositoryName, commitId, entry.path)).setEnabled(userCanEdit)});
                String rawUrl = RawServlet.asLink(DocsPage.this.getContextUrl(), DocsPage.this.repositoryName, commitId, entry.path);
                item.add(new Component[]{new ExternalLink("raw", rawUrl)});
                item.add(new Component[]{new BookmarkablePageLink("blame", BlamePage.class, WicketUtils.newPathParameter(DocsPage.this.repositoryName, commitId, entry.path))});
                item.add(new Component[]{new BookmarkablePageLink("history", HistoryPage.class, WicketUtils.newPathParameter(DocsPage.this.repositoryName, commitId, entry.path))});
                WicketUtils.setAlternatingBackground(item, this.counter);
                ++this.counter;
            }
        };
        docs.add(new Component[]{pathsView});
        fragment.add(new Component[]{docs});
        this.add(new Component[]{fragment});
    }

    @Override
    protected String getPageName() {
        return this.getString("gb.docs");
    }

    @Override
    protected boolean isCommitPage() {
        return true;
    }
}

