/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.Constants;
import com.gitblit.GitBlitException;
import com.gitblit.models.RegistrantAccessPermission;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.UserChoice;
import com.gitblit.models.UserModel;
import com.gitblit.utils.ArrayUtils;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.GitBlitWebSession;
import com.gitblit.wicket.StringChoiceRenderer;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.BasePage;
import com.gitblit.wicket.pages.RepositoriesPage;
import com.gitblit.wicket.pages.RootSubPage;
import com.gitblit.wicket.pages.SummaryPage;
import com.gitblit.wicket.pages.UserPage;
import com.gitblit.wicket.panels.AccessPolicyPanel;
import com.gitblit.wicket.panels.BasePanel;
import com.gitblit.wicket.panels.BooleanOption;
import com.gitblit.wicket.panels.BulletListPanel;
import com.gitblit.wicket.panels.ChoiceOption;
import com.gitblit.wicket.panels.RegistrantPermissionsPanel;
import com.gitblit.wicket.panels.RepositoryNamePanel;
import com.gitblit.wicket.panels.TextOption;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormChoiceComponentUpdatingBehavior;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.behavior.SimpleAttributeModifier;
import org.apache.wicket.extensions.markup.html.form.palette.Palette;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.util.CollectionModel;
import org.apache.wicket.model.util.ListModel;
import org.eclipse.jgit.lib.Repository;

public class EditRepositoryPage
extends RootSubPage {
    private final boolean isCreate;
    RepositoryNamePanel namePanel;
    AccessPolicyPanel accessPolicyPanel;
    private boolean isAdmin;
    RepositoryModel repositoryModel;
    private IModel<String> metricAuthorExclusions;
    private IModel<String> mailingLists;

    public EditRepositoryPage() {
        this.isCreate = true;
        RepositoryModel model = new RepositoryModel();
        String restriction = this.app().settings().getString("git.defaultAccessRestriction", "PUSH");
        model.accessRestriction = Constants.AccessRestrictionType.fromName(restriction);
        String authorization = this.app().settings().getString("git.defaultAuthorizationControl", null);
        model.authorizationControl = Constants.AuthorizationControl.fromName(authorization);
        GitBlitWebSession session = GitBlitWebSession.get();
        UserModel user = session.getUser();
        if (user != null && user.canCreate() && !user.canAdmin()) {
            model.name = user.getPersonalPath() + "/";
            model.projectPath = user.getPersonalPath();
            model.addOwner(user.username);
            model.accessRestriction = Constants.AccessRestrictionType.VIEW;
            model.authorizationControl = Constants.AuthorizationControl.NAMED;
        }
        this.setupPage(model);
        this.setStatelessHint(false);
        this.setOutputMarkupId(true);
    }

    public EditRepositoryPage(PageParameters params) {
        super(params);
        this.isCreate = false;
        String name = WicketUtils.getRepositoryName(params);
        RepositoryModel model = this.app().repositories().getRepositoryModel(name);
        this.setupPage(model);
        this.setStatelessHint(false);
        this.setOutputMarkupId(true);
    }

    @Override
    protected boolean requiresPageMap() {
        return true;
    }

    @Override
    protected Class<? extends BasePage> getRootNavPageClass() {
        return RepositoriesPage.class;
    }

    protected void setupPage(RepositoryModel model) {
        UserModel o;
        boolean allowEditName;
        this.repositoryModel = model;
        this.checkPermissions(this.repositoryModel);
        ArrayList<String> indexedBranches = new ArrayList<String>();
        ArrayList<String> federationSets = new ArrayList<String>();
        ArrayList<RegistrantAccessPermission> repositoryUsers = new ArrayList<RegistrantAccessPermission>();
        ArrayList<RegistrantAccessPermission> repositoryTeams = new ArrayList<RegistrantAccessPermission>();
        ArrayList<String> preReceiveScripts = new ArrayList<String>();
        ArrayList<String> postReceiveScripts = new ArrayList<String>();
        GitBlitWebSession session = GitBlitWebSession.get();
        UserModel user = session.getUser() == null ? UserModel.ANONYMOUS : session.getUser();
        boolean bl = allowEditName = this.isCreate || this.isAdmin || this.repositoryModel.isUsersPersonalRepository(user.username);
        if (this.isCreate) {
            if (user.canAdmin()) {
                super.setupPage(this.getString("gb.newRepository"), "");
            } else {
                super.setupPage(this.getString("gb.newRepository"), user.getDisplayName());
            }
        } else {
            super.setupPage(this.getString("gb.edit"), this.repositoryModel.name);
            repositoryUsers.addAll(this.app().repositories().getUserAccessPermissions(this.repositoryModel));
            repositoryTeams.addAll(this.app().repositories().getTeamAccessPermissions(this.repositoryModel));
            Collections.sort(repositoryUsers);
            Collections.sort(repositoryTeams);
            federationSets.addAll(this.repositoryModel.federationSets);
            if (!ArrayUtils.isEmpty(this.repositoryModel.indexedBranches)) {
                indexedBranches.addAll(this.repositoryModel.indexedBranches);
            }
        }
        String oldName = this.repositoryModel.name;
        final RegistrantPermissionsPanel usersPalette = new RegistrantPermissionsPanel("users", Constants.RegistrantType.USER, this.app().users().getAllUsernames(), repositoryUsers, this.getAccessPermissions());
        final RegistrantPermissionsPanel teamsPalette = new RegistrantPermissionsPanel("teams", Constants.RegistrantType.TEAM, this.app().users().getAllTeamNames(), repositoryTeams, this.getAccessPermissions());
        ArrayList<UserChoice> owners = new ArrayList<UserChoice>();
        ArrayList<UserChoice> persons = new ArrayList<UserChoice>();
        for (String owner : this.repositoryModel.owners) {
            o = this.app().users().getUserModel(owner);
            if (o != null) {
                owners.add(new UserChoice(o.getDisplayName(), o.username, o.emailAddress));
                continue;
            }
            UserChoice userChoice = new UserChoice(owner);
            owners.add(userChoice);
            persons.add(userChoice);
        }
        for (String person : this.app().users().getAllUsernames()) {
            o = this.app().users().getUserModel(person);
            if (o != null) {
                persons.add(new UserChoice(o.getDisplayName(), o.username, o.emailAddress));
                continue;
            }
            persons.add(new UserChoice(person));
        }
        final Palette ownersPalette = new Palette("owners", (IModel)new ListModel(owners), (IModel)new CollectionModel(persons), (IChoiceRenderer)new ChoiceRenderer(null, "userId"), 12, false);
        ArrayList<String> allLocalBranches = new ArrayList<String>();
        allLocalBranches.add("default");
        allLocalBranches.addAll(this.repositoryModel.getLocalBranches());
        boolean luceneEnabled = this.app().settings().getBoolean("web.allowLuceneIndexing", true);
        final Palette indexedBranchesPalette = new Palette("indexedBranches", (IModel)new ListModel(indexedBranches), (IModel)new CollectionModel(allLocalBranches), (IChoiceRenderer)new StringChoiceRenderer(), 8, false);
        indexedBranchesPalette.setEnabled(luceneEnabled);
        List<String> sets = this.app().settings().getStrings("federation.sets");
        final Palette federationSetsPalette = new Palette("federationSets", (IModel)new ListModel(federationSets), (IModel)new CollectionModel(sets), (IChoiceRenderer)new StringChoiceRenderer(), 8, false);
        if (!ArrayUtils.isEmpty(this.repositoryModel.preReceiveScripts)) {
            preReceiveScripts.addAll(this.repositoryModel.preReceiveScripts);
        }
        final Palette preReceivePalette = new Palette("preReceiveScripts", (IModel)new ListModel(preReceiveScripts), (IModel)new CollectionModel(this.app().repositories().getPreReceiveScriptsUnused(this.repositoryModel)), (IChoiceRenderer)new StringChoiceRenderer(), 12, true);
        if (!ArrayUtils.isEmpty(this.repositoryModel.postReceiveScripts)) {
            postReceiveScripts.addAll(this.repositoryModel.postReceiveScripts);
        }
        final Palette postReceivePalette = new Palette("postReceiveScripts", (IModel)new ListModel(postReceiveScripts), (IModel)new CollectionModel(this.app().repositories().getPostReceiveScriptsUnused(this.repositoryModel)), (IChoiceRenderer)new StringChoiceRenderer(), 12, true);
        final Map<String, String> customFieldsMap = this.app().settings().getMap("groovy.customFields");
        ArrayList<String> customKeys = new ArrayList<String>(customFieldsMap.keySet());
        ListView<String> customFieldsListView = new ListView<String>("customFieldsListView", customKeys){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<String> item) {
                String key = (String)item.getModelObject();
                item.add(new Component[]{new Label("customFieldLabel", (String)customFieldsMap.get(key))});
                String value = "";
                if (EditRepositoryPage.this.repositoryModel.customFields != null && EditRepositoryPage.this.repositoryModel.customFields.containsKey(key)) {
                    value = EditRepositoryPage.this.repositoryModel.customFields.get(key);
                }
                TextField field = new TextField("customFieldValue", (IModel)new Model((Serializable)((Object)value)));
                item.add(new Component[]{field});
            }
        };
        customFieldsListView.setReuseItems(true);
        CompoundPropertyModel rModel = new CompoundPropertyModel((Object)this.repositoryModel);
        Form<RepositoryModel> form = new Form<RepositoryModel>("editForm", (IModel)rModel, (ListView)customFieldsListView, oldName, repositoryUsers, repositoryTeams){
            private static final long serialVersionUID = 1L;
            final /* synthetic */ ListView val$customFieldsListView;
            final /* synthetic */ String val$oldName;
            final /* synthetic */ List val$repositoryUsers;
            final /* synthetic */ List val$repositoryTeams;
            {
                this.val$customFieldsListView = listView;
                this.val$oldName = string;
                this.val$repositoryUsers = list;
                this.val$repositoryTeams = list2;
                super(x0, x1);
            }

            protected void onSubmit() {
                try {
                    String ax;
                    if (!EditRepositoryPage.this.namePanel.updateModel(EditRepositoryPage.this.repositoryModel)) {
                        return;
                    }
                    if (EditRepositoryPage.this.repositoryModel.accessRestriction == null) {
                        this.error((Serializable)((Object)this.getString("gb.selectAccessRestriction")));
                        return;
                    }
                    if (EditRepositoryPage.this.repositoryModel.federationStrategy == null) {
                        this.error((Serializable)((Object)this.getString("gb.selectFederationStrategy")));
                        return;
                    }
                    if (EditRepositoryPage.this.repositoryModel.federationStrategy.exceeds(Constants.FederationStrategy.EXCLUDE)) {
                        EditRepositoryPage.this.repositoryModel.federationSets.clear();
                        Iterator sets = federationSetsPalette.getSelectedChoices();
                        while (sets.hasNext()) {
                            EditRepositoryPage.this.repositoryModel.federationSets.add((String)sets.next());
                        }
                    }
                    if (StringUtils.isEmpty(ax = (String)EditRepositoryPage.this.metricAuthorExclusions.getObject())) {
                        EditRepositoryPage.this.repositoryModel.metricAuthorExclusions = new ArrayList<String>();
                    } else {
                        HashSet<String> list = new HashSet<String>();
                        for (String string : StringUtils.getStringsFromValue(ax, " ")) {
                            if (StringUtils.isEmpty(string)) continue;
                            if (string.indexOf(32) > -1) {
                                list.add("\"" + string + "\"");
                                continue;
                            }
                            list.add(string);
                        }
                        EditRepositoryPage.this.repositoryModel.metricAuthorExclusions = new ArrayList<String>(list);
                    }
                    String ml = (String)EditRepositoryPage.this.mailingLists.getObject();
                    if (StringUtils.isEmpty(ml)) {
                        EditRepositoryPage.this.repositoryModel.mailingLists = new ArrayList<String>();
                    } else {
                        HashSet<String> list = new HashSet<String>();
                        for (String address : ml.split("(,|\\s)")) {
                            if (StringUtils.isEmpty(address)) continue;
                            list.add(address.toLowerCase());
                        }
                        EditRepositoryPage.this.repositoryModel.mailingLists = new ArrayList<String>(list);
                    }
                    ArrayList<String> indexedBranches = new ArrayList<String>();
                    Iterator iterator = indexedBranchesPalette.getSelectedChoices();
                    while (iterator.hasNext()) {
                        indexedBranches.add((String)iterator.next());
                    }
                    EditRepositoryPage.this.repositoryModel.indexedBranches = indexedBranches;
                    EditRepositoryPage.this.repositoryModel.owners.clear();
                    Iterator owners = ownersPalette.getSelectedChoices();
                    while (owners.hasNext()) {
                        EditRepositoryPage.this.repositoryModel.addOwner(((UserChoice)owners.next()).getUserId());
                    }
                    ArrayList<String> preReceiveScripts = new ArrayList<String>();
                    Iterator pres = preReceivePalette.getSelectedChoices();
                    while (pres.hasNext()) {
                        preReceiveScripts.add((String)pres.next());
                    }
                    EditRepositoryPage.this.repositoryModel.preReceiveScripts = preReceiveScripts;
                    ArrayList<String> postReceiveScripts = new ArrayList<String>();
                    Iterator post = postReceivePalette.getSelectedChoices();
                    while (post.hasNext()) {
                        postReceiveScripts.add((String)post.next());
                    }
                    EditRepositoryPage.this.repositoryModel.postReceiveScripts = postReceiveScripts;
                    EditRepositoryPage.this.repositoryModel.customFields = new LinkedHashMap<String, String>();
                    for (int i = 0; i < this.val$customFieldsListView.size(); ++i) {
                        ListItem child = (ListItem)this.val$customFieldsListView.get(i);
                        String key = (String)child.getModelObject();
                        TextField field = (TextField)child.get("customFieldValue");
                        String value = field.getValue();
                        EditRepositoryPage.this.repositoryModel.customFields.put(key, value);
                    }
                    EditRepositoryPage.this.app().gitblit().updateRepositoryModel(this.val$oldName, EditRepositoryPage.this.repositoryModel, EditRepositoryPage.this.isCreate);
                    if (EditRepositoryPage.this.repositoryModel.accessRestriction.exceeds(Constants.AccessRestrictionType.NONE)) {
                        EditRepositoryPage.this.app().gitblit().setUserAccessPermissions(EditRepositoryPage.this.repositoryModel, this.val$repositoryUsers);
                        EditRepositoryPage.this.app().gitblit().setTeamAccessPermissions(EditRepositoryPage.this.repositoryModel, this.val$repositoryTeams);
                    }
                }
                catch (GitBlitException e) {
                    this.error((Serializable)((Object)e.getMessage()));
                    return;
                }
                this.setRedirect(false);
                this.setResponsePage(SummaryPage.class, WicketUtils.newRepositoryParameter(EditRepositoryPage.this.repositoryModel.name));
            }
        };
        ArrayList<String> availableRefs = new ArrayList<String>();
        ArrayList<String> availableBranches = new ArrayList<String>();
        if (!ArrayUtils.isEmpty(this.repositoryModel.availableRefs)) {
            for (String ref : this.repositoryModel.availableRefs) {
                if (ref.startsWith("refs/heads/ticket/")) continue;
                availableRefs.add(ref);
                if (!ref.startsWith("refs/heads/")) continue;
                availableBranches.add(Repository.shortenRefName((String)ref));
            }
        }
        form.add(new IBehavior[]{new SimpleAttributeModifier("autocomplete", (CharSequence)"off")});
        this.namePanel = new RepositoryNamePanel("namePanel", this.repositoryModel);
        this.namePanel.setEditable(allowEditName);
        form.add(new Component[]{this.namePanel});
        form.add(new Component[]{new ChoiceOption("head", this.getString("gb.headRef"), this.getString("gb.headRefDescription"), new PropertyModel((Object)this.repositoryModel, "HEAD"), availableRefs)});
        form.add(new Component[]{ownersPalette});
        form.add(new Component[]{usersPalette});
        form.add(new Component[]{teamsPalette});
        form.add(new Component[]{new BooleanOption("acceptNewPatchsets", this.getString("gb.acceptNewPatchsets"), this.getString("gb.acceptNewPatchsetsDescription"), (IModel<Boolean>)new PropertyModel((Object)this.repositoryModel, "acceptNewPatchsets"))});
        form.add(new Component[]{new BooleanOption("acceptNewTickets", this.getString("gb.acceptNewTickets"), this.getString("gb.acceptNewTicketsDescription"), (IModel<Boolean>)new PropertyModel((Object)this.repositoryModel, "acceptNewTickets"))});
        form.add(new Component[]{new BooleanOption("requireApproval", this.getString("gb.requireApproval"), this.getString("gb.requireApprovalDescription"), (IModel<Boolean>)new PropertyModel((Object)this.repositoryModel, "requireApproval"))});
        form.add(new Component[]{new ChoiceOption("mergeTo", this.getString("gb.mergeTo"), this.getString("gb.mergeToDescription"), new PropertyModel((Object)this.repositoryModel, "mergeTo"), availableBranches)});
        form.add(new Component[]{new ChoiceOption<Constants.MergeType>("mergeType", this.getString("gb.mergeType"), this.getString("gb.mergeTypeDescription"), (IModel<Constants.MergeType>)new PropertyModel((Object)this.repositoryModel, "mergeType"), Arrays.asList(Constants.MergeType.values()))});
        form.add(new Component[]{new BooleanOption("isFrozen", this.getString("gb.isFrozen"), this.getString("gb.isFrozenDescription"), (IModel<Boolean>)new PropertyModel((Object)this.repositoryModel, "isFrozen"))});
        form.add(new Component[]{new BooleanOption("incrementalPushTags", this.getString("gb.enableIncrementalPushTags"), this.getString("gb.useIncrementalPushTagsDescription"), (IModel<Boolean>)new PropertyModel((Object)this.repositoryModel, "useIncrementalPushTags"))});
        final CheckBox verifyCommitter = new CheckBox("checkbox", (IModel)new PropertyModel((Object)this.repositoryModel, "verifyCommitter"));
        verifyCommitter.setOutputMarkupId(true);
        form.add(new Component[]{new BooleanOption("verifyCommitter", this.getString("gb.verifyCommitter"), this.getString("gb.verifyCommitterDescription") + "<br/>" + this.getString("gb.verifyCommitterNote"), verifyCommitter).setIsHtmlDescription(true)});
        form.add(new Component[]{preReceivePalette});
        form.add(new Component[]{new BulletListPanel("inheritedPreReceive", this.getString("gb.inherited"), this.app().repositories().getPreReceiveScriptsInherited(this.repositoryModel))});
        form.add(new Component[]{postReceivePalette});
        form.add(new Component[]{new BulletListPanel("inheritedPostReceive", this.getString("gb.inherited"), this.app().repositories().getPostReceiveScriptsInherited(this.repositoryModel))});
        WebMarkupContainer customFieldsSection = new WebMarkupContainer("customFieldsSection");
        customFieldsSection.add(new Component[]{customFieldsListView});
        form.add(new Component[]{customFieldsSection.setVisible(!this.app().settings().getString("groovy.customFields", "").isEmpty())});
        ArrayList<Constants.FederationStrategy> federationStrategies = new ArrayList<Constants.FederationStrategy>(Arrays.asList(Constants.FederationStrategy.values()));
        if (StringUtils.isEmpty(this.repositoryModel.origin)) {
            federationStrategies.remove((Object)Constants.FederationStrategy.FEDERATE_ORIGIN);
        }
        form.add(new Component[]{new ChoiceOption("federationStrategy", this.getString("gb.federationStrategy"), this.getString("gb.federationStrategyDescription"), new DropDownChoice("choice", (IModel)new PropertyModel((Object)this.repositoryModel, "federationStrategy"), federationStrategies, (IChoiceRenderer)new FederationTypeRenderer()))});
        form.add(new Component[]{federationSetsPalette});
        form.add(new Component[]{indexedBranchesPalette});
        boolean gcEnabled = this.app().settings().getBoolean("git.enableGarbageCollection", false);
        int defaultGcPeriod = this.app().settings().getInteger("git.defaultGarbageCollectionPeriod", 7);
        if (this.repositoryModel.gcPeriod == 0) {
            this.repositoryModel.gcPeriod = defaultGcPeriod;
        }
        List<Integer> gcPeriods = Arrays.asList(1, 2, 3, 4, 5, 7, 10, 14);
        form.add(new Component[]{new ChoiceOption("gcPeriod", this.getString("gb.gcPeriod"), this.getString("gb.gcPeriodDescription"), new DropDownChoice("choice", (IModel)new PropertyModel((Object)this.repositoryModel, "gcPeriod"), gcPeriods, (IChoiceRenderer)new GCPeriodRenderer())).setEnabled(gcEnabled)});
        form.add(new Component[]{new TextOption("gcThreshold", this.getString("gb.gcThreshold"), this.getString("gb.gcThresholdDescription"), "span1", (IModel<String>)new PropertyModel((Object)this.repositoryModel, "gcThreshold")).setEnabled(gcEnabled)});
        form.add(new Component[]{new TextOption("origin", this.getString("gb.origin"), this.getString("gb.originDescription"), "span6", (IModel<String>)new PropertyModel((Object)this.repositoryModel, "origin")).setEnabled(false)});
        form.add(new Component[]{new BooleanOption("showRemoteBranches", this.getString("gb.showRemoteBranches"), this.getString("gb.showRemoteBranchesDescription"), (IModel<Boolean>)new PropertyModel((Object)this.repositoryModel, "showRemoteBranches"))});
        form.add(new Component[]{new BooleanOption("skipSizeCalculation", this.getString("gb.skipSizeCalculation"), this.getString("gb.skipSizeCalculationDescription"), (IModel<Boolean>)new PropertyModel((Object)this.repositoryModel, "skipSizeCalculation"))});
        form.add(new Component[]{new BooleanOption("skipSummaryMetrics", this.getString("gb.skipSummaryMetrics"), this.getString("gb.skipSummaryMetricsDescription"), (IModel<Boolean>)new PropertyModel((Object)this.repositoryModel, "skipSummaryMetrics"))});
        List<Integer> maxActivityCommits = Arrays.asList(-1, 0, 25, 50, 75, 100, 150, 200, 250, 500);
        form.add(new Component[]{new ChoiceOption("maxActivityCommits", this.getString("gb.maxActivityCommits"), this.getString("gb.maxActivityCommitsDescription"), new DropDownChoice("choice", (IModel)new PropertyModel((Object)this.repositoryModel, "maxActivityCommits"), maxActivityCommits, (IChoiceRenderer)new MaxActivityCommitsRenderer()))});
        List<Constants.CommitMessageRenderer> renderers = Arrays.asList(Constants.CommitMessageRenderer.values());
        form.add(new Component[]{new ChoiceOption("commitMessageRenderer", this.getString("gb.commitMessageRenderer"), this.getString("gb.commitMessageRendererDescription"), new DropDownChoice("choice", (IModel)new PropertyModel((Object)this.repositoryModel, "commitMessageRenderer"), renderers))});
        this.metricAuthorExclusions = new Model((Serializable)((Object)(ArrayUtils.isEmpty(this.repositoryModel.metricAuthorExclusions) ? "" : StringUtils.flattenStrings(this.repositoryModel.metricAuthorExclusions, " "))));
        form.add(new Component[]{new TextOption("metricAuthorExclusions", this.getString("gb.metricAuthorExclusions"), this.getString("gb.metricAuthorExclusions"), "span6", this.metricAuthorExclusions)});
        this.mailingLists = new Model((Serializable)((Object)(ArrayUtils.isEmpty(this.repositoryModel.mailingLists) ? "" : StringUtils.flattenStrings(this.repositoryModel.mailingLists, " "))));
        form.add(new Component[]{new TextOption("mailingLists", this.getString("gb.mailingLists"), this.getString("gb.mailingLists"), "span6", this.mailingLists)});
        if (this.repositoryModel.accessRestriction.equals((Object)Constants.AccessRestrictionType.NONE)) {
            usersPalette.setEnabled(false);
            teamsPalette.setEnabled(false);
            verifyCommitter.setEnabled(false);
        } else {
            verifyCommitter.setEnabled(true);
            boolean allowFineGrainedControls = this.repositoryModel.authorizationControl.equals((Object)Constants.AuthorizationControl.NAMED);
            usersPalette.setEnabled(allowFineGrainedControls);
            teamsPalette.setEnabled(allowFineGrainedControls);
        }
        AjaxFormChoiceComponentUpdatingBehavior callback = new AjaxFormChoiceComponentUpdatingBehavior(){
            private static final long serialVersionUID = 1L;

            protected void onUpdate(AjaxRequestTarget target) {
                EditRepositoryPage.this.accessPolicyPanel.updateModel(EditRepositoryPage.this.repositoryModel);
                boolean allowAuthorizationControl = EditRepositoryPage.this.repositoryModel.accessRestriction.exceeds(Constants.AccessRestrictionType.NONE);
                verifyCommitter.setEnabled(allowAuthorizationControl);
                boolean allowFineGrainedControls = allowAuthorizationControl && EditRepositoryPage.this.repositoryModel.authorizationControl.equals((Object)Constants.AuthorizationControl.NAMED);
                usersPalette.setEnabled(allowFineGrainedControls);
                teamsPalette.setEnabled(allowFineGrainedControls);
                if (allowFineGrainedControls) {
                    EditRepositoryPage.this.repositoryModel.authorizationControl = Constants.AuthorizationControl.NAMED;
                }
                target.addComponent((Component)verifyCommitter);
                target.addComponent((Component)usersPalette);
                target.addComponent((Component)teamsPalette);
            }
        };
        this.accessPolicyPanel = new AccessPolicyPanel("accessPolicyPanel", this.repositoryModel, callback);
        form.add(new Component[]{this.accessPolicyPanel});
        form.add(new Component[]{new Button("save")});
        Button cancel = new Button("cancel"){
            private static final long serialVersionUID = 1L;

            public void onSubmit() {
                if (EditRepositoryPage.this.isCreate) {
                    this.setResponsePage(RepositoriesPage.class);
                } else {
                    this.setResponsePage(SummaryPage.class, WicketUtils.newRepositoryParameter(EditRepositoryPage.this.repositoryModel.name));
                }
            }
        };
        cancel.setDefaultFormProcessing(false);
        form.add(new Component[]{cancel});
        boolean canDelete = !this.isCreate && this.app().repositories().canDelete(this.repositoryModel) && (user.canAdmin() || user.isMyPersonalRepository(this.repositoryModel.name));
        Link<Void> delete = new Link<Void>("delete"){
            private static final long serialVersionUID = 1L;

            public void onClick() {
                RepositoryModel latestModel = EditRepositoryPage.this.app().repositories().getRepositoryModel(EditRepositoryPage.this.repositoryModel.name);
                boolean canDelete = EditRepositoryPage.this.app().repositories().canDelete(latestModel);
                if (canDelete) {
                    if (EditRepositoryPage.this.app().gitblit().deleteRepositoryModel(latestModel)) {
                        this.info(MessageFormat.format(this.getString("gb.repositoryDeleted"), latestModel));
                        if (latestModel.isPersonalRepository()) {
                            String prefix = EditRepositoryPage.this.app().settings().getString("git.userRepositoryPrefix", "~");
                            String username = latestModel.projectPath.substring(prefix.length());
                            this.setResponsePage(UserPage.class, WicketUtils.newUsernameParameter(username));
                        } else {
                            this.setResponsePage(RepositoriesPage.class);
                        }
                    } else {
                        this.error((Serializable)((Object)MessageFormat.format(this.getString("gb.repositoryDeleteFailed"), latestModel)));
                    }
                } else {
                    this.error((Serializable)((Object)MessageFormat.format(this.getString("gb.repositoryDeleteFailed"), latestModel)));
                }
            }
        };
        if (canDelete) {
            delete.add(new IBehavior[]{new BasePanel.JavascriptEventConfirmation("onclick", MessageFormat.format(this.getString("gb.deleteRepository"), this.repositoryModel))});
        }
        form.add(new Component[]{delete.setVisible(canDelete)});
        this.add(new Component[]{form});
    }

    private void checkPermissions(RepositoryModel model) {
        boolean authenticateAdmin = this.app().settings().getBoolean("web.authenticateAdminPages", true);
        boolean allowAdmin = this.app().settings().getBoolean("web.allowAdministration", true);
        GitBlitWebSession session = GitBlitWebSession.get();
        UserModel user = session.getUser();
        if (allowAdmin) {
            if (authenticateAdmin) {
                if (user == null) {
                    this.error(this.getString("gb.errorAdminLoginRequired"), true);
                }
                if (this.isCreate) {
                    if (!user.canCreate() && !user.canAdmin()) {
                        this.error(this.getString("gb.errorOnlyAdminMayCreateRepository"), true);
                    }
                } else {
                    if (user.canAdmin()) {
                        this.isAdmin = true;
                        return;
                    }
                    if (!model.isOwner(user.username)) {
                        this.error(this.getString("gb.errorOnlyAdminOrOwnerMayEditRepository"), true);
                    }
                }
            }
        } else {
            this.error(this.getString("gb.errorAdministrationDisabled"), true);
        }
    }

    private class MaxActivityCommitsRenderer
    implements IChoiceRenderer<Integer> {
        private static final long serialVersionUID = 1L;

        public String getDisplayValue(Integer value) {
            if (value == -1) {
                return EditRepositoryPage.this.getString("gb.excludeFromActivity");
            }
            if (value == 0) {
                return EditRepositoryPage.this.getString("gb.noMaximum");
            }
            return value + " " + EditRepositoryPage.this.getString("gb.commits");
        }

        public String getIdValue(Integer value, int index) {
            return Integer.toString(index);
        }
    }

    private class GCPeriodRenderer
    implements IChoiceRenderer<Integer> {
        private static final long serialVersionUID = 1L;

        public String getDisplayValue(Integer value) {
            if (value == 1) {
                return EditRepositoryPage.this.getString("gb.duration.oneDay");
            }
            return MessageFormat.format(EditRepositoryPage.this.getString("gb.duration.days"), value);
        }

        public String getIdValue(Integer value, int index) {
            return Integer.toString(index);
        }
    }

    private class FederationTypeRenderer
    implements IChoiceRenderer<Constants.FederationStrategy> {
        private static final long serialVersionUID = 1L;
        private final Map<Constants.FederationStrategy, String> map;

        public FederationTypeRenderer() {
            this.map = EditRepositoryPage.this.getFederationTypes();
        }

        public String getDisplayValue(Constants.FederationStrategy type) {
            return this.map.get((Object)type);
        }

        public String getIdValue(Constants.FederationStrategy type, int index) {
            return Integer.toString(index);
        }
    }
}

