/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.Constants;
import com.gitblit.GitBlitException;
import com.gitblit.models.RegistrantAccessPermission;
import com.gitblit.models.TeamModel;
import com.gitblit.models.UserChoice;
import com.gitblit.models.UserModel;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.RequiresAdminRole;
import com.gitblit.wicket.StringChoiceRenderer;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.BasePage;
import com.gitblit.wicket.pages.RootSubPage;
import com.gitblit.wicket.pages.TeamsPage;
import com.gitblit.wicket.panels.BulletListPanel;
import com.gitblit.wicket.panels.RegistrantPermissionsPanel;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.behavior.SimpleAttributeModifier;
import org.apache.wicket.extensions.markup.html.form.palette.Palette;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.util.CollectionModel;
import org.apache.wicket.model.util.ListModel;

@RequiresAdminRole
public class EditTeamPage
extends RootSubPage {
    private final boolean isCreate;
    private IModel<String> mailingLists;

    public EditTeamPage() {
        this.isCreate = true;
        this.setupPage(new TeamModel(""));
        this.setStatelessHint(false);
        this.setOutputMarkupId(true);
    }

    public EditTeamPage(PageParameters params) {
        super(params);
        this.isCreate = false;
        String name = WicketUtils.getTeamname(params);
        TeamModel model = this.app().users().getTeamModel(name);
        this.setupPage(model);
        this.setStatelessHint(false);
        this.setOutputMarkupId(true);
    }

    @Override
    protected boolean requiresPageMap() {
        return true;
    }

    @Override
    protected Class<? extends BasePage> getRootNavPageClass() {
        return TeamsPage.class;
    }

    protected void setupPage(final TeamModel teamModel) {
        if (this.isCreate) {
            super.setupPage(this.getString("gb.newTeam"), "");
        } else {
            super.setupPage(this.getString("gb.edit"), teamModel.name);
        }
        CompoundPropertyModel model = new CompoundPropertyModel((Object)teamModel);
        List<String> repos = this.getAccessRestrictedRepositoryList(true, null);
        ArrayList<String> teamUsers = new ArrayList<String>(teamModel.users);
        ArrayList<String> preReceiveScripts = new ArrayList<String>();
        ArrayList<String> postReceiveScripts = new ArrayList<String>();
        final String oldName = teamModel.name;
        final List<RegistrantAccessPermission> permissions = teamModel.getRepositoryPermissions();
        final Palette users = new Palette("users", (IModel)new ListModel(this.getTeamUsers(teamUsers)), (IModel)new CollectionModel(this.sortByDisplayName(this.getTeamUsers(this.app().users().getAllUsernames()))), (IChoiceRenderer)new ChoiceRenderer(null, "userId"), 10, false);
        if (teamModel.preReceiveScripts != null) {
            preReceiveScripts.addAll(teamModel.preReceiveScripts);
        }
        final Palette preReceivePalette = new Palette("preReceiveScripts", (IModel)new ListModel(preReceiveScripts), (IModel)new CollectionModel(this.app().repositories().getPreReceiveScriptsUnused(null)), (IChoiceRenderer)new StringChoiceRenderer(), 12, true);
        if (teamModel.postReceiveScripts != null) {
            postReceiveScripts.addAll(teamModel.postReceiveScripts);
        }
        final Palette postReceivePalette = new Palette("postReceiveScripts", (IModel)new ListModel(postReceiveScripts), (IModel)new CollectionModel(this.app().repositories().getPostReceiveScriptsUnused(null)), (IChoiceRenderer)new StringChoiceRenderer(), 12, true);
        Form<TeamModel> form = new Form<TeamModel>("editForm", (IModel)model){
            private static final long serialVersionUID = 1L;

            protected void onSubmit() {
                Object model;
                String teamname = teamModel.name;
                if (StringUtils.isEmpty(teamname)) {
                    this.error((Serializable)((Object)this.getString("gb.pleaseSetTeamName")));
                    return;
                }
                if (EditTeamPage.this.isCreate && (model = EditTeamPage.this.app().users().getTeamModel(teamname)) != null) {
                    this.error((Serializable)((Object)MessageFormat.format(this.getString("gb.teamNameUnavailable"), teamname)));
                    return;
                }
                for (RegistrantAccessPermission repositoryPermission : permissions) {
                    teamModel.setRepositoryPermission(repositoryPermission.registrant, repositoryPermission.permission);
                }
                Iterator selectedUsers = users.getSelectedChoices();
                ArrayList<String> members = new ArrayList<String>();
                while (selectedUsers.hasNext()) {
                    members.add(((UserChoice)selectedUsers.next()).getUserId().toLowerCase());
                }
                teamModel.users.clear();
                teamModel.users.addAll(members);
                String ml = (String)EditTeamPage.this.mailingLists.getObject();
                if (!StringUtils.isEmpty(ml)) {
                    HashSet<String> list = new HashSet<String>();
                    for (String address : ml.split("(,|\\s)")) {
                        if (StringUtils.isEmpty(address)) continue;
                        list.add(address.toLowerCase());
                    }
                    teamModel.mailingLists.clear();
                    teamModel.mailingLists.addAll(list);
                }
                ArrayList preReceiveScripts = new ArrayList();
                Iterator pres = preReceivePalette.getSelectedChoices();
                while (pres.hasNext()) {
                    preReceiveScripts.add(pres.next());
                }
                teamModel.preReceiveScripts.clear();
                teamModel.preReceiveScripts.addAll(preReceiveScripts);
                ArrayList postReceiveScripts = new ArrayList();
                Iterator post = postReceivePalette.getSelectedChoices();
                while (post.hasNext()) {
                    postReceiveScripts.add(post.next());
                }
                teamModel.postReceiveScripts.clear();
                teamModel.postReceiveScripts.addAll(postReceiveScripts);
                try {
                    if (EditTeamPage.this.isCreate) {
                        EditTeamPage.this.app().gitblit().addTeam(teamModel);
                    } else {
                        EditTeamPage.this.app().gitblit().reviseTeam(oldName, teamModel);
                    }
                }
                catch (GitBlitException e) {
                    this.error((Serializable)((Object)e.getMessage()));
                    return;
                }
                this.setRedirect(false);
                if (EditTeamPage.this.isCreate) {
                    this.info(MessageFormat.format(this.getString("gb.teamCreated"), teamModel.name));
                }
                this.setResponsePage(TeamsPage.class);
            }
        };
        form.add(new IBehavior[]{new SimpleAttributeModifier("autocomplete", (CharSequence)"off")});
        boolean editMemberships = this.app().authentication().supportsTeamMembershipChanges(teamModel);
        boolean changeAdminRole = this.app().authentication().supportsRoleChanges(teamModel, Constants.Role.ADMIN);
        boolean changeCreateRole = this.app().authentication().supportsRoleChanges(teamModel, Constants.Role.CREATE);
        boolean changeForkRole = this.app().authentication().supportsRoleChanges(teamModel, Constants.Role.FORK);
        form.add(new Component[]{new TextField("name")});
        form.add(new Component[]{new CheckBox("canAdmin").setEnabled(changeAdminRole)});
        form.add(new Component[]{new CheckBox("canFork").setEnabled(this.app().settings().getBoolean("web.allowForking", true) && changeForkRole)});
        form.add(new Component[]{new CheckBox("canCreate").setEnabled(changeCreateRole)});
        form.add(new Component[]{users.setEnabled(editMemberships)});
        this.mailingLists = new Model((Serializable)((Object)(teamModel.mailingLists == null ? "" : StringUtils.flattenStrings(teamModel.mailingLists, " "))));
        form.add(new Component[]{new TextField("mailingLists", this.mailingLists)});
        form.add(new Component[]{new RegistrantPermissionsPanel("repositories", Constants.RegistrantType.REPOSITORY, repos, permissions, this.getAccessPermissions())});
        form.add(new Component[]{preReceivePalette});
        form.add(new Component[]{new BulletListPanel("inheritedPreReceive", "inherited", this.app().repositories().getPreReceiveScriptsInherited(null))});
        form.add(new Component[]{postReceivePalette});
        form.add(new Component[]{new BulletListPanel("inheritedPostReceive", "inherited", this.app().repositories().getPostReceiveScriptsInherited(null))});
        form.add(new Component[]{new Button("save")});
        Button cancel = new Button("cancel"){
            private static final long serialVersionUID = 1L;

            public void onSubmit() {
                this.setResponsePage(TeamsPage.class);
            }
        };
        cancel.setDefaultFormProcessing(false);
        form.add(new Component[]{cancel});
        this.add(new Component[]{form});
    }

    private List<UserChoice> getTeamUsers(List<String> teamUserIds) {
        ArrayList<UserChoice> teamUsers = new ArrayList<UserChoice>();
        for (String teamUserId : teamUserIds) {
            UserModel userModel = this.app().users().getUserModel(teamUserId);
            if (userModel == null) continue;
            teamUsers.add(new UserChoice(userModel.displayName, userModel.username, userModel.emailAddress));
        }
        return this.sortByDisplayName(teamUsers);
    }

    private List<UserChoice> sortByDisplayName(List<UserChoice> teamUsers) {
        Collections.sort(teamUsers, new Comparator<UserChoice>(){

            @Override
            public int compare(UserChoice o1, UserChoice o2) {
                return o1.getDisplayNameOrUserId().compareTo(o2.getDisplayNameOrUserId());
            }
        });
        return teamUsers;
    }
}

