/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.Constants;
import com.gitblit.GitBlitException;
import com.gitblit.models.RegistrantAccessPermission;
import com.gitblit.models.TeamModel;
import com.gitblit.models.UserModel;
import com.gitblit.utils.PasswordHash;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.NonTrimmedPasswordTextField;
import com.gitblit.wicket.RequiresAdminRole;
import com.gitblit.wicket.StringChoiceRenderer;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.BasePage;
import com.gitblit.wicket.pages.Language;
import com.gitblit.wicket.pages.RootSubPage;
import com.gitblit.wicket.pages.UserPage;
import com.gitblit.wicket.pages.UsersPage;
import com.gitblit.wicket.panels.RegistrantPermissionsPanel;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.behavior.SimpleAttributeModifier;
import org.apache.wicket.extensions.markup.html.form.palette.Palette;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.util.CollectionModel;
import org.apache.wicket.model.util.ListModel;

@RequiresAdminRole
public class EditUserPage
extends RootSubPage {
    private final boolean isCreate;

    public EditUserPage() {
        this.isCreate = true;
        this.setupPage(new UserModel(""));
        this.setStatelessHint(false);
        this.setOutputMarkupId(true);
    }

    public EditUserPage(PageParameters params) {
        super(params);
        this.isCreate = false;
        String name = WicketUtils.getUsername(params);
        UserModel model = this.app().users().getUserModel(name);
        this.setupPage(model);
        this.setStatelessHint(false);
        this.setOutputMarkupId(true);
    }

    @Override
    protected boolean requiresPageMap() {
        return true;
    }

    @Override
    protected Class<? extends BasePage> getRootNavPageClass() {
        return UsersPage.class;
    }

    protected void setupPage(final UserModel userModel) {
        if (this.isCreate) {
            super.setupPage(this.getString("gb.newUser"), "");
        } else {
            super.setupPage(this.getString("gb.edit"), userModel.username);
        }
        Model confirmPassword = new Model((Serializable)((Object)""));
        String oldPassword = userModel.password;
        userModel.password = "";
        CompoundPropertyModel model = new CompoundPropertyModel((Object)userModel);
        List<String> repos = this.getAccessRestrictedRepositoryList(true, userModel);
        ArrayList<String> userTeams = new ArrayList<String>();
        for (TeamModel team : userModel.teams) {
            userTeams.add(team.name);
        }
        Collections.sort(userTeams);
        String oldName = userModel.username;
        List<RegistrantAccessPermission> permissions = this.app().repositories().getUserAccessPermissions(userModel);
        Palette teams = new Palette("teams", (IModel)new ListModel(new ArrayList(userTeams)), (IModel)new CollectionModel(this.app().users().getAllTeamNames()), (IChoiceRenderer)new StringChoiceRenderer(), 10, false);
        Locale locale = userModel.getPreferences().getLocale();
        List<Language> languages = UserPage.getLanguages();
        Language preferredLanguage = UserPage.getPreferredLanguage(locale, languages);
        Model language = Model.of((Serializable)preferredLanguage);
        Form<UserModel> form = new Form<UserModel>("editForm", (IModel)model, (IModel)language, oldName, confirmPassword, oldPassword, permissions, teams){
            private static final long serialVersionUID = 1L;
            final /* synthetic */ IModel val$language;
            final /* synthetic */ String val$oldName;
            final /* synthetic */ Model val$confirmPassword;
            final /* synthetic */ String val$oldPassword;
            final /* synthetic */ List val$permissions;
            final /* synthetic */ Palette val$teams;
            {
                this.val$language = iModel;
                this.val$oldName = string;
                this.val$confirmPassword = model;
                this.val$oldPassword = string2;
                this.val$permissions = list;
                this.val$teams = palette;
                super(x0, x1);
            }

            protected void onSubmit() {
                boolean rename;
                UserModel model;
                if (StringUtils.isEmpty(userModel.username)) {
                    this.error((Serializable)((Object)this.getString("gb.pleaseSetUsername")));
                    return;
                }
                Language lang = (Language)this.val$language.getObject();
                if (lang != null) {
                    userModel.getPreferences().setLocale(lang.code);
                }
                String username = userModel.username = userModel.username.toLowerCase();
                if (EditUserPage.this.isCreate && (model = EditUserPage.this.app().users().getUserModel(username)) != null) {
                    this.error((Serializable)((Object)MessageFormat.format(this.getString("gb.usernameUnavailable"), username)));
                    return;
                }
                boolean bl = rename = !StringUtils.isEmpty(this.val$oldName) && !this.val$oldName.equalsIgnoreCase(username);
                if (EditUserPage.this.app().authentication().supportsCredentialChanges(userModel)) {
                    if (!StringUtils.isEmpty(userModel.password)) {
                        String password = userModel.password;
                        if (!password.equals(this.val$confirmPassword.getObject())) {
                            this.error((Serializable)((Object)this.getString("gb.passwordsDoNotMatch")));
                            return;
                        }
                        int minLength = EditUserPage.this.app().settings().getInteger("realm.minPasswordLength", 5);
                        if (minLength < 4) {
                            minLength = 4;
                        }
                        if (password.trim().length() < minLength) {
                            this.error((Serializable)((Object)MessageFormat.format(this.getString("gb.passwordTooShort"), minLength)));
                            return;
                        }
                        userModel.cookie = userModel.createCookie();
                        String type = EditUserPage.this.app().settings().getString("realm.passwordStorage", PasswordHash.getDefaultType().name());
                        PasswordHash pwdh = PasswordHash.instanceOf(type);
                        if (pwdh != null) {
                            userModel.password = pwdh.toHashedEntry(password, username);
                        }
                    } else {
                        if (rename && this.val$oldPassword.toUpperCase().startsWith(PasswordHash.Type.CMD5.name())) {
                            this.error((Serializable)((Object)this.getString("gb.combinedMd5Rename")));
                            return;
                        }
                        userModel.password = this.val$oldPassword;
                    }
                }
                for (RegistrantAccessPermission repositoryPermission : this.val$permissions) {
                    if (!repositoryPermission.mutable) continue;
                    userModel.setRepositoryPermission(repositoryPermission.registrant, repositoryPermission.permission);
                }
                Iterator selectedTeams = this.val$teams.getSelectedChoices();
                userModel.teams.clear();
                while (selectedTeams.hasNext()) {
                    TeamModel team = EditUserPage.this.app().users().getTeamModel((String)selectedTeams.next());
                    if (team == null) continue;
                    userModel.teams.add(team);
                }
                try {
                    if (EditUserPage.this.isCreate) {
                        EditUserPage.this.app().gitblit().addUser(userModel);
                    } else {
                        EditUserPage.this.app().gitblit().reviseUser(this.val$oldName, userModel);
                    }
                }
                catch (GitBlitException e) {
                    this.error((Serializable)((Object)e.getMessage()));
                    return;
                }
                this.setRedirect(false);
                if (EditUserPage.this.isCreate) {
                    this.info(MessageFormat.format(this.getString("gb.userCreated"), userModel.username));
                    this.setResponsePage(EditUserPage.class);
                } else {
                    this.setResponsePage(UsersPage.class);
                }
            }
        };
        form.add(new IBehavior[]{new SimpleAttributeModifier("autocomplete", (CharSequence)"off")});
        boolean editCredentials = this.app().authentication().supportsCredentialChanges(userModel);
        boolean editDisplayName = this.app().authentication().supportsDisplayNameChanges(userModel);
        boolean editEmailAddress = this.app().authentication().supportsEmailAddressChanges(userModel);
        boolean editTeams = this.app().authentication().supportsTeamMembershipChanges(userModel);
        boolean changeAdminRole = this.app().authentication().supportsRoleChanges(userModel, Constants.Role.ADMIN);
        boolean changeCreateRole = this.app().authentication().supportsRoleChanges(userModel, Constants.Role.CREATE);
        boolean changeForkRole = this.app().authentication().supportsRoleChanges(userModel, Constants.Role.FORK);
        form.add(new Component[]{new TextField("username").setEnabled(editCredentials)});
        NonTrimmedPasswordTextField passwordField = new NonTrimmedPasswordTextField("password");
        passwordField.setResetPassword(false);
        passwordField.setRequired(false);
        form.add(new Component[]{passwordField.setEnabled(editCredentials)});
        NonTrimmedPasswordTextField confirmPasswordField = new NonTrimmedPasswordTextField("confirmPassword", (IModel<String>)confirmPassword);
        confirmPasswordField.setResetPassword(false);
        confirmPasswordField.setRequired(false);
        form.add(new Component[]{confirmPasswordField.setEnabled(editCredentials)});
        form.add(new Component[]{new TextField("displayName").setEnabled(editDisplayName)});
        form.add(new Component[]{new TextField("emailAddress").setEnabled(editEmailAddress)});
        DropDownChoice choice = new DropDownChoice("language", (IModel)language, languages);
        form.add(new Component[]{choice.setEnabled(languages.size() > 0)});
        if (userModel.canAdmin() && !userModel.canAdmin) {
            form.add(new Component[]{new CheckBox("canAdmin", (IModel)Model.of((Serializable)Boolean.valueOf(true))).setEnabled(false)});
        } else {
            form.add(new Component[]{new CheckBox("canAdmin").setEnabled(changeAdminRole)});
        }
        if (userModel.canFork() && !userModel.canFork) {
            form.add(new Component[]{new CheckBox("canFork", (IModel)Model.of((Serializable)Boolean.valueOf(true))).setEnabled(false)});
        } else {
            boolean forkingAllowed = this.app().settings().getBoolean("web.allowForking", true);
            form.add(new Component[]{new CheckBox("canFork").setEnabled(forkingAllowed && changeForkRole)});
        }
        if (userModel.canCreate() && !userModel.canCreate) {
            form.add(new Component[]{new CheckBox("canCreate", (IModel)Model.of((Serializable)Boolean.valueOf(true))).setEnabled(false)});
        } else {
            form.add(new Component[]{new CheckBox("canCreate").setEnabled(changeCreateRole)});
        }
        form.add(new Component[]{new CheckBox("excludeFromFederation")});
        form.add(new Component[]{new CheckBox("disabled")});
        form.add(new Component[]{new RegistrantPermissionsPanel("repositories", Constants.RegistrantType.REPOSITORY, repos, permissions, this.getAccessPermissions())});
        form.add(new Component[]{teams.setEnabled(editTeams)});
        form.add(new Component[]{new TextField("organizationalUnit").setEnabled(editDisplayName)});
        form.add(new Component[]{new TextField("organization").setEnabled(editDisplayName)});
        form.add(new Component[]{new TextField("locality").setEnabled(editDisplayName)});
        form.add(new Component[]{new TextField("stateProvince").setEnabled(editDisplayName)});
        form.add(new Component[]{new TextField("countryCode").setEnabled(editDisplayName)});
        form.add(new Component[]{new Button("save")});
        Button cancel = new Button("cancel"){
            private static final long serialVersionUID = 1L;

            public void onSubmit() {
                this.setResponsePage(UsersPage.class);
            }
        };
        cancel.setDefaultFormProcessing(false);
        form.add(new Component[]{cancel});
        this.add(new Component[]{form});
    }
}

