/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.models.RepositoryModel;
import com.gitblit.models.RepositoryUrl;
import com.gitblit.models.UserModel;
import com.gitblit.wicket.GitBlitWebSession;
import com.gitblit.wicket.GitblitRedirectException;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.RepositoryPage;
import com.gitblit.wicket.pages.SummaryPage;
import com.gitblit.wicket.panels.RepositoryUrlPanel;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.protocol.http.WebRequest;

public class EmptyRepositoryPage
extends RepositoryPage {
    public EmptyRepositoryPage(PageParameters params) {
        super(params);
        this.setVersioned(false);
        String repositoryName = WicketUtils.getRepositoryName(params);
        RepositoryModel repository = this.app().repositories().getRepositoryModel(repositoryName);
        if (repository == null) {
            this.error(this.getString("gb.canNotLoadRepository") + " " + repositoryName, true);
        }
        if (repository.hasCommits) {
            throw new GitblitRedirectException(SummaryPage.class, params);
        }
        UserModel user = GitBlitWebSession.get().getUser();
        if (user == null) {
            user = UserModel.ANONYMOUS;
        }
        HttpServletRequest req = ((WebRequest)this.getRequest()).getHttpServletRequest();
        List<RepositoryUrl> repositoryUrls = this.app().services().getRepositoryUrls(req, user, repository);
        RepositoryUrl primaryUrl = repositoryUrls.size() == 0 ? null : repositoryUrls.get(0);
        String url = primaryUrl != null ? primaryUrl.url : "";
        String createSyntax = this.readResource("create_git.md").replace("${primaryUrl}", url);
        String existingSyntax = this.readResource("existing_git.md").replace("${primaryUrl}", url);
        this.add(new Component[]{new Label("repository", repositoryName)});
        this.add(new Component[]{new RepositoryUrlPanel("pushurl", false, user, repository)});
        this.add(new Component[]{new Label("createSyntax", createSyntax)});
        this.add(new Component[]{new Label("existingSyntax", existingSyntax)});
    }

    @Override
    protected String getPageName() {
        return this.getString("gb.summary");
    }
}

