/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.models.RepositoryModel;
import com.gitblit.models.TicketModel;
import com.gitblit.tickets.TicketSerializer;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.RepositoriesPage;
import com.gitblit.wicket.pages.SessionPage;
import java.io.Serializable;
import org.apache.wicket.IRequestTarget;
import org.apache.wicket.Page;
import org.apache.wicket.PageParameters;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.protocol.http.WebResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportTicketPage
extends SessionPage {
    private final Logger logger = LoggerFactory.getLogger((String)((Object)((Object)this)).getClass().getSimpleName());
    String contentType;

    public ExportTicketPage(final PageParameters params) {
        super(params);
        if (!params.containsKey((Object)"r")) {
            this.error((Serializable)((Object)this.getString("gb.repositoryNotSpecified")));
            this.redirectToInterceptPage((Page)new RepositoriesPage());
        }
        this.getRequestCycle().setRequestTarget(new IRequestTarget(){

            public void detach(RequestCycle requestCycle) {
            }

            public void respond(RequestCycle requestCycle) {
                WebResponse response = (WebResponse)requestCycle.getResponse();
                String repositoryName = WicketUtils.getRepositoryName(params);
                RepositoryModel repository = ExportTicketPage.this.app().repositories().getRepositoryModel(repositoryName);
                String objectId = WicketUtils.getObject(params).toLowerCase();
                if (objectId.endsWith(".json")) {
                    objectId = objectId.substring(0, objectId.length() - ".json".length());
                }
                long id = Long.parseLong(objectId);
                TicketModel ticket = ExportTicketPage.this.app().tickets().getTicket(repository, id);
                String content = TicketSerializer.serialize(ticket);
                ExportTicketPage.this.contentType = "application/json; charset=UTF-8";
                response.setContentType(ExportTicketPage.this.contentType);
                try {
                    response.getOutputStream().write(content.getBytes("UTF-8"));
                }
                catch (Exception e) {
                    ExportTicketPage.this.logger.error("Failed to write text response", (Throwable)e);
                }
            }
        });
    }

    protected void setHeaders(WebResponse response) {
        super.setHeaders(response);
        if (!StringUtils.isEmpty(this.contentType)) {
            response.setContentType(this.contentType);
        }
    }
}

