/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.models.Metric;
import com.gitblit.utils.MetricUtils;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.CacheControl;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.charting.Chart;
import com.gitblit.wicket.charting.Charts;
import com.gitblit.wicket.charting.Flotr2Charts;
import com.gitblit.wicket.pages.BasePage;
import com.gitblit.wicket.pages.RepositoryPage;
import com.gitblit.wicket.pages.SummaryPage;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.behavior.HeaderContributor;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.markup.html.basic.Label;
import org.eclipse.jgit.lib.Repository;

@CacheControl(value=CacheControl.LastModified.REPOSITORY)
public class MetricsPage
extends RepositoryPage {
    public MetricsPage(PageParameters params) {
        super(params);
        Repository r = this.getRepository();
        if (StringUtils.isEmpty(this.objectId)) {
            this.add(new Component[]{new Label("branchTitle", this.getRepositoryModel().HEAD)});
        } else {
            this.add(new Component[]{new Label("branchTitle", this.objectId)});
        }
        Metric metricsTotal = null;
        List<Metric> metrics = MetricUtils.getDateMetrics(r, this.objectId, true, null, this.getTimeZone());
        metricsTotal = metrics.remove(0);
        if (metricsTotal == null) {
            this.add(new Component[]{new Label("branchStats", "")});
        } else {
            this.add(new Component[]{new Label("branchStats", MessageFormat.format(this.getString("gb.branchStats"), metricsTotal.count, metricsTotal.tag, this.getTimeUtils().duration(metricsTotal.duration)))});
        }
        Flotr2Charts charts = new Flotr2Charts();
        this.add(new Component[]{WicketUtils.newBlankImage("commitsChart")});
        this.add(new Component[]{WicketUtils.newBlankImage("dayOfWeekChart")});
        this.add(new Component[]{WicketUtils.newBlankImage("authorsChart")});
        this.createLineChart(charts, "commitsChart", metrics);
        this.createBarChart(charts, "dayOfWeekChart", this.getDayOfWeekMetrics(r, this.objectId));
        this.createPieChart(charts, "authorsChart", this.getAuthorMetrics(r, this.objectId));
        this.add(new IBehavior[]{new HeaderContributor((IHeaderContributor)charts)});
    }

    private void createLineChart(Charts charts, String id, List<Metric> metrics) {
        if (metrics != null && metrics.size() > 0) {
            Chart chart = charts.createLineChart(id, "", "day", this.getString("gb.commits"));
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            String displayFormat = "MMM dd";
            if (metrics.size() > 0 && metrics.get((int)0).name.length() == 7) {
                df = new SimpleDateFormat("yyyy-MM");
                displayFormat = "yyyy MMM";
            }
            df.setTimeZone(this.getTimeZone());
            chart.setDateFormat(displayFormat);
            for (Metric metric : metrics) {
                Date date;
                try {
                    date = df.parse(metric.name);
                }
                catch (ParseException e) {
                    this.logger().error("Unable to parse date: " + metric.name);
                    return;
                }
                chart.addValue(date, (int)metric.count);
                if (!(metric.tag > 0.0)) continue;
                chart.addHighlight(date, (int)metric.count);
            }
            charts.addChart(chart);
        }
    }

    private void createPieChart(Charts charts, String id, List<Metric> metrics) {
        if (metrics != null && metrics.size() > 0) {
            Chart chart = charts.createPieChart(id, "", "day", this.getString("gb.commits"));
            for (Metric metric : metrics) {
                chart.addValue(metric.name, (int)metric.count);
            }
            charts.addChart(chart);
        }
    }

    private void createBarChart(Charts charts, String id, List<Metric> metrics) {
        if (metrics != null && metrics.size() > 0) {
            Chart chart = charts.createBarChart(id, "", "day", this.getString("gb.commits"));
            for (Metric metric : metrics) {
                chart.addValue(metric.name, (int)metric.count);
            }
            charts.addChart(chart);
        }
    }

    private List<Metric> getDayOfWeekMetrics(Repository repository, String objectId) {
        List<Metric> list = MetricUtils.getDateMetrics(repository, objectId, false, "E", this.getTimeZone());
        SimpleDateFormat sdf = new SimpleDateFormat("E");
        Calendar cal = Calendar.getInstance();
        ArrayList<Metric> sorted = new ArrayList<Metric>();
        int firstDayOfWeek = cal.getFirstDayOfWeek();
        int dayOfWeek = cal.get(7);
        cal.add(5, firstDayOfWeek - dayOfWeek);
        for (int i = 0; i < 7; ++i) {
            String day = sdf.format(cal.getTime());
            for (Metric metric : list) {
                if (!metric.name.equals(day)) continue;
                sorted.add(metric);
                list.remove(metric);
                break;
            }
            cal.add(5, 1);
        }
        return sorted;
    }

    private List<Metric> getAuthorMetrics(Repository repository, String objectId) {
        List<Metric> authors = MetricUtils.getAuthorMetrics(repository, objectId, true);
        Collections.sort(authors, new Comparator<Metric>(){

            @Override
            public int compare(Metric o1, Metric o2) {
                if (o1.count > o2.count) {
                    return -1;
                }
                if (o1.count < o2.count) {
                    return 1;
                }
                return 0;
            }
        });
        if (authors.size() > 10) {
            return authors.subList(0, 9);
        }
        return authors;
    }

    @Override
    protected String getPageName() {
        return this.getString("gb.metrics");
    }

    @Override
    protected boolean isCommitPage() {
        return true;
    }

    @Override
    protected Class<? extends BasePage> getRepoNavPageClass() {
        return SummaryPage.class;
    }
}

