/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.models.RepositoryModel;
import com.gitblit.models.UserModel;
import com.gitblit.tickets.TicketMilestone;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.GitBlitWebSession;
import com.gitblit.wicket.Html5DateField;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.BasePage;
import com.gitblit.wicket.pages.RepositoryPage;
import com.gitblit.wicket.pages.TicketsPage;
import java.io.Serializable;
import java.util.Date;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.RestartResponseException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class NewMilestonePage
extends RepositoryPage {
    private IModel<String> nameModel;
    private IModel<Date> dueModel;

    public NewMilestonePage(PageParameters params) {
        super(params);
        RepositoryModel model = this.getRepositoryModel();
        if (!this.app().tickets().isAcceptingTicketUpdates(model)) {
            throw new RestartResponseException(TicketsPage.class, WicketUtils.newOpenTicketsParameter(this.repositoryName));
        }
        UserModel currentUser = GitBlitWebSession.get().getUser();
        if (currentUser == null) {
            currentUser = UserModel.ANONYMOUS;
        }
        if (!currentUser.isAuthenticated || !currentUser.canAdmin(model)) {
            throw new RestartResponseException(TicketsPage.class, WicketUtils.newOpenTicketsParameter(this.repositoryName));
        }
        this.setStatelessHint(false);
        this.setOutputMarkupId(true);
        Form form = new Form("editForm");
        this.add(new Component[]{form});
        this.nameModel = Model.of((Serializable)((Object)""));
        this.dueModel = Model.of((Serializable)new Date(System.currentTimeMillis() + 86400000L));
        form.add(new Component[]{new TextField("name", this.nameModel)});
        form.add(new Component[]{new Html5DateField("due", this.dueModel, "yyyy-MM-dd")});
        form.add(new Component[]{new Label("dueFormat", "yyyy-MM-dd")});
        this.addBottomScriptInline("{var e=document.createElement('input');e.type='date';if(e.type=='date'){$('[name=\"due\"]~.help-inline').hide()}}");
        this.addBottomScript("scripts/wicketHtml5Patch.js");
        form.add(new Component[]{new AjaxButton("create"){
            private static final long serialVersionUID = 1L;

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                String name = (String)NewMilestonePage.this.nameModel.getObject();
                if (StringUtils.isEmpty(name)) {
                    return;
                }
                TicketMilestone milestone = NewMilestonePage.this.app().tickets().getMilestone(NewMilestonePage.this.getRepositoryModel(), name);
                if (milestone != null) {
                    return;
                }
                Date due = (Date)NewMilestonePage.this.dueModel.getObject();
                UserModel currentUser = GitBlitWebSession.get().getUser();
                String createdBy = currentUser.username;
                milestone = NewMilestonePage.this.app().tickets().createMilestone(NewMilestonePage.this.getRepositoryModel(), name, createdBy);
                if (milestone != null) {
                    milestone.due = due;
                    NewMilestonePage.this.app().tickets().updateMilestone(NewMilestonePage.this.getRepositoryModel(), milestone, createdBy);
                    NewMilestonePage.this.redirectTo(TicketsPage.class, WicketUtils.newOpenTicketsParameter(NewMilestonePage.this.repositoryName));
                }
            }
        }});
        Button cancel = new Button("cancel"){
            private static final long serialVersionUID = 1L;

            public void onSubmit() {
                this.setResponsePage(TicketsPage.class, WicketUtils.newOpenTicketsParameter(NewMilestonePage.this.repositoryName));
            }
        };
        cancel.setDefaultFormProcessing(false);
        form.add(new Component[]{cancel});
    }

    @Override
    protected String getPageName() {
        return this.getString("gb.newMilestone");
    }

    @Override
    protected Class<? extends BasePage> getRepoNavPageClass() {
        return TicketsPage.class;
    }
}

