/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.Constants;
import com.gitblit.GitBlitException;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.UserModel;
import com.gitblit.utils.ArrayUtils;
import com.gitblit.utils.FileUtils;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.GitBlitWebSession;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.BasePage;
import com.gitblit.wicket.pages.RepositoriesPage;
import com.gitblit.wicket.pages.RootSubPage;
import com.gitblit.wicket.pages.SummaryPage;
import com.gitblit.wicket.panels.AccessPolicyPanel;
import com.gitblit.wicket.panels.BooleanChoiceOption;
import com.gitblit.wicket.panels.BooleanOption;
import com.gitblit.wicket.panels.RepositoryNamePanel;
import com.google.common.base.Optional;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.behavior.SimpleAttributeModifier;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

public class NewRepositoryPage
extends RootSubPage {
    private final RepositoryModel repositoryModel = new RepositoryModel();
    private IModel<Boolean> addReadmeModel;
    private Model<String> gitignoreModel;
    private IModel<Boolean> addGitflowModel;
    private IModel<Boolean> addGitignoreModel;
    private AccessPolicyPanel accessPolicyPanel;
    private RepositoryNamePanel namePanel;

    public NewRepositoryPage() {
        this.setupPage(this.getString("gb.newRepository"), "");
        this.setStatelessHint(false);
        this.setOutputMarkupId(true);
    }

    @Override
    protected boolean requiresPageMap() {
        return true;
    }

    @Override
    protected Class<? extends BasePage> getRootNavPageClass() {
        return RepositoriesPage.class;
    }

    protected void onInitialize() {
        Constants.AuthorizationControl defaultControl;
        super.onInitialize();
        CompoundPropertyModel rModel = new CompoundPropertyModel((Object)this.repositoryModel);
        Form<RepositoryModel> form = new Form<RepositoryModel>("editForm", (IModel)rModel){
            private static final long serialVersionUID = 1L;

            protected void onSubmit() {
                try {
                    if (!NewRepositoryPage.this.namePanel.updateModel(NewRepositoryPage.this.repositoryModel)) {
                        return;
                    }
                    NewRepositoryPage.this.accessPolicyPanel.updateModel(NewRepositoryPage.this.repositoryModel);
                    ((NewRepositoryPage)NewRepositoryPage.this).repositoryModel.owners = new ArrayList<String>();
                    ((NewRepositoryPage)NewRepositoryPage.this).repositoryModel.owners.add(GitBlitWebSession.get().getUsername());
                    boolean useGitFlow = (Boolean)NewRepositoryPage.this.addGitflowModel.getObject();
                    ((NewRepositoryPage)NewRepositoryPage.this).repositoryModel.HEAD = "refs/heads/master";
                    ((NewRepositoryPage)NewRepositoryPage.this).repositoryModel.mergeTo = "master";
                    if (useGitFlow) {
                        ((NewRepositoryPage)NewRepositoryPage.this).repositoryModel.mergeTo = "develop";
                    }
                    ((NewRepositoryPage)NewRepositoryPage.this).repositoryModel.allowForks = NewRepositoryPage.this.app().settings().getBoolean("web.allowForking", true);
                    boolean addReadme = (Boolean)NewRepositoryPage.this.addReadmeModel.getObject();
                    String gitignore = null;
                    boolean addGitignore = (Boolean)NewRepositoryPage.this.addGitignoreModel.getObject();
                    if (addGitignore && StringUtils.isEmpty(gitignore = (String)((Object)NewRepositoryPage.this.gitignoreModel.getObject()))) {
                        throw new GitBlitException(this.getString("gb.pleaseSelectGitIgnore"));
                    }
                    NewRepositoryPage.this.app().gitblit().updateRepositoryModel(((NewRepositoryPage)NewRepositoryPage.this).repositoryModel.name, NewRepositoryPage.this.repositoryModel, true);
                    NewRepositoryPage.this.initialCommit(NewRepositoryPage.this.repositoryModel, addReadme, gitignore, useGitFlow);
                }
                catch (GitBlitException e) {
                    this.error((Serializable)((Object)e.getMessage()));
                    return;
                }
                this.setRedirect(true);
                this.setResponsePage(SummaryPage.class, WicketUtils.newRepositoryParameter(((NewRepositoryPage)NewRepositoryPage.this).repositoryModel.name));
            }
        };
        form.add(new IBehavior[]{new SimpleAttributeModifier("autocomplete", (CharSequence)"off")});
        this.namePanel = new RepositoryNamePanel("namePanel", this.repositoryModel);
        form.add(new Component[]{this.namePanel});
        Constants.AccessRestrictionType defaultRestriction = Constants.AccessRestrictionType.fromName(this.app().settings().getString("git.defaultAccessRestriction", Constants.AccessRestrictionType.PUSH.name()));
        if (Constants.AccessRestrictionType.NONE == defaultRestriction) {
            defaultRestriction = Constants.AccessRestrictionType.PUSH;
        }
        if (Constants.AuthorizationControl.AUTHENTICATED == (defaultControl = Constants.AuthorizationControl.fromName(this.app().settings().getString("git.defaultAuthorizationControl", Constants.AuthorizationControl.NAMED.name())))) {
            defaultRestriction = Constants.AccessRestrictionType.PUSH;
        }
        this.repositoryModel.authorizationControl = defaultControl;
        this.repositoryModel.accessRestriction = defaultRestriction;
        this.accessPolicyPanel = new AccessPolicyPanel("accessPolicyPanel", this.repositoryModel);
        form.add(new Component[]{this.accessPolicyPanel});
        this.addReadmeModel = Model.of((Serializable)Boolean.valueOf(false));
        form.add(new Component[]{new BooleanOption("addReadme", this.getString("gb.initWithReadme"), this.getString("gb.initWithReadmeDescription"), this.addReadmeModel)});
        File gitignoreDir = this.app().runtime().getFileOrFolder("git.gitignoreFolder", "${baseFolder}/gitignore");
        File[] files = gitignoreDir.listFiles();
        if (files == null) {
            files = new File[]{};
        }
        ArrayList<String> gitignores = new ArrayList<String>();
        for (File file : files) {
            if (!file.isFile() || !file.getName().endsWith(".gitignore")) continue;
            gitignores.add(StringUtils.stripFileExtension(file.getName()));
        }
        Collections.sort(gitignores);
        this.gitignoreModel = Model.of((Serializable)((Object)""));
        this.addGitignoreModel = Model.of((Serializable)Boolean.valueOf(false));
        form.add(new Component[]{new BooleanChoiceOption<String>("addGitIgnore", this.getString("gb.initWithGitignore"), this.getString("gb.initWithGitignoreDescription"), this.addGitignoreModel, (IModel<String>)this.gitignoreModel, (List<String>)gitignores).setVisible(gitignores.size() > 0)});
        this.addGitflowModel = Model.of((Serializable)Boolean.valueOf(false));
        form.add(new Component[]{new BooleanOption("addGitFlow", "Include a .gitflow file", "This will generate a config file which guides Git clients in setting up Gitflow branches.", this.addGitflowModel).setVisible(false)});
        form.add(new Component[]{new Button("create")});
        this.add(new Component[]{form});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean initialCommit(RepositoryModel repository, boolean addReadme, String gitignore, boolean addGitFlow) {
        if (!addReadme && StringUtils.isEmpty(gitignore)) {
            if (!addGitFlow) return false;
        }
        boolean bl = true;
        boolean initialCommit = bl;
        if (!initialCommit) {
            return false;
        }
        boolean success = false;
        Repository db = this.app().repositories().getRepository(this.repositoryModel.name);
        ObjectInserter odi = db.newObjectInserter();
        try {
            byte[] bytes;
            File dir;
            File file;
            UserModel user = GitBlitWebSession.get().getUser();
            String email = (String)Optional.fromNullable((Object)user.emailAddress).or((Object)(user.username + "@gitblit"));
            PersonIdent author = new PersonIdent(user.getDisplayName(), email);
            DirCache newIndex = DirCache.newInCore();
            DirCacheBuilder indexBuilder = newIndex.builder();
            if (addReadme) {
                String title = StringUtils.stripDotGit(StringUtils.getLastPathElement(this.repositoryModel.name));
                String description = this.repositoryModel.description == null ? "" : this.repositoryModel.description;
                String readme = String.format("## %s\n\n%s\n\n", title, description);
                byte[] bytes2 = readme.getBytes("UTF-8");
                DirCacheEntry entry = new DirCacheEntry("README.md");
                entry.setLength(bytes2.length);
                entry.setLastModified(System.currentTimeMillis());
                entry.setFileMode(FileMode.REGULAR_FILE);
                entry.setObjectId((AnyObjectId)odi.insert(3, bytes2));
                indexBuilder.add(entry);
            }
            if (!StringUtils.isEmpty(gitignore) && (file = new File(dir = this.app().runtime().getFileOrFolder("git.gitignoreFolder", "${baseFolder}/gitignore"), gitignore + ".gitignore")).exists() && file.length() > 0L && !ArrayUtils.isEmpty(bytes = FileUtils.readContent(file))) {
                DirCacheEntry entry = new DirCacheEntry(".gitignore");
                entry.setLength(bytes.length);
                entry.setLastModified(System.currentTimeMillis());
                entry.setFileMode(FileMode.REGULAR_FILE);
                entry.setObjectId((AnyObjectId)odi.insert(3, bytes));
                indexBuilder.add(entry);
            }
            if (addGitFlow) {
                Config config = new Config();
                config.setString("gitflow", null, "masterBranch", "master");
                config.setString("gitflow", null, "developBranch", "develop");
                config.setString("gitflow", null, "featureBranchPrefix", "feature/");
                config.setString("gitflow", null, "releaseBranchPrefix", "release/");
                config.setString("gitflow", null, "hotfixBranchPrefix", "hotfix/");
                config.setString("gitflow", null, "supportBranchPrefix", "support/");
                config.setString("gitflow", null, "versionTagPrefix", "");
                byte[] bytes3 = config.toText().getBytes("UTF-8");
                DirCacheEntry entry = new DirCacheEntry(".gitflow");
                entry.setLength(bytes3.length);
                entry.setLastModified(System.currentTimeMillis());
                entry.setFileMode(FileMode.REGULAR_FILE);
                entry.setObjectId((AnyObjectId)odi.insert(3, bytes3));
                indexBuilder.add(entry);
            }
            indexBuilder.finish();
            if (newIndex.getEntryCount() == 0) {
                boolean config = false;
                return config;
            }
            ObjectId treeId = newIndex.writeTree(odi);
            CommitBuilder commit = new CommitBuilder();
            commit.setAuthor(author);
            commit.setCommitter(author);
            commit.setEncoding("UTF-8");
            commit.setMessage("Initial commit");
            commit.setTreeId((AnyObjectId)treeId);
            ObjectId commitId = odi.insert(commit);
            odi.flush();
            try (RevWalk revWalk = new RevWalk(db);){
                RevCommit revCommit = revWalk.parseCommit((AnyObjectId)commitId);
                RefUpdate masterRef = db.updateRef("refs/heads/master");
                masterRef.setNewObjectId((AnyObjectId)commitId);
                masterRef.setRefLogMessage("commit: " + revCommit.getShortMessage(), false);
                RefUpdate.Result masterRC = masterRef.update();
                switch (masterRC) {
                    case NEW: {
                        success = true;
                        break;
                    }
                    default: {
                        success = false;
                    }
                }
                if (!addGitFlow) return success;
                RefUpdate developRef = db.updateRef("refs/heads/develop");
                developRef.setNewObjectId((AnyObjectId)commitId);
                developRef.setRefLogMessage("commit: " + revCommit.getShortMessage(), false);
                RefUpdate.Result developRC = developRef.update();
                switch (developRC) {
                    case NEW: {
                        success = true;
                        return success;
                    }
                    default: {
                        success = false;
                        return success;
                    }
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            this.logger().error(null, (Throwable)e);
            return success;
        }
        catch (IOException e) {
            this.logger().error(null, (Throwable)e);
            return success;
        }
        finally {
            odi.close();
            db.close();
        }
    }
}

