/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.Constants;
import com.gitblit.models.RegistrantAccessPermission;
import com.gitblit.models.TicketModel;
import com.gitblit.models.UserModel;
import com.gitblit.tickets.TicketMilestone;
import com.gitblit.tickets.TicketNotifier;
import com.gitblit.tickets.TicketResponsible;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.GitBlitWebSession;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.BasePage;
import com.gitblit.wicket.pages.RepositoryPage;
import com.gitblit.wicket.pages.TicketsPage;
import com.gitblit.wicket.panels.MarkdownTextArea;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.PageParameters;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.eclipse.jgit.lib.Repository;

public class NewTicketPage
extends RepositoryPage {
    private IModel<TicketModel.Type> typeModel;
    private IModel<String> titleModel;
    private MarkdownTextArea descriptionEditor;
    private IModel<String> topicModel;
    private IModel<String> mergeToModel;
    private IModel<TicketResponsible> responsibleModel;
    private IModel<TicketMilestone> milestoneModel;
    private Label descriptionPreview;
    private IModel<TicketModel.Priority> priorityModel;
    private IModel<TicketModel.Severity> severityModel;

    public NewTicketPage(PageParameters params) {
        super(params);
        UserModel currentUser = GitBlitWebSession.get().getUser();
        if (currentUser == null) {
            currentUser = UserModel.ANONYMOUS;
        }
        if (!currentUser.isAuthenticated || !this.app().tickets().isAcceptingNewTickets(this.getRepositoryModel())) {
            this.setResponsePage(TicketsPage.class, WicketUtils.newRepositoryParameter(this.repositoryName));
        }
        this.typeModel = Model.of((Serializable)((Object)TicketModel.Type.defaultType));
        this.titleModel = Model.of();
        this.topicModel = Model.of();
        this.mergeToModel = Model.of((Serializable)((Object)Repository.shortenRefName((String)this.getRepositoryModel().mergeTo)));
        this.responsibleModel = Model.of();
        this.milestoneModel = Model.of();
        this.severityModel = Model.of((Serializable)((Object)TicketModel.Severity.defaultSeverity));
        this.priorityModel = Model.of((Serializable)((Object)TicketModel.Priority.defaultPriority));
        this.setStatelessHint(false);
        this.setOutputMarkupId(true);
        Form form = new Form("editForm");
        this.add(new Component[]{form});
        form.add(new Component[]{new DropDownChoice("type", this.typeModel, Arrays.asList(TicketModel.Type.choices()))});
        form.add(new Component[]{new TextField("title", this.titleModel)});
        form.add(new Component[]{new TextField("topic", this.topicModel)});
        form.add(new Component[]{new DropDownChoice("severity", this.severityModel, Arrays.asList(TicketModel.Severity.choices()))});
        Model markdownPreviewModel = Model.of();
        this.descriptionPreview = new Label("descriptionPreview", (IModel)markdownPreviewModel);
        this.descriptionPreview.setEscapeModelStrings(false);
        this.descriptionPreview.setOutputMarkupId(true);
        form.add(new Component[]{this.descriptionPreview});
        this.descriptionEditor = new MarkdownTextArea("description", (IModel<String>)markdownPreviewModel, this.descriptionPreview);
        this.descriptionEditor.setRepository(this.repositoryName);
        form.add(new Component[]{this.descriptionEditor});
        if (currentUser.canAdmin(null, this.getRepositoryModel())) {
            TreeSet<String> userlist = new TreeSet<String>();
            if (UserModel.ANONYMOUS.canPush(this.getRepositoryModel()) || Constants.AuthorizationControl.AUTHENTICATED == this.getRepositoryModel().authorizationControl) {
                userlist.addAll(this.app().users().getAllUsernames());
            } else {
                for (RegistrantAccessPermission registrantAccessPermission : this.app().repositories().getUserAccessPermissions(this.getRepositoryModel())) {
                    if (!registrantAccessPermission.permission.atLeast(Constants.AccessPermission.PUSH)) continue;
                    userlist.add(registrantAccessPermission.registrant);
                }
            }
            ArrayList<TicketResponsible> responsibles = new ArrayList<TicketResponsible>();
            for (String username : userlist) {
                UserModel user = this.app().users().getUserModel(username);
                if (user == null || user.disabled) continue;
                TicketResponsible responsible = new TicketResponsible(user);
                responsibles.add(responsible);
            }
            Collections.sort(responsibles);
            Fragment fragment = new Fragment("responsible", "responsibleFragment", (MarkupContainer)this);
            fragment.add(new Component[]{new DropDownChoice("responsible", this.responsibleModel, responsibles)});
            form.add(new Component[]{fragment.setVisible(!responsibles.isEmpty())});
            List<TicketMilestone> milestones = this.app().tickets().getMilestones(this.getRepositoryModel(), TicketModel.Status.Open);
            Fragment milestone = new Fragment("milestone", "milestoneFragment", (MarkupContainer)this);
            milestone.add(new Component[]{new DropDownChoice("milestone", this.milestoneModel, milestones)});
            form.add(new Component[]{milestone.setVisible(!milestones.isEmpty())});
            Fragment priority = new Fragment("priority", "priorityFragment", (MarkupContainer)this);
            priority.add(new Component[]{new DropDownChoice("priority", this.priorityModel, Arrays.asList(TicketModel.Priority.choices()))});
            form.add(new Component[]{priority});
            ArrayList<String> branches = new ArrayList<String>();
            for (String branch : this.getRepositoryModel().getLocalBranches()) {
                if (branch.startsWith("refs/heads/ticket/")) continue;
                branches.add(Repository.shortenRefName((String)branch));
            }
            branches.remove(Repository.shortenRefName((String)this.getRepositoryModel().HEAD));
            branches.add(0, Repository.shortenRefName((String)this.getRepositoryModel().HEAD));
            Fragment mergeto = new Fragment("mergeto", "mergeToFragment", (MarkupContainer)this);
            mergeto.add(new Component[]{new DropDownChoice("mergeto", this.mergeToModel, branches)});
            form.add(new Component[]{mergeto.setVisible(!branches.isEmpty())});
        } else {
            form.add(new Component[]{new Label("responsible").setVisible(false)});
            form.add(new Component[]{new Label("milestone").setVisible(false)});
            form.add(new Component[]{new Label("mergeto").setVisible(false)});
            form.add(new Component[]{new Label("priority").setVisible(false)});
        }
        form.add(new Component[]{new AjaxButton("create"){
            private static final long serialVersionUID = 1L;

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                TicketModel ticket;
                TicketMilestone milestone;
                TicketResponsible responsible;
                String title = (String)NewTicketPage.this.titleModel.getObject();
                if (StringUtils.isEmpty(title)) {
                    return;
                }
                String createdBy = GitBlitWebSession.get().getUsername();
                TicketModel.Change change = new TicketModel.Change(createdBy);
                change.setField(TicketModel.Field.title, title);
                change.setField(TicketModel.Field.body, NewTicketPage.this.descriptionEditor.getText());
                String topic = (String)NewTicketPage.this.topicModel.getObject();
                if (!StringUtils.isEmpty(topic)) {
                    change.setField(TicketModel.Field.topic, topic);
                }
                TicketModel.Type type = TicketModel.Type.defaultType;
                if (NewTicketPage.this.typeModel.getObject() != null) {
                    type = (TicketModel.Type)((Object)NewTicketPage.this.typeModel.getObject());
                }
                change.setField(TicketModel.Field.type, (Object)type);
                TicketResponsible ticketResponsible = responsible = NewTicketPage.this.responsibleModel == null ? null : (TicketResponsible)NewTicketPage.this.responsibleModel.getObject();
                if (responsible != null) {
                    change.setField(TicketModel.Field.responsible, responsible.username);
                }
                TicketMilestone ticketMilestone = milestone = NewTicketPage.this.milestoneModel == null ? null : (TicketMilestone)NewTicketPage.this.milestoneModel.getObject();
                if (milestone != null) {
                    change.setField(TicketModel.Field.milestone, milestone.name);
                }
                TicketModel.Severity severity = TicketModel.Severity.defaultSeverity;
                if (NewTicketPage.this.severityModel.getObject() != null) {
                    severity = (TicketModel.Severity)((Object)NewTicketPage.this.severityModel.getObject());
                }
                change.setField(TicketModel.Field.severity, (Object)severity);
                TicketModel.Priority priority = TicketModel.Priority.defaultPriority;
                if (NewTicketPage.this.priorityModel.getObject() != null) {
                    priority = (TicketModel.Priority)((Object)NewTicketPage.this.priorityModel.getObject());
                }
                change.setField(TicketModel.Field.priority, (Object)priority);
                String mergeTo = (String)NewTicketPage.this.mergeToModel.getObject();
                if (!StringUtils.isEmpty(mergeTo)) {
                    change.setField(TicketModel.Field.mergeTo, mergeTo);
                }
                if ((ticket = NewTicketPage.this.app().tickets().createTicket(NewTicketPage.this.getRepositoryModel(), 0L, change)) != null) {
                    TicketNotifier notifier = NewTicketPage.this.app().tickets().createNotifier();
                    notifier.sendMailing(ticket);
                    NewTicketPage.this.redirectTo(TicketsPage.class, WicketUtils.newObjectParameter(NewTicketPage.this.getRepositoryModel().name, "" + ticket.number));
                }
            }
        }});
        Button cancel = new Button("cancel"){
            private static final long serialVersionUID = 1L;

            public void onSubmit() {
                this.setResponsePage(TicketsPage.class, NewTicketPage.this.getPageParameters());
            }
        };
        cancel.setDefaultFormProcessing(false);
        form.add(new Component[]{cancel});
    }

    @Override
    protected String getPageName() {
        return this.getString("gb.newTicket");
    }

    @Override
    protected Class<? extends BasePage> getRepoNavPageClass() {
        return TicketsPage.class;
    }
}

