/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.models.Menu;
import com.gitblit.models.NavLink;
import com.gitblit.models.ProjectModel;
import com.gitblit.wicket.GitBlitWebSession;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.BasePage;
import com.gitblit.wicket.pages.ProjectPage;
import com.gitblit.wicket.pages.RepositoriesPage;
import com.gitblit.wicket.pages.RootPage;
import com.gitblit.wicket.panels.LinkPanel;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.markup.repeater.data.ListDataProvider;

public class ProjectsPage
extends RootPage {
    public ProjectsPage() {
        this.setup(null);
    }

    public ProjectsPage(PageParameters params) {
        super(params);
        this.setup(params);
    }

    @Override
    protected boolean reusePageParameters() {
        return true;
    }

    @Override
    protected Class<? extends BasePage> getRootNavPageClass() {
        return RepositoriesPage.class;
    }

    @Override
    protected List<ProjectModel> getProjectModels() {
        return this.app().projects().getProjectModels(this.getRepositoryModels(), false);
    }

    private void setup(PageParameters params) {
        this.setupPage("", "");
        boolean authenticateView = this.app().settings().getBoolean("web.authenticateViewPages", true);
        if (authenticateView && !GitBlitWebSession.get().isLoggedIn()) {
            this.add(new Component[]{new Label("projectsPanel")});
            return;
        }
        List<ProjectModel> projects = this.getProjects(params);
        Collections.sort(projects);
        ListDataProvider dp = new ListDataProvider(projects);
        DataView<ProjectModel> dataView = new DataView<ProjectModel>("project", (IDataProvider)dp){
            private static final long serialVersionUID = 1L;
            int counter;

            protected void onBeforeRender() {
                super.onBeforeRender();
                this.counter = 0;
            }

            public void populateItem(Item<ProjectModel> item) {
                ProjectModel entry = (ProjectModel)item.getModelObject();
                PageParameters pp = WicketUtils.newProjectParameter(entry.name);
                item.add(new Component[]{new LinkPanel("projectTitle", "list", entry.getDisplayName(), ProjectPage.class, pp)});
                item.add(new Component[]{new LinkPanel("projectDescription", "list", entry.description, ProjectPage.class, pp)});
                item.add(new Component[]{new Label("repositoryCount", entry.repositories.size() + " " + (entry.repositories.size() == 1 ? this.getString("gb.repository") : this.getString("gb.repositories")))});
                String lastChange = entry.lastChange.getTime() == 0L ? "--" : ProjectsPage.this.getTimeUtils().timeAgo(entry.lastChange);
                Label lastChangeLabel = new Label("projectLastChange", lastChange);
                item.add(new Component[]{lastChangeLabel});
                WicketUtils.setCssClass((Component)lastChangeLabel, ProjectsPage.this.getTimeUtils().timeAgoCss(entry.lastChange));
                WicketUtils.setAlternatingBackground(item, this.counter);
                ++this.counter;
            }
        };
        this.add(new Component[]{dataView});
    }

    @Override
    protected void addDropDownMenus(List<NavLink> navLinks) {
        PageParameters params = this.getPageParameters();
        NavLink.DropDownPageMenuNavLink menu = new NavLink.DropDownPageMenuNavLink("gb.filters", ProjectsPage.class);
        menu.menuItems.addAll(this.getRepositoryFilterItems(params));
        menu.menuItems.addAll(this.getTimeFilterItems(params));
        if (menu.menuItems.size() > 0) {
            menu.menuItems.add(new Menu.ParameterMenuItem(this.getString("gb.reset")));
        }
        navLinks.add(menu);
    }
}

