/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.Constants;
import com.gitblit.GitBlitException;
import com.gitblit.extensions.RepositoryNavLinkExtension;
import com.gitblit.models.NavLink;
import com.gitblit.models.ProjectModel;
import com.gitblit.models.RefModel;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.SubmoduleModel;
import com.gitblit.models.UserModel;
import com.gitblit.models.UserRepositoryPreferences;
import com.gitblit.servlet.PagesServlet;
import com.gitblit.servlet.SyndicationServlet;
import com.gitblit.utils.ArrayUtils;
import com.gitblit.utils.BugtraqProcessor;
import com.gitblit.utils.DeepCopier;
import com.gitblit.utils.JGitUtils;
import com.gitblit.utils.ModelUtils;
import com.gitblit.utils.RefLogUtils;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.CacheControl;
import com.gitblit.wicket.GitBlitWebSession;
import com.gitblit.wicket.SessionlessForm;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.BasePage;
import com.gitblit.wicket.pages.ComparePage;
import com.gitblit.wicket.pages.DocsPage;
import com.gitblit.wicket.pages.EditRepositoryPage;
import com.gitblit.wicket.pages.EmptyRepositoryPage;
import com.gitblit.wicket.pages.ForkPage;
import com.gitblit.wicket.pages.ForksPage;
import com.gitblit.wicket.pages.GitSearchPage;
import com.gitblit.wicket.pages.LogPage;
import com.gitblit.wicket.pages.LuceneSearchPage;
import com.gitblit.wicket.pages.NewTicketPage;
import com.gitblit.wicket.pages.ProjectPage;
import com.gitblit.wicket.pages.ReflogPage;
import com.gitblit.wicket.pages.RepositoriesPage;
import com.gitblit.wicket.pages.RootPage;
import com.gitblit.wicket.pages.SummaryPage;
import com.gitblit.wicket.pages.TicketsPage;
import com.gitblit.wicket.pages.TreePage;
import com.gitblit.wicket.pages.UserPage;
import com.gitblit.wicket.panels.LinkPanel;
import com.gitblit.wicket.panels.NavigationPanel;
import com.gitblit.wicket.panels.RefsPanel;
import com.google.common.base.Optional;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.IRequestTarget;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.PageParameters;
import org.apache.wicket.RestartResponseException;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.behavior.SimpleAttributeModifier;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.link.ExternalLink;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.target.basic.RedirectRequestTarget;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;

public abstract class RepositoryPage
extends RootPage {
    private final String PARAM_STAR = "star";
    protected final String projectName;
    protected final String repositoryName;
    protected final String objectId;
    private transient Repository r;
    private RepositoryModel m;
    private Map<String, SubmoduleModel> submodules;
    private boolean showAdmin;
    private final boolean isOwner;

    public RepositoryPage(PageParameters params) {
        super(params);
        boolean allowAdmin;
        UserModel user;
        this.repositoryName = WicketUtils.getRepositoryName(params);
        String root = StringUtils.getFirstPathElement(this.repositoryName);
        this.projectName = StringUtils.isEmpty(root) ? this.app().settings().getString("web.repositoryRootGroupName", "main") : root;
        this.objectId = WicketUtils.getObject(params);
        if (StringUtils.isEmpty(this.repositoryName)) {
            this.error(MessageFormat.format(this.getString("gb.repositoryNotSpecifiedFor"), this.getPageName()), true);
        }
        if (!this.getRepositoryModel().hasCommits && ((Object)((Object)this)).getClass() != EmptyRepositoryPage.class) {
            throw new RestartResponseException(EmptyRepositoryPage.class, params);
        }
        if (this.getRepositoryModel().isCollectingGarbage) {
            this.error(MessageFormat.format(this.getString("gb.busyCollectingGarbage"), this.getRepositoryModel().name), true);
        }
        if (this.objectId != null) {
            RefModel branch = null;
            branch = JGitUtils.getBranch(this.getRepository(), this.objectId);
            if (branch != null) {
                boolean canAccess;
                user = GitBlitWebSession.get().getUser();
                if (user == null) {
                    user = UserModel.ANONYMOUS;
                }
                if (!(canAccess = user.canView(this.getRepositoryModel(), branch.reference.getName()))) {
                    this.error(this.getString("gb.accessDenied"), true);
                }
            }
        }
        if (params.containsKey((Object)"star")) {
            boolean star = params.getBoolean("star");
            user = GitBlitWebSession.get().getUser();
            if (user != null && user.isAuthenticated) {
                UserRepositoryPreferences prefs = user.getPreferences().getRepositoryPreferences(this.getRepositoryModel().name);
                prefs.starred = star;
                try {
                    this.app().gitblit().reviseUser(user.username, user);
                }
                catch (GitBlitException e) {
                    this.logger().error("Failed to update user " + user.username, (Throwable)e);
                    this.error(this.getString("gb.failedToUpdateUser"), false);
                }
            }
        }
        this.showAdmin = false;
        this.showAdmin = this.app().settings().getBoolean("web.authenticateAdminPages", true) ? (allowAdmin = this.app().settings().getBoolean("web.allowAdministration", false)) && GitBlitWebSession.get().canAdmin() : this.app().settings().getBoolean("web.allowAdministration", false);
        this.isOwner = GitBlitWebSession.get().isLoggedIn() && this.getRepositoryModel().isOwner(GitBlitWebSession.get().getUsername());
        List<NavLink> navLinks = this.registerNavLinks();
        NavigationPanel navigationPanel = new NavigationPanel("repositoryNavPanel", this.getRepoNavPageClass(), navLinks);
        this.add(new Component[]{navigationPanel});
        this.add(new Component[]{new ExternalLink("syndication", SyndicationServlet.asLink(this.getRequest().getRelativePathPrefixToContextRoot(), this.getRepositoryName(), null, 0))});
        SearchForm searchForm = new SearchForm("searchForm", this.getRepositoryName());
        this.add(new Component[]{searchForm});
        searchForm.setTranslatedAttributes();
        this.addBottomScript("../../clipboard/clipboard.min.js");
        this.addBottomScript("../../clipboard/gitblit-ctcbtn.js");
        this.setStatelessHint(true);
    }

    @Override
    protected Class<? extends BasePage> getRootNavPageClass() {
        return RepositoriesPage.class;
    }

    protected Class<? extends BasePage> getRepoNavPageClass() {
        return ((Object)((Object)this)).getClass();
    }

    protected BugtraqProcessor bugtraqProcessor() {
        return new BugtraqProcessor(this.app().settings());
    }

    private List<NavLink> registerNavLinks() {
        Repository r = this.getRepository();
        RepositoryModel model = this.getRepositoryModel();
        PageParameters params = null;
        PageParameters objectParams = null;
        if (!StringUtils.isEmpty(this.repositoryName)) {
            RevCommit commit;
            objectParams = params = WicketUtils.newRepositoryParameter(this.getRepositoryName());
            if (this.isCommitPage() && !StringUtils.isEmpty(this.objectId) && (commit = JGitUtils.getCommit(r, this.objectId)) != null) {
                String bestId = this.getBestCommitId(commit);
                if (!commit.getName().equals(bestId)) {
                    objectParams = WicketUtils.newObjectParameter(this.getRepositoryName(), bestId);
                }
            }
        }
        ArrayList<NavLink> navLinks = new ArrayList<NavLink>();
        if (RefLogUtils.getRefLogBranch(r) == null) {
            navLinks.add(new NavLink.PageNavLink("gb.summary", SummaryPage.class, params));
        } else {
            navLinks.add(new NavLink.PageNavLink("gb.summary", SummaryPage.class, params));
            navLinks.add(new NavLink.PageNavLink("gb.reflog", ReflogPage.class, params));
        }
        if (!model.hasCommits) {
            return navLinks;
        }
        navLinks.add(new NavLink.PageNavLink("gb.commits", LogPage.class, objectParams));
        navLinks.add(new NavLink.PageNavLink("gb.tree", TreePage.class, objectParams));
        if (this.app().tickets().isReady() && (this.app().tickets().isAcceptingNewTickets(model) || this.app().tickets().hasTickets(model))) {
            PageParameters tParams = WicketUtils.newOpenTicketsParameter(this.getRepositoryName());
            navLinks.add(new NavLink.PageNavLink("gb.tickets", TicketsPage.class, tParams));
        }
        navLinks.add(new NavLink.PageNavLink("gb.docs", DocsPage.class, objectParams, true));
        if (this.app().settings().getBoolean("web.allowForking", true)) {
            navLinks.add(new NavLink.PageNavLink("gb.forks", ForksPage.class, params, true));
        }
        navLinks.add(new NavLink.PageNavLink("gb.compare", ComparePage.class, params, true));
        if (JGitUtils.getPagesBranch(r) != null) {
            NavLink.ExternalNavLink pagesLink = new NavLink.ExternalNavLink("gb.pages", PagesServlet.asLink(this.getRequest().getRelativePathPrefixToContextRoot(), this.getRepositoryName(), null), true);
            navLinks.add(pagesLink);
        }
        UserModel user = UserModel.ANONYMOUS;
        if (GitBlitWebSession.get().isLoggedIn()) {
            user = GitBlitWebSession.get().getUser();
        }
        List<RepositoryNavLinkExtension> extensions = this.app().plugins().getExtensions(RepositoryNavLinkExtension.class);
        for (RepositoryNavLinkExtension ext : extensions) {
            navLinks.addAll(ext.getNavLinks(user, model));
        }
        return navLinks;
    }

    protected boolean allowForkControls() {
        return this.app().settings().getBoolean("web.allowForking", true);
    }

    @Override
    protected void setupPage(String repositoryName, String pageName) {
        if (this.get("projectTitle") != null) {
            return;
        }
        String projectName = StringUtils.getFirstPathElement(repositoryName);
        ProjectModel project = this.app().projects().getProjectModel(projectName);
        if (project.isUserProject()) {
            this.add(new Component[]{new LinkPanel("projectTitle", null, project.getDisplayName(), UserPage.class, WicketUtils.newUsernameParameter(project.name.substring(1)))});
        } else {
            this.add(new Component[]{new LinkPanel("projectTitle", null, project.name, ProjectPage.class, WicketUtils.newProjectParameter(project.name))});
        }
        String name = StringUtils.stripDotGit(repositoryName);
        if (!StringUtils.isEmpty(projectName) && name.startsWith(projectName)) {
            name = name.substring(projectName.length() + 1);
        }
        this.add(new Component[]{new LinkPanel("repositoryName", null, name, SummaryPage.class, WicketUtils.newRepositoryParameter(repositoryName))});
        UserModel user = GitBlitWebSession.get().getUser();
        if (user == null) {
            user = UserModel.ANONYMOUS;
        }
        RepositoryModel model = this.getRepositoryModel();
        if (StringUtils.isEmpty(model.originRepository)) {
            if (model.isMirror) {
                this.add(new Component[]{new Fragment("repoIcon", "mirrorIconFragment", (MarkupContainer)this)});
                Fragment mirrorFrag = new Fragment("originRepository", "mirrorFragment", (MarkupContainer)this);
                Label lbl = new Label("originRepository", MessageFormat.format(this.getString("gb.mirrorOf"), "<b>" + model.origin + "</b>"));
                mirrorFrag.add(new Component[]{lbl.setEscapeModelStrings(false)});
                this.add(new Component[]{mirrorFrag});
            } else {
                if (model.isBare) {
                    this.add(new Component[]{new Fragment("repoIcon", "repoIconFragment", (MarkupContainer)this)});
                } else {
                    this.add(new Component[]{new Fragment("repoIcon", "cloneIconFragment", (MarkupContainer)this)});
                }
                this.add(new Component[]{new Label("originRepository", (String)Optional.of((Object)model.description).or((Object)""))});
            }
        } else {
            Fragment forkFrag;
            RepositoryModel origin = this.app().repositories().getRepositoryModel(model.originRepository);
            if (origin == null) {
                if (model.isBare) {
                    this.add(new Component[]{new Fragment("repoIcon", "repoIconFragment", (MarkupContainer)this)});
                } else {
                    this.add(new Component[]{new Fragment("repoIcon", "cloneIconFragment", (MarkupContainer)this)});
                }
                this.add(new Component[]{new Label("originRepository", (String)Optional.of((Object)model.description).or((Object)""))});
            } else if (!user.canView(origin)) {
                this.add(new Component[]{new Fragment("repoIcon", "forkIconFragment", (MarkupContainer)this)});
                forkFrag = new Fragment("originRepository", "originFragment", (MarkupContainer)this);
                forkFrag.add(new Component[]{new Label("originRepository", StringUtils.stripDotGit(model.originRepository))});
                this.add(new Component[]{forkFrag});
            } else {
                this.add(new Component[]{new Fragment("repoIcon", "forkIconFragment", (MarkupContainer)this)});
                forkFrag = new Fragment("originRepository", "originFragment", (MarkupContainer)this);
                forkFrag.add(new Component[]{new LinkPanel("originRepository", null, StringUtils.stripDotGit(model.originRepository), SummaryPage.class, WicketUtils.newRepositoryParameter(model.originRepository))});
                this.add(new Component[]{forkFrag});
            }
        }
        if (user.isAuthenticated && this.app().tickets().isAcceptingNewTickets(this.getRepositoryModel())) {
            String newTicketUrl = this.getRequestCycle().urlFor(NewTicketPage.class, WicketUtils.newRepositoryParameter(repositoryName)).toString();
            this.addToolbarButton("newTicketLink", "fa fa-ticket", this.getString("gb.new"), newTicketUrl);
        } else {
            this.add(new Component[]{new Label("newTicketLink").setVisible(false)});
        }
        if (user.isAuthenticated && model.hasCommits) {
            PageParameters starParams = DeepCopier.copy(this.getPageParameters());
            starParams.put("star", (Object)(!user.getPreferences().isStarredRepository(model.name) ? 1 : 0));
            String toggleStarUrl = this.getRequestCycle().urlFor(((Object)((Object)this)).getClass(), starParams).toString();
            if (user.getPreferences().isStarredRepository(model.name)) {
                this.add(new Component[]{new Label("starLink").setVisible(false)});
                this.addToolbarButton("unstarLink", "icon-star-empty", this.getString("gb.unstar"), toggleStarUrl);
            } else {
                this.addToolbarButton("starLink", "icon-star", this.getString("gb.star"), toggleStarUrl);
                this.add(new Component[]{new Label("unstarLink").setVisible(false)});
            }
        } else {
            this.add(new Component[]{new Label("starLink").setVisible(false)});
            this.add(new Component[]{new Label("unstarLink").setVisible(false)});
        }
        if (!this.allowForkControls() || !user.isAuthenticated) {
            this.add(new Component[]{new ExternalLink("forkLink", "").setVisible(false)});
            this.add(new Component[]{new ExternalLink("myForkLink", "").setVisible(false)});
        } else {
            boolean canFork;
            String fork = this.app().repositories().getFork(user.username, model.name);
            String userRepo = ModelUtils.getPersonalPath(user.username) + "/" + StringUtils.stripDotGit(StringUtils.getLastPathElement(model.name));
            boolean hasUserRepo = this.app().repositories().hasRepository(userRepo);
            boolean hasFork = fork != null;
            boolean bl = canFork = user.canFork(model) && model.hasCommits && !hasUserRepo;
            if (hasFork || !canFork) {
                this.add(new Component[]{new ExternalLink("forkLink", "").setVisible(false)});
                if (hasFork && !fork.equals(model.name)) {
                    String url = this.getRequestCycle().urlFor(SummaryPage.class, WicketUtils.newRepositoryParameter(fork)).toString();
                    this.add(new Component[]{new ExternalLink("myForkLink", url)});
                } else {
                    this.add(new Component[]{new ExternalLink("myForkLink", "").setVisible(false)});
                }
            } else if (canFork) {
                this.add(new Component[]{new ExternalLink("myForkLink", "").setVisible(false)});
                String url = this.getRequestCycle().urlFor(ForkPage.class, WicketUtils.newRepositoryParameter(model.name)).toString();
                this.add(new Component[]{new ExternalLink("forkLink", url)});
            }
        }
        if (this.showAdmin || this.isOwner) {
            String url = this.getRequestCycle().urlFor(EditRepositoryPage.class, WicketUtils.newRepositoryParameter(model.name)).toString();
            this.add(new Component[]{new ExternalLink("editLink", url)});
        } else {
            this.add(new Component[]{new Label("editLink").setVisible(false)});
        }
        super.setupPage(repositoryName, pageName);
    }

    protected void addToolbarButton(String wicketId, String iconClass, String label, String url) {
        Fragment button = new Fragment(wicketId, "toolbarLinkFragment", (MarkupContainer)this);
        Label icon = new Label("icon");
        WicketUtils.setCssClass((Component)icon, iconClass);
        button.add(new Component[]{icon});
        button.add(new Component[]{new Label("label", label)});
        button.add(new IBehavior[]{new SimpleAttributeModifier("href", (CharSequence)url)});
        this.add(new Component[]{button});
    }

    protected void addSyndicationDiscoveryLink() {
        this.add(new IBehavior[]{WicketUtils.syndicationDiscoveryLink(SyndicationServlet.getTitle(this.repositoryName, this.objectId), SyndicationServlet.asLink(this.getRequest().getRelativePathPrefixToContextRoot(), this.repositoryName, this.objectId, 0))});
    }

    protected Repository getRepository() {
        if (this.r == null) {
            Repository r = this.app().repositories().getRepository(this.repositoryName);
            if (r == null) {
                this.error(this.getString("gb.canNotLoadRepository") + " " + this.repositoryName, true);
                return null;
            }
            this.r = r;
        }
        return this.r;
    }

    protected RepositoryModel getRepositoryModel() {
        if (this.m == null) {
            RepositoryModel model = this.app().repositories().getRepositoryModel(GitBlitWebSession.get().getUser(), this.repositoryName);
            if (model == null) {
                if (this.app().repositories().hasRepository(this.repositoryName, true)) {
                    this.authenticationError(this.getString("gb.unauthorizedAccessForRepository") + " " + this.repositoryName);
                } else {
                    this.error(this.getString("gb.canNotLoadRepository") + " " + this.repositoryName, true);
                }
                return null;
            }
            this.m = model;
        }
        return this.m;
    }

    protected String getRepositoryName() {
        return this.getRepositoryModel().name;
    }

    protected RevCommit getCommit() {
        RevCommit commit = JGitUtils.getCommit(this.r, this.objectId);
        if (commit == null) {
            this.error(MessageFormat.format(this.getString("gb.failedToFindCommit"), this.objectId, this.repositoryName, this.getPageName()), null, LogPage.class, WicketUtils.newRepositoryParameter(this.repositoryName));
        }
        this.getSubmodules(commit);
        return commit;
    }

    protected String getBestCommitId(RevCommit commit) {
        String head = null;
        try {
            head = this.r.resolve(this.getRepositoryModel().HEAD).getName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String id = commit.getName();
        if (!StringUtils.isEmpty(head) && head.equals(id)) {
            return Repository.shortenRefName((String)this.getRepositoryModel().HEAD);
        }
        for (RefModel ref : JGitUtils.getLocalBranches(this.r, false, -1)) {
            if (!ref.getObjectId().getName().equals(id)) continue;
            return Repository.shortenRefName((String)ref.getName());
        }
        return id;
    }

    protected Map<String, SubmoduleModel> getSubmodules(RevCommit commit) {
        if (this.submodules == null) {
            this.submodules = new HashMap<String, SubmoduleModel>();
            for (SubmoduleModel model : JGitUtils.getSubmodules(this.r, commit.getTree())) {
                this.submodules.put(model.path, model);
            }
        }
        return this.submodules;
    }

    protected SubmoduleModel getSubmodule(String path) {
        String name;
        SubmoduleModel model = null;
        if (this.submodules != null) {
            model = this.submodules.get(path);
        }
        if (model == null) {
            model = new SubmoduleModel(path.substring(path.lastIndexOf(47) + 1), path, path);
            model.hasSubmodule = false;
            model.gitblitPath = model.name;
            return model;
        }
        List<String> patterns = this.app().settings().getStrings("git.submoduleUrlPatterns");
        String submoduleName = StringUtils.extractRepositoryPath(model.url, patterns.toArray(new String[0]));
        String currentPath = "";
        if (this.repositoryName.indexOf(47) > -1) {
            currentPath = this.repositoryName.substring(0, this.repositoryName.lastIndexOf(47) + 1);
        }
        ArrayList<String> candidates = new ArrayList<String>();
        candidates.add(currentPath + StringUtils.stripDotGit(submoduleName));
        candidates.add((String)candidates.get(candidates.size() - 1) + ".git");
        if (submoduleName.lastIndexOf(47) > -1) {
            name = submoduleName.substring(submoduleName.lastIndexOf(47) + 1);
            candidates.add(currentPath + StringUtils.stripDotGit(name));
            candidates.add((String)candidates.get(candidates.size() - 1) + ".git");
        }
        candidates.add(StringUtils.stripDotGit(submoduleName));
        candidates.add((String)candidates.get(candidates.size() - 1) + ".git");
        if (submoduleName.lastIndexOf(47) > -1) {
            name = submoduleName.substring(submoduleName.lastIndexOf(47) + 1);
            candidates.add(StringUtils.stripDotGit(name));
            candidates.add((String)candidates.get(candidates.size() - 1) + ".git");
        }
        LinkedHashSet paths = new LinkedHashSet(candidates);
        for (String candidate : paths) {
            if (!this.app().repositories().hasRepository(candidate)) continue;
            model.hasSubmodule = true;
            model.gitblitPath = candidate;
            return model;
        }
        model.gitblitPath = (String)candidates.get(0);
        return model;
    }

    protected String getShortObjectId(String objectId) {
        return objectId.substring(0, this.app().settings().getInteger("web.shortCommitIdLength", 6));
    }

    protected void addRefs(Repository r, RevCommit c) {
        this.add(new Component[]{new RefsPanel("refsPanel", this.repositoryName, JGitUtils.getAllRefs(r, this.getRepositoryModel().showRemoteBranches).get(c.getId()))});
    }

    protected void addFullText(String wicketId, String text) {
        String html;
        RepositoryModel model = this.getRepositoryModel();
        String content = this.bugtraqProcessor().processCommitMessage(this.r, model, text);
        switch (model.commitMessageRenderer) {
            case MARKDOWN: {
                String safeContent = this.app().xssFilter().relaxed(content);
                html = MessageFormat.format("<div class='commit_message'>{0}</div>", safeContent);
                break;
            }
            default: {
                html = MessageFormat.format("<pre class='commit_message'>{0}</pre>", content);
            }
        }
        this.add(new Component[]{new Label(wicketId, html).setEscapeModelStrings(false)});
    }

    protected abstract String getPageName();

    protected boolean isCommitPage() {
        return false;
    }

    protected Component createPersonPanel(String wicketId, PersonIdent identity, Constants.SearchType searchType) {
        String name = identity == null ? "" : identity.getName();
        String address = identity == null ? "" : identity.getEmailAddress();
        name = StringUtils.removeNewlines(name);
        address = StringUtils.removeNewlines(address);
        boolean showEmail = this.app().settings().getBoolean("web.showEmailAddresses", false);
        if (!showEmail || StringUtils.isEmpty(name) || StringUtils.isEmpty(address)) {
            String value = name;
            if (StringUtils.isEmpty(value)) {
                value = showEmail ? address : this.getString("gb.missingUsername");
            }
            Fragment partial = new Fragment(wicketId, "partialPersonIdent", (MarkupContainer)this);
            LinkPanel link = new LinkPanel("personName", "list", value, GitSearchPage.class, WicketUtils.newSearchParameter(this.repositoryName, this.objectId, value, searchType));
            this.setPersonSearchTooltip((Component)link, value, searchType);
            partial.add(new Component[]{link});
            return partial;
        }
        Fragment fullPerson = new Fragment(wicketId, "fullPersonIdent", (MarkupContainer)this);
        LinkPanel nameLink = new LinkPanel("personName", "list", name, GitSearchPage.class, WicketUtils.newSearchParameter(this.repositoryName, this.objectId, name, searchType));
        this.setPersonSearchTooltip((Component)nameLink, name, searchType);
        fullPerson.add(new Component[]{nameLink});
        LinkPanel addressLink = new LinkPanel("personAddress", "hidden-phone list", "<" + address + ">", GitSearchPage.class, WicketUtils.newSearchParameter(this.repositoryName, this.objectId, address, searchType));
        this.setPersonSearchTooltip((Component)addressLink, address, searchType);
        fullPerson.add(new Component[]{addressLink});
        return fullPerson;
    }

    protected void setPersonSearchTooltip(Component component, String value, Constants.SearchType searchType) {
        if (searchType.equals((Object)Constants.SearchType.AUTHOR)) {
            WicketUtils.setHtmlTooltip(component, this.getString("gb.searchForAuthor") + " " + value);
        } else if (searchType.equals((Object)Constants.SearchType.COMMITTER)) {
            WicketUtils.setHtmlTooltip(component, this.getString("gb.searchForCommitter") + " " + value);
        }
    }

    protected void setChangeTypeTooltip(Component container2, DiffEntry.ChangeType type) {
        switch (type) {
            case ADD: {
                WicketUtils.setHtmlTooltip(container2, this.getString("gb.addition"));
                break;
            }
            case COPY: 
            case RENAME: {
                WicketUtils.setHtmlTooltip(container2, this.getString("gb.rename"));
                break;
            }
            case DELETE: {
                WicketUtils.setHtmlTooltip(container2, this.getString("gb.deletion"));
                break;
            }
            case MODIFY: {
                WicketUtils.setHtmlTooltip(container2, this.getString("gb.modification"));
            }
        }
    }

    @Override
    protected void onBeforeRender() {
        if (this.r != null) {
            this.r.close();
            this.r = null;
        }
        this.setupPage(this.getRepositoryName(), "/ " + this.getPageName());
        super.onBeforeRender();
    }

    @Override
    protected void setLastModified() {
        if (((Object)((Object)this)).getClass().isAnnotationPresent(CacheControl.class)) {
            CacheControl cacheControl = ((Object)((Object)this)).getClass().getAnnotation(CacheControl.class);
            switch (cacheControl.value()) {
                case REPOSITORY: {
                    RepositoryModel repository = this.getRepositoryModel();
                    if (repository == null) break;
                    this.setLastModified(repository.lastChange);
                    break;
                }
                case COMMIT: {
                    RevCommit commit = this.getCommit();
                    if (commit == null) break;
                    Date commitDate = JGitUtils.getCommitDate(commit);
                    this.setLastModified(commitDate);
                    break;
                }
                default: {
                    super.setLastModified();
                }
            }
        }
    }

    protected PageParameters newRepositoryParameter() {
        return WicketUtils.newRepositoryParameter(this.repositoryName);
    }

    protected PageParameters newCommitParameter() {
        return WicketUtils.newObjectParameter(this.repositoryName, this.objectId);
    }

    protected PageParameters newCommitParameter(String commitId) {
        return WicketUtils.newObjectParameter(this.repositoryName, commitId);
    }

    public boolean isShowAdmin() {
        return this.showAdmin;
    }

    public boolean isOwner() {
        return this.isOwner;
    }

    private class SearchForm
    extends SessionlessForm<Void>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String repositoryName;
        private final IModel<String> searchBoxModel;
        private final IModel<Constants.SearchType> searchTypeModel;

        public SearchForm(String id, String repositoryName) {
            super(id, ((Object)((Object)RepositoryPage.this)).getClass(), RepositoryPage.this.getPageParameters());
            this.searchBoxModel = new Model((Serializable)((Object)""));
            this.searchTypeModel = new Model((Serializable)((Object)Constants.SearchType.COMMIT));
            this.repositoryName = repositoryName;
            DropDownChoice searchType = new DropDownChoice("searchType", Arrays.asList(Constants.SearchType.values()));
            searchType.setModel(this.searchTypeModel);
            this.add(new Component[]{searchType.setVisible(RepositoryPage.this.app().settings().getBoolean("web.showSearchTypeSelection", false))});
            TextField searchBox = new TextField("searchBox", this.searchBoxModel);
            this.add(new Component[]{searchBox});
        }

        void setTranslatedAttributes() {
            WicketUtils.setHtmlTooltip(this.get("searchType"), this.getString("gb.searchTypeTooltip"));
            WicketUtils.setHtmlTooltip(this.get("searchBox"), MessageFormat.format(this.getString("gb.searchTooltip"), this.repositoryName));
            WicketUtils.setInputPlaceholder(this.get("searchBox"), this.getString("gb.search"));
        }

        public void onSubmit() {
            Constants.SearchType searchType = (Constants.SearchType)((Object)this.searchTypeModel.getObject());
            String searchString = (String)this.searchBoxModel.getObject();
            if (StringUtils.isEmpty(searchString)) {
                String absoluteUrl = RepositoryPage.this.getCanonicalUrl();
                this.getRequestCycle().setRequestTarget((IRequestTarget)new RedirectRequestTarget(absoluteUrl));
                return;
            }
            for (Constants.SearchType type : Constants.SearchType.values()) {
                if (!searchString.toLowerCase().startsWith(type.name().toLowerCase() + ":")) continue;
                searchType = type;
                searchString = searchString.substring(type.name().toLowerCase().length() + 1).trim();
                break;
            }
            Class searchPageClass = GitSearchPage.class;
            RepositoryModel model = RepositoryPage.this.app().repositories().getRepositoryModel(this.repositoryName);
            if (RepositoryPage.this.app().settings().getBoolean("web.allowLuceneIndexing", true) && !ArrayUtils.isEmpty(model.indexedBranches)) {
                searchPageClass = LuceneSearchPage.class;
            }
            PageParameters params = WicketUtils.newSearchParameter(this.repositoryName, null, searchString, searchType);
            String absoluteUrl = RepositoryPage.this.getCanonicalUrl(searchPageClass, params);
            this.getRequestCycle().setRequestTarget((IRequestTarget)new RedirectRequestTarget(absoluteUrl));
        }
    }
}

