/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.Constants;
import com.gitblit.extensions.NavLinkExtension;
import com.gitblit.extensions.UserMenuExtension;
import com.gitblit.models.Menu;
import com.gitblit.models.NavLink;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.TeamModel;
import com.gitblit.models.UserModel;
import com.gitblit.utils.ModelUtils;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.GitBlitWebSession;
import com.gitblit.wicket.NonTrimmedPasswordTextField;
import com.gitblit.wicket.SessionlessForm;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.ActivityPage;
import com.gitblit.wicket.pages.BasePage;
import com.gitblit.wicket.pages.ChangePasswordPage;
import com.gitblit.wicket.pages.FederationPage;
import com.gitblit.wicket.pages.FilestorePage;
import com.gitblit.wicket.pages.LogoutPage;
import com.gitblit.wicket.pages.LuceneSearchPage;
import com.gitblit.wicket.pages.MyDashboardPage;
import com.gitblit.wicket.pages.MyTicketsPage;
import com.gitblit.wicket.pages.RepositoriesPage;
import com.gitblit.wicket.pages.TeamsPage;
import com.gitblit.wicket.pages.UserPage;
import com.gitblit.wicket.pages.UsersPage;
import com.gitblit.wicket.panels.AvatarImage;
import com.gitblit.wicket.panels.LinkPanel;
import com.gitblit.wicket.panels.NavigationPanel;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.PageParameters;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.behavior.HeaderContributor;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.markup.repeater.data.ListDataProvider;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.protocol.http.WebRequest;
import org.apache.wicket.protocol.http.WebResponse;

public abstract class RootPage
extends BasePage {
    boolean showAdmin;
    IModel<String> username = new Model((Serializable)((Object)""));
    IModel<String> password = new Model((Serializable)((Object)""));
    List<RepositoryModel> repositoryModels = new ArrayList<RepositoryModel>();

    public RootPage() {
    }

    public RootPage(PageParameters params) {
        super(params);
    }

    @Override
    protected void setupPage(String repositoryName, String pageName) {
        this.add(new IBehavior[]{new HeaderContributor(new IHeaderContributor(){
            private static final long serialVersionUID = 1L;

            public void renderHead(IHeaderResponse response) {
                String headerHover;
                String headerForeground;
                String headerBorder;
                StringBuilder buffer = new StringBuilder();
                buffer.append("<style type=\"text/css\">\n");
                buffer.append(".navbar-inner {\n");
                String headerBackground = RootPage.this.app().settings().getString("web.headerBackgroundColor", null);
                if (!StringUtils.isEmpty(headerBackground)) {
                    buffer.append(MessageFormat.format("background-color: {0};\n", headerBackground));
                }
                if (!StringUtils.isEmpty(headerBorder = RootPage.this.app().settings().getString("web.headerBorderColor", null))) {
                    buffer.append(MessageFormat.format("border-bottom: 1px solid {0} !important;\n", headerBorder));
                }
                buffer.append("}\n");
                String headerBorderFocus = RootPage.this.app().settings().getString("web.headerBorderFocusColor", null);
                if (!StringUtils.isEmpty(headerBorderFocus)) {
                    buffer.append(".navbar ul li:focus, .navbar .active {\n");
                    buffer.append(MessageFormat.format("border-bottom: 4px solid {0};\n", headerBorderFocus));
                    buffer.append("}\n");
                }
                if (!StringUtils.isEmpty(headerForeground = RootPage.this.app().settings().getString("web.headerForegroundColor", null))) {
                    buffer.append(".navbar ul.nav li a {\n");
                    buffer.append(MessageFormat.format("color: {0};\n", headerForeground));
                    buffer.append("}\n");
                    buffer.append(".navbar ul.nav .active a {\n");
                    buffer.append(MessageFormat.format("color: {0};\n", headerForeground));
                    buffer.append("}\n");
                }
                if (!StringUtils.isEmpty(headerHover = RootPage.this.app().settings().getString("web.headerHoverColor", null))) {
                    buffer.append(".navbar ul.nav li a:hover {\n");
                    buffer.append(MessageFormat.format("color: {0} !important;\n", headerHover));
                    buffer.append("}\n");
                }
                buffer.append("</style>\n");
                response.renderString((CharSequence)buffer.toString());
            }
        })});
        boolean authenticateView = this.app().settings().getBoolean("web.authenticateViewPages", false);
        boolean authenticateAdmin = this.app().settings().getBoolean("web.authenticateAdminPages", true);
        boolean allowAdmin = this.app().settings().getBoolean("web.allowAdministration", true);
        boolean allowLucene = this.app().settings().getBoolean("web.allowLuceneIndexing", true);
        boolean displayUserPanel = this.app().settings().getBoolean("web.displayUserPanel", true);
        boolean isLoggedIn = GitBlitWebSession.get().isLoggedIn();
        if (authenticateAdmin) {
            this.showAdmin = allowAdmin && GitBlitWebSession.get().canAdmin();
            this.setStatelessHint(false);
        } else {
            this.showAdmin = allowAdmin;
            if (authenticateView) {
                this.setStatelessHint(false);
            } else {
                this.setStatelessHint(true);
            }
        }
        if (displayUserPanel && (authenticateView || authenticateAdmin)) {
            if (isLoggedIn) {
                UserMenu userFragment = new UserMenu("userPanel", "userMenuFragment", (MarkupContainer)this);
                this.add(new Component[]{userFragment});
            } else {
                LoginForm loginForm = new LoginForm("userPanel", "loginFormFragment", (MarkupContainer)this);
                this.add(new Component[]{loginForm});
            }
        } else {
            this.add(new Component[]{new Label("userPanel").setVisible(false)});
        }
        ArrayList<NavLink> navLinks = new ArrayList<NavLink>();
        if (!authenticateView || authenticateView && isLoggedIn) {
            UserModel user = UserModel.ANONYMOUS;
            if (isLoggedIn) {
                user = GitBlitWebSession.get().getUser();
            }
            navLinks.add(new NavLink.PageNavLink(isLoggedIn ? "gb.myDashboard" : "gb.dashboard", MyDashboardPage.class, this.getRootPageParameters()));
            if (isLoggedIn && this.app().tickets().isReady()) {
                navLinks.add(new NavLink.PageNavLink("gb.myTickets", MyTicketsPage.class));
            }
            navLinks.add(new NavLink.PageNavLink("gb.repositories", RepositoriesPage.class, this.getRootPageParameters()));
            navLinks.add(new NavLink.PageNavLink("gb.filestore", FilestorePage.class, this.getRootPageParameters()));
            navLinks.add(new NavLink.PageNavLink("gb.activity", ActivityPage.class, this.getRootPageParameters()));
            if (allowLucene) {
                navLinks.add(new NavLink.PageNavLink("gb.search", LuceneSearchPage.class));
            }
            if (!authenticateView || authenticateView && isLoggedIn) {
                this.addDropDownMenus(navLinks);
            }
            List<NavLinkExtension> extensions = this.app().plugins().getExtensions(NavLinkExtension.class);
            for (NavLinkExtension ext : extensions) {
                navLinks.addAll(ext.getNavLinks(user));
            }
        }
        NavigationPanel navPanel = new NavigationPanel("navPanel", this.getRootNavPageClass(), navLinks);
        this.add(new Component[]{navPanel});
        String cachedMessage = GitBlitWebSession.get().clearErrorMessage();
        if (!StringUtils.isEmpty(cachedMessage)) {
            this.error((Serializable)((Object)cachedMessage));
        } else if (this.showAdmin) {
            int pendingProposals = this.app().federation().getPendingFederationProposals().size();
            if (pendingProposals == 1) {
                this.info(this.getString("gb.OneProposalToReview"));
            } else if (pendingProposals > 1) {
                this.info(MessageFormat.format(this.getString("gb.nFederationProposalsToReview"), pendingProposals));
            }
        }
        super.setupPage(repositoryName, pageName);
    }

    protected Class<? extends BasePage> getRootNavPageClass() {
        return ((Object)((Object)this)).getClass();
    }

    private PageParameters getRootPageParameters() {
        PageParameters pp;
        if (this.reusePageParameters() && (pp = this.getPageParameters()) != null) {
            PageParameters params = new PageParameters((Map)pp);
            params.remove((Object)"p");
            params.remove((Object)"r");
            params.remove((Object)"user");
            if (params.containsKey((Object)"db") && params.getInt("db") == this.app().settings().getInteger("web.activityDuration", 7)) {
                params.remove((Object)"db");
            }
            return params;
        }
        return null;
    }

    protected boolean reusePageParameters() {
        return false;
    }

    private void loginUser(UserModel user) {
        if (user != null) {
            HttpServletRequest request = ((WebRequest)this.getRequest()).getHttpServletRequest();
            HttpServletResponse response = ((WebResponse)this.getResponse()).getHttpServletResponse();
            GitBlitWebSession session = GitBlitWebSession.get();
            session.replaceSession();
            session.setUser(user);
            request = ((WebRequest)this.getRequest()).getHttpServletRequest();
            response = ((WebResponse)this.getResponse()).getHttpServletResponse();
            request.getSession().setAttribute("Gitblit:authentication-type", (Object)Constants.AuthenticationType.CREDENTIALS);
            this.app().authentication().setCookie(request, response, user);
            if (!session.continueRequest()) {
                PageParameters params = this.getPageParameters();
                if (params == null) {
                    this.redirectTo(((Object)((Object)this)).getClass());
                } else {
                    params.remove((Object)"username");
                    params.remove((Object)"password");
                    this.redirectTo(((Object)((Object)this)).getClass(), params);
                }
            }
        }
    }

    protected List<RepositoryModel> getRepositoryModels() {
        if (this.repositoryModels.isEmpty()) {
            UserModel user = GitBlitWebSession.get().getUser();
            List<RepositoryModel> repositories = this.app().repositories().getRepositoryModels(user);
            this.repositoryModels.addAll(repositories);
            Collections.sort(this.repositoryModels);
        }
        return this.repositoryModels;
    }

    protected void addDropDownMenus(List<NavLink> navLinks) {
    }

    protected List<Menu.MenuItem> getRepositoryFilterItems(PageParameters params) {
        String customFilters;
        UserModel user = GitBlitWebSession.get().getUser();
        LinkedHashSet<Menu.MenuItem> filters = new LinkedHashSet<Menu.MenuItem>();
        List<RepositoryModel> repositories = this.getRepositoryModels();
        HashMap<String, AtomicInteger> setMap = new HashMap<String, AtomicInteger>();
        for (RepositoryModel repositoryModel : repositories) {
            for (String set : repositoryModel.federationSets) {
                String key = set.toLowerCase();
                if (setMap.containsKey(key)) {
                    ((AtomicInteger)setMap.get(key)).incrementAndGet();
                    continue;
                }
                setMap.put(key, new AtomicInteger(1));
            }
        }
        if (setMap.size() > 0) {
            ArrayList sets = new ArrayList(setMap.keySet());
            Collections.sort(sets);
            for (String set : sets) {
                filters.add(new Menu.ToggleMenuItem(MessageFormat.format("{0} ({1})", set, ((AtomicInteger)setMap.get(set)).get()), "set", set, params));
            }
            filters.add(new Menu.MenuDivider());
        }
        if (user != null && user.teams.size() > 0) {
            ArrayList<TeamModel> teams = new ArrayList<TeamModel>(user.teams);
            Collections.sort(teams);
            for (TeamModel team : teams) {
                filters.add(new Menu.ToggleMenuItem(MessageFormat.format("{0} ({1})", team.name, team.repositories.size()), "team", team.name, params));
            }
            filters.add(new Menu.MenuDivider());
        }
        if (!StringUtils.isEmpty(customFilters = this.app().settings().getString("web.customFilters", null))) {
            boolean bl;
            boolean bl2 = false;
            List<String> expressions = StringUtils.getStringsFromValue(customFilters, "!!!");
            for (String expression : expressions) {
                if (StringUtils.isEmpty(expression)) continue;
                bl = true;
                filters.add(new Menu.ToggleMenuItem(null, "x", expression, params));
            }
            if (bl) {
                filters.add(new Menu.MenuDivider());
            }
        }
        return new ArrayList<Menu.MenuItem>(filters);
    }

    protected List<Menu.MenuItem> getTimeFilterItems(PageParameters params) {
        PageParameters clonedParams;
        int daysBack = this.app().settings().getInteger("web.activityDuration", 7);
        int maxDaysBack = this.app().settings().getInteger("web.activityDurationMaximum", 30);
        if (daysBack < 1) {
            daysBack = 7;
        }
        if (daysBack > maxDaysBack) {
            daysBack = maxDaysBack;
        }
        if (!(clonedParams = params == null ? new PageParameters() : new PageParameters((Map)params)).containsKey((Object)"db")) {
            clonedParams.put("db", (Object)daysBack);
        }
        ArrayList<Menu.MenuItem> items = new ArrayList<Menu.MenuItem>();
        TreeSet<Integer> choicesSet = new TreeSet<Integer>(this.app().settings().getIntegers("web.activityDurationChoices"));
        if (choicesSet.isEmpty()) {
            choicesSet.addAll(Arrays.asList(1, 3, 7, 14, 21, 28));
        }
        ArrayList<Integer> choices = new ArrayList<Integer>(choicesSet);
        Collections.sort(choices);
        String lastDaysPattern = this.getString("gb.lastNDays");
        for (Integer db : choices) {
            if (db == 1) {
                items.add(new Menu.ParameterMenuItem(this.getString("gb.time.today"), "db", db.toString(), clonedParams));
                continue;
            }
            String txt = MessageFormat.format(lastDaysPattern, db);
            items.add(new Menu.ParameterMenuItem(txt, "db", db.toString(), clonedParams));
        }
        items.add(new Menu.MenuDivider());
        return items;
    }

    protected List<RepositoryModel> getRepositories(PageParameters params) {
        if (params == null) {
            return this.getRepositoryModels();
        }
        boolean hasParameter = false;
        String projectName = WicketUtils.getProjectName(params);
        String userName = WicketUtils.getUsername(params);
        if (StringUtils.isEmpty(projectName) && !StringUtils.isEmpty(userName)) {
            projectName = ModelUtils.getPersonalPath(userName);
        }
        String repositoryName = WicketUtils.getRepositoryName(params);
        String set = WicketUtils.getSet(params);
        String regex2 = WicketUtils.getRegEx(params);
        String team = WicketUtils.getTeam(params);
        int daysBack = params.getInt("db", 0);
        int maxDaysBack = this.app().settings().getInteger("web.activityDurationMaximum", 30);
        List<RepositoryModel> availableModels = this.getRepositoryModels();
        HashSet<RepositoryModel> models = new HashSet<RepositoryModel>();
        if (!StringUtils.isEmpty(repositoryName)) {
            hasParameter = true;
            for (RepositoryModel repositoryModel : availableModels) {
                if (!repositoryModel.name.equalsIgnoreCase(repositoryName)) continue;
                models.add(repositoryModel);
                break;
            }
        }
        if (!StringUtils.isEmpty(projectName)) {
            hasParameter = true;
            if (projectName.equalsIgnoreCase(this.app().settings().getString("web.repositoryRootGroupName", "main"))) {
                for (RepositoryModel repositoryModel : availableModels) {
                    if (repositoryModel.name.indexOf(47) != -1) continue;
                    models.add(repositoryModel);
                }
            } else {
                String group = projectName.toLowerCase() + "/";
                for (RepositoryModel repositoryModel : availableModels) {
                    if (!repositoryModel.name.toLowerCase().startsWith(group)) continue;
                    models.add(repositoryModel);
                }
            }
        }
        if (!StringUtils.isEmpty(regex2)) {
            hasParameter = true;
            Pattern pattern = Pattern.compile(regex2);
            for (RepositoryModel repositoryModel : availableModels) {
                if (!pattern.matcher(repositoryModel.name).find()) continue;
                models.add(repositoryModel);
            }
        }
        if (!StringUtils.isEmpty(set)) {
            hasParameter = true;
            List<String> sets = StringUtils.getStringsFromValue(set, ",");
            for (RepositoryModel repositoryModel : availableModels) {
                for (String string : sets) {
                    if (!repositoryModel.federationSets.contains(string)) continue;
                    models.add(repositoryModel);
                }
            }
        }
        if (!StringUtils.isEmpty(team)) {
            hasParameter = true;
            List<String> teams = StringUtils.getStringsFromValue(team, ",");
            ArrayList<TeamModel> arrayList = new ArrayList<TeamModel>();
            for (String name : teams) {
                TeamModel teamModel = this.app().users().getTeamModel(name);
                if (teamModel == null) continue;
                arrayList.add(teamModel);
            }
            for (RepositoryModel repositoryModel : availableModels) {
                for (TeamModel teamModel : arrayList) {
                    if (!teamModel.hasRepositoryPermission(repositoryModel.name)) continue;
                    models.add(repositoryModel);
                }
            }
        }
        if (!hasParameter) {
            models.addAll(availableModels);
        }
        if (daysBack > 0) {
            if (maxDaysBack > 0 && daysBack > maxDaysBack) {
                daysBack = maxDaysBack;
            }
            Calendar cal = Calendar.getInstance();
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            cal.add(5, -1 * daysBack);
            Date date = cal.getTime();
            HashSet<RepositoryModel> hashSet = new HashSet<RepositoryModel>();
            for (RepositoryModel repositoryModel : models) {
                if (!repositoryModel.lastChange.after(date)) continue;
                hashSet.add(repositoryModel);
            }
            models = hashSet;
        }
        ArrayList<RepositoryModel> list = new ArrayList<RepositoryModel>(models);
        Collections.sort(list);
        return list;
    }

    class UserMenu
    extends Fragment {
        private static final long serialVersionUID = 1L;

        public UserMenu(String id, String markupId, MarkupContainer markupProvider) {
            super(id, markupId, markupProvider);
            this.setRenderBodyOnly(true);
        }

        protected void onInitialize() {
            boolean standardLogin;
            super.onInitialize();
            GitBlitWebSession session = GitBlitWebSession.get();
            UserModel user = session.getUser();
            boolean editCredentials = RootPage.this.app().authentication().supportsCredentialChanges(user);
            HttpServletRequest request = ((WebRequest)this.getRequest()).getHttpServletRequest();
            Constants.AuthenticationType authenticationType = (Constants.AuthenticationType)((Object)request.getAttribute("Gitblit:authentication-type"));
            boolean bl = standardLogin = null != authenticationType ? authenticationType.isStandard() : true;
            if (RootPage.this.app().settings().getBoolean("web.allowGravatar", true)) {
                this.add(new Component[]{new AvatarImage("username", user, "navbarGravatar", 20, false)});
            } else {
                this.add(new Component[]{new Label("username", user.getDisplayName())});
            }
            ArrayList<Menu.MenuItem> standardItems = new ArrayList<Menu.MenuItem>();
            standardItems.add(new Menu.MenuDivider());
            if (user.canAdmin() || user.canCreate()) {
                standardItems.add(new Menu.PageLinkMenuItem("gb.newRepository", RootPage.this.app().getNewRepositoryPage()));
            }
            standardItems.add(new Menu.PageLinkMenuItem("gb.myProfile", UserPage.class, WicketUtils.newUsernameParameter(user.username)));
            if (editCredentials) {
                standardItems.add(new Menu.PageLinkMenuItem("gb.changePassword", ChangePasswordPage.class));
            }
            standardItems.add(new Menu.MenuDivider());
            this.add(new Component[]{this.newSubmenu("standardMenu", user.getDisplayName(), standardItems)});
            if (RootPage.this.showAdmin) {
                boolean showRegistrations;
                ArrayList<Menu.MenuItem> adminItems = new ArrayList<Menu.MenuItem>();
                adminItems.add(new Menu.MenuDivider());
                adminItems.add(new Menu.PageLinkMenuItem("gb.users", UsersPage.class));
                adminItems.add(new Menu.PageLinkMenuItem("gb.teams", TeamsPage.class));
                boolean bl2 = showRegistrations = RootPage.this.app().federation().canFederate() && RootPage.this.app().settings().getBoolean("web.showFederationRegistrations", false);
                if (showRegistrations) {
                    adminItems.add(new Menu.PageLinkMenuItem("gb.federation", FederationPage.class));
                }
                adminItems.add(new Menu.MenuDivider());
                this.add(new Component[]{this.newSubmenu("adminMenu", this.getString("gb.administration"), adminItems)});
            } else {
                this.add(new Component[]{new Label("adminMenu").setVisible(false)});
            }
            ArrayList<Menu.MenuItem> extensionItems = new ArrayList<Menu.MenuItem>();
            List<UserMenuExtension> extensions = RootPage.this.app().plugins().getExtensions(UserMenuExtension.class);
            for (UserMenuExtension ext : extensions) {
                List<Menu.MenuItem> items = ext.getMenuItems(user);
                extensionItems.addAll(items);
            }
            if (extensionItems.isEmpty()) {
                this.add(new Component[]{new Label("extensionsMenu").setVisible(false)});
            } else {
                extensionItems.add(0, new Menu.MenuDivider());
                this.add(new Component[]{this.newSubmenu("extensionsMenu", this.getString("gb.extensions"), extensionItems)});
                extensionItems.add(new Menu.MenuDivider());
            }
            this.add(new Component[]{new BookmarkablePageLink("logout", LogoutPage.class).setVisible(standardLogin)});
        }

        private Fragment newSubmenu(String wicketId, String submenuTitle, List<Menu.MenuItem> menuItems) {
            Fragment submenu = new Fragment(wicketId, "submenuFragment", (MarkupContainer)this);
            submenu.add(new Component[]{new Label("submenuTitle", submenuTitle).setRenderBodyOnly(true)});
            ListDataProvider menuItemsDp = new ListDataProvider(menuItems);
            DataView<Menu.MenuItem> submenuItems = new DataView<Menu.MenuItem>("submenuItem", (IDataProvider)menuItemsDp){
                private static final long serialVersionUID = 1L;

                public void populateItem(Item<Menu.MenuItem> menuItem) {
                    Menu.MenuItem item = (Menu.MenuItem)menuItem.getModelObject();
                    String name = item.toString();
                    try {
                        name = this.getString(name);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (item instanceof Menu.PageLinkMenuItem) {
                        Menu.PageLinkMenuItem pageLink = (Menu.PageLinkMenuItem)item;
                        menuItem.add(new Component[]{new LinkPanel("submenuLink", null, null, name, pageLink.getPageClass(), pageLink.getPageParameters(), false).setRenderBodyOnly(true)});
                    } else if (item instanceof Menu.ExternalLinkMenuItem) {
                        Menu.ExternalLinkMenuItem extLink = (Menu.ExternalLinkMenuItem)item;
                        menuItem.add(new Component[]{new LinkPanel("submenuLink", null, name, extLink.getHref(), extLink.openInNewWindow()).setRenderBodyOnly(true)});
                    } else if (item instanceof Menu.MenuDivider) {
                        menuItem.add(new Component[]{new Label("submenuLink").setRenderBodyOnly(true)});
                        WicketUtils.setCssClass(menuItem, "divider");
                    }
                }
            };
            submenu.add(new Component[]{submenuItems});
            submenu.setRenderBodyOnly(true);
            return submenu;
        }
    }

    private class LoginForm
    extends Fragment {
        private static final long serialVersionUID = 1L;

        public LoginForm(String id, String markupId, MarkupContainer markupProvider) {
            super(id, markupId, markupProvider);
            this.setRenderBodyOnly(true);
            SessionlessForm<Void> loginForm = new SessionlessForm<Void>("loginForm", ((Object)((Object)RootPage.this)).getClass(), RootPage.this.getPageParameters()){
                private static final long serialVersionUID = 1L;

                public void onSubmit() {
                    String username = (String)RootPage.this.username.getObject();
                    char[] password = ((String)RootPage.this.password.getObject()).toCharArray();
                    HttpServletRequest request = ((WebRequest)RequestCycle.get().getRequest()).getHttpServletRequest();
                    UserModel user = RootPage.this.app().authentication().authenticate(username, password, request.getRemoteAddr());
                    if (user == null) {
                        this.error((Serializable)((Object)this.getString("gb.invalidUsernameOrPassword")));
                    } else if (user.username.equals("$gitblit")) {
                        this.error((Serializable)((Object)this.getString("gb.invalidUsernameOrPassword")));
                        user = null;
                    } else {
                        RootPage.this.loginUser(user);
                    }
                }
            };
            TextField unameField = new TextField("username", RootPage.this.username);
            WicketUtils.setInputPlaceholder((Component)unameField, markupProvider.getString("gb.username"));
            loginForm.add(new Component[]{unameField});
            NonTrimmedPasswordTextField pwField = new NonTrimmedPasswordTextField("password", RootPage.this.password);
            WicketUtils.setInputPlaceholder((Component)pwField, markupProvider.getString("gb.password"));
            loginForm.add(new Component[]{pwField});
            this.add(new Component[]{loginForm});
        }
    }
}

