/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.Constants;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.UserModel;
import com.gitblit.utils.ModelUtils;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.pages.RootPage;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.Session;
import org.apache.wicket.markup.html.basic.Label;

public abstract class RootSubPage
extends RootPage {
    public RootSubPage() {
        this.createPageMapIfNeeded();
    }

    public RootSubPage(PageParameters params) {
        super(params);
        this.createPageMapIfNeeded();
    }

    protected boolean requiresPageMap() {
        return false;
    }

    protected void createPageMapIfNeeded() {
        if (this.requiresPageMap()) {
            Session.get().pageMapForName(null, true);
            this.setVersioned(true);
        }
    }

    @Override
    protected void setupPage(String pageName, String subName) {
        this.add(new Component[]{new Label("pageName", pageName)});
        if (!StringUtils.isEmpty(subName)) {
            subName = "/ " + subName;
        }
        this.add(new Component[]{new Label("pageSubName", subName)});
        super.setupPage("", pageName);
    }

    protected List<String> getAccessRestrictedRepositoryList(boolean includeWildcards, UserModel user) {
        String lastProject = null;
        ArrayList<String> repos = new ArrayList<String>();
        if (includeWildcards) {
            repos.add(".*");
            if (ModelUtils.getUserRepoPrefix().length() == 1) {
                repos.add("[^" + ModelUtils.getUserRepoPrefix() + "].*");
            }
        }
        for (String repo : this.app().repositories().getRepositoryList()) {
            RepositoryModel repositoryModel = this.app().repositories().getRepositoryModel(repo);
            if (!repositoryModel.accessRestriction.exceeds(Constants.AccessRestrictionType.NONE) || !repositoryModel.authorizationControl.equals((Object)Constants.AuthorizationControl.NAMED) || user != null && (repositoryModel.isOwner(user.username) || repositoryModel.isUsersPersonalRepository(user.username))) continue;
            if (includeWildcards && (lastProject == null || !lastProject.equalsIgnoreCase(repositoryModel.projectPath))) {
                lastProject = repositoryModel.projectPath.toLowerCase();
                if (!StringUtils.isEmpty(repositoryModel.projectPath)) {
                    repos.add(repositoryModel.projectPath + "/.*");
                }
            }
            repos.add(repo.toLowerCase());
        }
        return repos;
    }
}

