/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.Constants;
import com.gitblit.models.UserModel;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.GitBlitWebApp;
import com.gitblit.wicket.GitBlitWebSession;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.wicket.PageParameters;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.protocol.http.WebRequest;
import org.apache.wicket.protocol.http.WebResponse;

public abstract class SessionPage
extends WebPage {
    public SessionPage() {
        this.login();
    }

    public SessionPage(PageParameters params) {
        super(params);
        this.login();
    }

    protected String[] getEncodings() {
        return this.app().settings().getStrings("web.blobEncodings").toArray(new String[0]);
    }

    protected GitBlitWebApp app() {
        return GitBlitWebApp.get();
    }

    private void login() {
        UserModel user;
        GitBlitWebSession session = GitBlitWebSession.get();
        HttpServletRequest request = ((WebRequest)this.getRequest()).getHttpServletRequest();
        HttpServletResponse response = ((WebResponse)this.getResponse()).getHttpServletResponse();
        String authedUser = (String)request.getAttribute("Gitblit:authenticated-user");
        if (StringUtils.isEmpty(authedUser) && session.isLoggedIn()) {
            authedUser = session.getUsername();
        }
        if (!StringUtils.isEmpty(authedUser)) {
            if (!authedUser.equals(session.getUsername())) {
                session.replaceSession();
            }
            if (!session.isSessionInvalidated()) {
                String requestCookie;
                UserModel user2 = this.app().users().getUserModel(authedUser);
                if (user2 == null || user2.disabled) {
                    this.app().authentication().logout(request, response, user2);
                    session.setUser(null);
                    session.invalidateNow();
                    return;
                }
                if (this.app().settings().getBoolean("web.allowCookieAuthentication", true) && !StringUtils.isEmpty(requestCookie = this.app().authentication().getCookie(request)) && !StringUtils.isEmpty(user2.cookie) && !requestCookie.equals(user2.cookie)) {
                    this.app().authentication().logout(request, response, user2);
                    session.setUser(null);
                    session.invalidateNow();
                    return;
                }
                session.setUser(user2);
                session.continueRequest();
                return;
            }
        }
        if ((user = this.app().authentication().authenticate(request)) != null) {
            Constants.AuthenticationType authenticationType = (Constants.AuthenticationType)((Object)request.getAttribute("Gitblit:authentication-type"));
            if (Constants.AuthenticationType.CONTAINER != authenticationType) {
                session.replaceSession();
            }
            session.setUser(user);
            this.app().authentication().setCookie(request, response, user);
            session.continueRequest();
        }
    }
}

