/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.models.Metric;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.UserModel;
import com.gitblit.utils.JGitUtils;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.CacheControl;
import com.gitblit.wicket.GitBlitWebSession;
import com.gitblit.wicket.MarkupProcessor;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.charting.Chart;
import com.gitblit.wicket.charting.Charts;
import com.gitblit.wicket.charting.Flotr2Charts;
import com.gitblit.wicket.pages.MetricsPage;
import com.gitblit.wicket.pages.RepositoryPage;
import com.gitblit.wicket.pages.UserPage;
import com.gitblit.wicket.panels.BranchesPanel;
import com.gitblit.wicket.panels.LinkPanel;
import com.gitblit.wicket.panels.LogPanel;
import com.gitblit.wicket.panels.RepositoryUrlPanel;
import com.gitblit.wicket.panels.TagsPanel;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.PageParameters;
import org.apache.wicket.behavior.HeaderContributor;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.markup.repeater.data.ListDataProvider;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;

@CacheControl(value=CacheControl.LastModified.REPOSITORY)
public class SummaryPage
extends RepositoryPage {
    public SummaryPage(PageParameters params) {
        super(params);
        int numberCommits = this.app().settings().getInteger("web.summaryCommitCount", 20);
        if (numberCommits <= 0) {
            numberCommits = 20;
        }
        int numberRefs = this.app().settings().getInteger("web.summaryRefsCount", 5);
        Repository r = this.getRepository();
        RepositoryModel model = this.getRepositoryModel();
        UserModel user = GitBlitWebSession.get().getUser();
        if (user == null) {
            user = UserModel.ANONYMOUS;
        }
        List<Metric> metrics = null;
        Metric metricsTotal = null;
        if (!model.skipSummaryMetrics && this.app().settings().getBoolean("web.generateActivityGraph", true)) {
            metrics = this.app().repositories().getRepositoryDefaultMetrics(model, r);
            metricsTotal = metrics.remove(0);
        }
        this.addSyndicationDiscoveryLink();
        this.add(new Component[]{new Label("repositoryDescription", this.getRepositoryModel().description)});
        final ArrayList<String> owners = new ArrayList<String>(this.getRepositoryModel().owners);
        ListDataProvider ownersDp = new ListDataProvider(owners);
        DataView<String> ownersView = new DataView<String>("repositoryOwners", (IDataProvider)ownersDp){
            private static final long serialVersionUID = 1L;
            int counter;
            {
                super(x0, x1);
                this.counter = 0;
            }

            public void populateItem(Item<String> item) {
                String ownername = (String)item.getModelObject();
                UserModel ownerModel = SummaryPage.this.app().users().getUserModel(ownername);
                if (ownerModel != null) {
                    item.add(new Component[]{new LinkPanel("owner", null, ownerModel.getDisplayName(), UserPage.class, WicketUtils.newUsernameParameter(ownerModel.username)).setRenderBodyOnly(true)});
                } else {
                    Label owner = new Label("owner", ownername);
                    WicketUtils.setCssStyle((Component)owner, "text-decoration: line-through;");
                    WicketUtils.setHtmlTooltip((Component)owner, MessageFormat.format(this.getString("gb.failedToFindAccount"), ownername));
                    item.add(new Component[]{owner});
                }
                ++this.counter;
                item.add(new Component[]{new Label("comma", ",").setVisible(this.counter < owners.size())});
                item.setRenderBodyOnly(true);
            }
        };
        ownersView.setRenderBodyOnly(true);
        this.add(new Component[]{ownersView});
        this.add(new Component[]{WicketUtils.createTimestampLabel("repositoryLastChange", JGitUtils.getLastChange((Repository)r).when, this.getTimeZone(), this.getTimeUtils())});
        this.add(new Component[]{new Label("repositorySize", this.getRepositoryModel().size)});
        if (metricsTotal == null) {
            this.add(new Component[]{new Label("branchStats", "")});
        } else {
            this.add(new Component[]{new Label("branchStats", MessageFormat.format(this.getString("gb.branchStats"), metricsTotal.count, metricsTotal.tag, this.getTimeUtils().duration(metricsTotal.duration)))});
        }
        this.add(new Component[]{new BookmarkablePageLink("metrics", MetricsPage.class, WicketUtils.newRepositoryParameter(this.repositoryName))});
        this.add(new Component[]{new RepositoryUrlPanel("repositoryUrlPanel", false, user, model)});
        this.add(new Component[]{new LogPanel("commitsPanel", this.repositoryName, this.getRepositoryModel().HEAD, r, numberCommits, 0, this.getRepositoryModel().showRemoteBranches)});
        this.add(new Component[]{new TagsPanel("tagsPanel", this.repositoryName, r, numberRefs).hideIfEmpty()});
        this.add(new Component[]{new BranchesPanel("branchesPanel", this.getRepositoryModel(), r, numberRefs, false).hideIfEmpty()});
        if (this.app().settings().getBoolean("web.summaryShowReadme", false)) {
            MarkupProcessor.MarkupDocument markupDoc = null;
            RevCommit head = JGitUtils.getCommit(r, null);
            if (head != null) {
                MarkupProcessor processor = new MarkupProcessor(this.app().settings(), this.app().xssFilter());
                markupDoc = processor.getReadme(r, this.repositoryName, this.getBestCommitId(head));
            }
            if (markupDoc == null || markupDoc.markup == null) {
                this.add(new Component[]{new Label("readme").setVisible(false)});
            } else {
                Fragment fragment = new Fragment("readme", MarkupProcessor.MarkupSyntax.PLAIN.equals((Object)markupDoc.syntax) ? "plaintextPanel" : "markdownPanel", (MarkupContainer)this);
                fragment.add(new Component[]{new Label("readmeFile", markupDoc.documentPath)});
                Component content = new Label("readmeContent", markupDoc.html).setEscapeModelStrings(false);
                fragment.add(new Component[]{content.setVisible(!StringUtils.isEmpty(markupDoc.html))});
                this.add(new Component[]{fragment});
            }
        } else {
            this.add(new Component[]{new Label("readme").setVisible(false)});
        }
        if (metrics == null || metrics.isEmpty()) {
            this.add(new Component[]{new Label("commitsChart").setVisible(false)});
        } else {
            Charts charts = this.createCharts(metrics);
            this.add(new IBehavior[]{new HeaderContributor((IHeaderContributor)charts)});
        }
    }

    @Override
    protected String getPageName() {
        return this.getString("gb.summary");
    }

    private Charts createCharts(List<Metric> metrics) {
        Flotr2Charts charts = new Flotr2Charts();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String displayFormat = "MMM dd";
        if (metrics.size() > 0 && metrics.get((int)0).name.length() == 7) {
            df = new SimpleDateFormat("yyyy-MM");
            displayFormat = "yyyy MMM";
        }
        df.setTimeZone(this.getTimeZone());
        Chart chart = ((Charts)charts).createLineChart("commitsChart", this.getString("gb.activity"), "day", this.getString("gb.commits"));
        chart.setDateFormat(displayFormat);
        for (Metric metric : metrics) {
            Date date;
            try {
                date = df.parse(metric.name);
            }
            catch (ParseException e) {
                this.logger().error("Unable to parse date: " + metric.name);
                return charts;
            }
            chart.addValue(date, (int)metric.count);
            if (!(metric.tag > 0.0)) continue;
            chart.addHighlight(date, (int)metric.count);
        }
        charts.addChart(chart);
        return charts;
    }
}

