/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.models.PathModel;
import com.gitblit.models.SubmoduleModel;
import com.gitblit.models.UserModel;
import com.gitblit.servlet.RawServlet;
import com.gitblit.utils.ByteFormat;
import com.gitblit.utils.JGitUtils;
import com.gitblit.wicket.CacheControl;
import com.gitblit.wicket.GitBlitWebSession;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.BlamePage;
import com.gitblit.wicket.pages.BlobPage;
import com.gitblit.wicket.pages.HistoryPage;
import com.gitblit.wicket.pages.RepositoryPage;
import com.gitblit.wicket.pages.SummaryPage;
import com.gitblit.wicket.panels.CommitHeaderPanel;
import com.gitblit.wicket.panels.CompressedDownloadsPanel;
import com.gitblit.wicket.panels.LinkPanel;
import com.gitblit.wicket.panels.PathBreadcrumbsPanel;
import java.io.OutputStream;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.IRequestTarget;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.PageParameters;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.link.ExternalLink;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.markup.repeater.data.ListDataProvider;
import org.apache.wicket.request.target.resource.ResourceStreamRequestTarget;
import org.apache.wicket.util.resource.AbstractResourceStreamWriter;
import org.apache.wicket.util.resource.IResourceStream;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;

@CacheControl(value=CacheControl.LastModified.BOOT)
public class TreePage
extends RepositoryPage {
    public TreePage(PageParameters params) {
        super(params);
        String path = WicketUtils.getPath(params);
        Repository r = this.getRepository();
        RevCommit commit = this.getCommit();
        List<PathModel> paths = JGitUtils.getFilesInPath2(r, path, commit);
        this.add(new Component[]{new BookmarkablePageLink("historyLink", HistoryPage.class, WicketUtils.newPathParameter(this.repositoryName, this.objectId, path))});
        this.add(new Component[]{new CompressedDownloadsPanel("compressedLinks", this.getRequest().getRelativePathPrefixToContextRoot(), this.repositoryName, this.objectId, path)});
        this.add(new Component[]{new CommitHeaderPanel("commitHeader", this.repositoryName, commit)});
        this.add(new Component[]{new PathBreadcrumbsPanel("breadcrumbs", this.repositoryName, path, this.objectId)});
        if (path != null && path.trim().length() > 0) {
            String parentPath = null;
            if (path.lastIndexOf(47) > -1) {
                parentPath = path.substring(0, path.lastIndexOf(47));
            }
            PathModel model = new PathModel("..", parentPath, null, 0L, FileMode.TREE.getBits(), null, this.objectId);
            model.isParentPath = true;
            paths.add(0, model);
        }
        final String id = this.getBestCommitId(commit);
        final ByteFormat byteFormat = new ByteFormat();
        final String baseUrl = WicketUtils.getGitblitURL(this.getRequest());
        ListDataProvider pathsDp = new ListDataProvider(paths);
        DataView<PathModel> pathsView = new DataView<PathModel>("changedPath", (IDataProvider)pathsDp){
            private static final long serialVersionUID = 1L;
            int counter;

            public void populateItem(Item<PathModel> item) {
                final PathModel entry = (PathModel)item.getModelObject();
                item.add(new Component[]{new Label("pathPermissions", JGitUtils.getPermissionsFromMode(entry.mode))});
                item.add(new Component[]{WicketUtils.setHtmlTooltip((Component)new Label("filestore", ""), this.getString("gb.filestore")).setVisible(entry.isFilestoreItem())});
                if (entry.isParentPath) {
                    item.add(new Component[]{WicketUtils.newBlankImage("pathIcon")});
                    item.add(new Component[]{new Label("pathSize", "")});
                    item.add(new Component[]{new LinkPanel("pathName", null, entry.name, TreePage.class, WicketUtils.newPathParameter(TreePage.this.repositoryName, id, entry.path))});
                    item.add(new Component[]{new Label("pathLinks", "")});
                } else if (entry.isTree()) {
                    item.add(new Component[]{WicketUtils.newImage("pathIcon", "folder_16x16.png")});
                    item.add(new Component[]{new Label("pathSize", "")});
                    item.add(new Component[]{new LinkPanel("pathName", "list", entry.name, TreePage.class, WicketUtils.newPathParameter(TreePage.this.repositoryName, id, entry.path))});
                    Fragment links = new Fragment("pathLinks", "treeLinks", (MarkupContainer)this);
                    links.add(new Component[]{new BookmarkablePageLink("tree", TreePage.class, WicketUtils.newPathParameter(TreePage.this.repositoryName, id, entry.path))});
                    links.add(new Component[]{new BookmarkablePageLink("history", HistoryPage.class, WicketUtils.newPathParameter(TreePage.this.repositoryName, id, entry.path))});
                    links.add(new Component[]{new CompressedDownloadsPanel("compressedLinks", baseUrl, TreePage.this.repositoryName, TreePage.this.objectId, entry.path)});
                    item.add(new Component[]{links});
                } else if (entry.isSubmodule()) {
                    String submoduleId = entry.objectId;
                    boolean hasSubmodule = false;
                    SubmoduleModel submodule = TreePage.this.getSubmodule(entry.path);
                    String submodulePath = submodule.gitblitPath;
                    hasSubmodule = submodule.hasSubmodule;
                    item.add(new Component[]{WicketUtils.newImage("pathIcon", "git-orange-16x16.png")});
                    item.add(new Component[]{new Label("pathSize", "")});
                    item.add(new Component[]{new LinkPanel("pathName", "list", entry.name + " @ " + TreePage.this.getShortObjectId(submoduleId), TreePage.class, WicketUtils.newPathParameter(submodulePath, submoduleId, "")).setEnabled(hasSubmodule)});
                    Fragment links = new Fragment("pathLinks", "submoduleLinks", (MarkupContainer)this);
                    links.add(new Component[]{new BookmarkablePageLink("view", SummaryPage.class, WicketUtils.newRepositoryParameter(submodulePath)).setEnabled(hasSubmodule)});
                    links.add(new Component[]{new BookmarkablePageLink("tree", TreePage.class, WicketUtils.newPathParameter(submodulePath, submoduleId, "")).setEnabled(hasSubmodule)});
                    links.add(new Component[]{new BookmarkablePageLink("history", HistoryPage.class, WicketUtils.newPathParameter(TreePage.this.repositoryName, id, entry.path))});
                    links.add(new Component[]{new CompressedDownloadsPanel("compressedLinks", baseUrl, submodulePath, submoduleId, "").setEnabled(hasSubmodule)});
                    item.add(new Component[]{links});
                } else {
                    String displayPath = entry.name;
                    String path = entry.path;
                    if (entry.isSymlink()) {
                        path = JGitUtils.getStringContent(TreePage.this.getRepository(), TreePage.this.getCommit().getTree(), path, new String[0]);
                        displayPath = entry.name + " -> " + path;
                    }
                    item.add(new Component[]{WicketUtils.getFileImage("pathIcon", entry.name)});
                    item.add(new Component[]{new Label("pathSize", byteFormat.format(entry.size))});
                    Fragment links = new Fragment("pathLinks", "blobLinks", (MarkupContainer)this);
                    if (entry.isFilestoreItem()) {
                        item.add(new Component[]{new LinkPanel("pathName", "list", displayPath, new Link<Object>("link", null){
                            private static final long serialVersionUID = 1L;

                            public void onClick() {
                                AbstractResourceStreamWriter resourceStream = new AbstractResourceStreamWriter(){
                                    private static final long serialVersionUID = 1L;

                                    public void write(OutputStream output) {
                                        UserModel user = GitBlitWebSession.get().getUser();
                                        user = user == null ? UserModel.ANONYMOUS : user;
                                        TreePage.this.app().filestore().downloadBlob(entry.getFilestoreOid(), user, TreePage.this.getRepositoryModel(), output);
                                    }
                                };
                                this.getRequestCycle().setRequestTarget((IRequestTarget)new ResourceStreamRequestTarget((IResourceStream)resourceStream, entry.path));
                            }
                        })});
                        links.add(new Component[]{new Link<Object>("view", null){
                            private static final long serialVersionUID = 1L;

                            public void onClick() {
                                AbstractResourceStreamWriter resourceStream = new AbstractResourceStreamWriter(){
                                    private static final long serialVersionUID = 1L;

                                    public void write(OutputStream output) {
                                        UserModel user = GitBlitWebSession.get().getUser();
                                        user = user == null ? UserModel.ANONYMOUS : user;
                                        TreePage.this.app().filestore().downloadBlob(entry.getFilestoreOid(), user, TreePage.this.getRepositoryModel(), output);
                                    }
                                };
                                this.getRequestCycle().setRequestTarget((IRequestTarget)new ResourceStreamRequestTarget((IResourceStream)resourceStream, entry.path));
                            }
                        }});
                        links.add(new Component[]{new Link<Object>("raw", null){
                            private static final long serialVersionUID = 1L;

                            public void onClick() {
                                AbstractResourceStreamWriter resourceStream = new AbstractResourceStreamWriter(){
                                    private static final long serialVersionUID = 1L;

                                    public void write(OutputStream output) {
                                        UserModel user = GitBlitWebSession.get().getUser();
                                        user = user == null ? UserModel.ANONYMOUS : user;
                                        TreePage.this.app().filestore().downloadBlob(entry.getFilestoreOid(), user, TreePage.this.getRepositoryModel(), output);
                                    }
                                };
                                this.getRequestCycle().setRequestTarget((IRequestTarget)new ResourceStreamRequestTarget((IResourceStream)resourceStream, entry.path));
                            }
                        }});
                    } else {
                        item.add(new Component[]{new LinkPanel("pathName", "list", displayPath, BlobPage.class, WicketUtils.newPathParameter(TreePage.this.repositoryName, id, path))});
                        links.add(new Component[]{new BookmarkablePageLink("view", BlobPage.class, WicketUtils.newPathParameter(TreePage.this.repositoryName, id, path))});
                        String rawUrl = RawServlet.asLink(TreePage.this.getContextUrl(), TreePage.this.repositoryName, id, path);
                        links.add(new Component[]{new ExternalLink("raw", rawUrl)});
                    }
                    links.add(new Component[]{new BookmarkablePageLink("blame", BlamePage.class, WicketUtils.newPathParameter(TreePage.this.repositoryName, id, path))});
                    links.add(new Component[]{new BookmarkablePageLink("history", HistoryPage.class, WicketUtils.newPathParameter(TreePage.this.repositoryName, id, path))});
                    item.add(new Component[]{links});
                }
                WicketUtils.setAlternatingBackground(item, this.counter);
                ++this.counter;
            }
        };
        this.add(new Component[]{pathsView});
    }

    @Override
    protected String getPageName() {
        return this.getString("gb.tree");
    }

    @Override
    protected boolean isCommitPage() {
        return true;
    }
}

