/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.Constants;
import com.gitblit.GitBlitException;
import com.gitblit.models.Menu;
import com.gitblit.models.NavLink;
import com.gitblit.models.ProjectModel;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.UserModel;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.GitBlitWebApp;
import com.gitblit.wicket.GitBlitWebSession;
import com.gitblit.wicket.GitblitRedirectException;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.Language;
import com.gitblit.wicket.pages.RootPage;
import com.gitblit.wicket.panels.BooleanOption;
import com.gitblit.wicket.panels.ChoiceOption;
import com.gitblit.wicket.panels.ProjectRepositoryPanel;
import com.gitblit.wicket.panels.SshKeysPanel;
import com.gitblit.wicket.panels.TextOption;
import com.gitblit.wicket.panels.UserTitlePanel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.PageParameters;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.markup.repeater.data.ListDataProvider;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class UserPage
extends RootPage {
    List<ProjectModel> projectModels = new ArrayList<ProjectModel>();

    public UserPage() {
        throw new GitblitRedirectException(GitBlitWebApp.get().getHomePage());
    }

    public UserPage(PageParameters params) {
        super(params);
        this.setup(params);
    }

    @Override
    protected boolean reusePageParameters() {
        return true;
    }

    private void setup(PageParameters params) {
        boolean isMyProfile;
        this.setupPage("", "");
        boolean authenticateView = this.app().settings().getBoolean("web.authenticateViewPages", true);
        if (authenticateView && !GitBlitWebSession.get().isLoggedIn()) {
            this.authenticationError("Please login");
            return;
        }
        String userName = WicketUtils.getUsername(params);
        if (StringUtils.isEmpty(userName)) {
            throw new GitblitRedirectException(GitBlitWebApp.get().getHomePage());
        }
        UserModel user = this.app().users().getUserModel(userName);
        if (user == null) {
            user = new UserModel(userName);
        }
        this.add(new Component[]{new UserTitlePanel("userTitlePanel", user, user.username)});
        UserModel sessionUser = GitBlitWebSession.get().getUser();
        boolean bl = isMyProfile = sessionUser != null && sessionUser.equals(user);
        if (isMyProfile) {
            this.addPreferences(user);
            if (this.app().services().isServingSSH()) {
                this.addSshKeys(user);
            } else {
                this.add(new Component[]{new Label("sshKeysLink").setVisible(false)});
                this.add(new Component[]{new Label("sshKeysTab").setVisible(false)});
            }
        } else {
            this.add(new Component[]{new Label("preferencesLink").setVisible(false)});
            this.add(new Component[]{new Label("preferencesTab").setVisible(false)});
            this.add(new Component[]{new Label("sshKeysLink").setVisible(false)});
            this.add(new Component[]{new Label("sshKeysTab").setVisible(false)});
        }
        List<RepositoryModel> repositories = this.getRepositories(params);
        Collections.sort(repositories, new Comparator<RepositoryModel>(){

            @Override
            public int compare(RepositoryModel o1, RepositoryModel o2) {
                return o2.lastChange.compareTo(o1.lastChange);
            }
        });
        ListDataProvider dp = new ListDataProvider(repositories);
        DataView<RepositoryModel> dataView = new DataView<RepositoryModel>("repositoryList", (IDataProvider)dp){
            private static final long serialVersionUID = 1L;

            public void populateItem(Item<RepositoryModel> item) {
                RepositoryModel entry = (RepositoryModel)item.getModelObject();
                ProjectRepositoryPanel row = new ProjectRepositoryPanel("repository", this.getLocalizer(), (Component)this, UserPage.this.showAdmin, entry, UserPage.this.getAccessRestrictions());
                item.add(new Component[]{row});
            }
        };
        this.add(new Component[]{dataView});
    }

    @Override
    protected void addDropDownMenus(List<NavLink> navLinks) {
        PageParameters params = this.getPageParameters();
        NavLink.DropDownPageMenuNavLink menu = new NavLink.DropDownPageMenuNavLink("gb.filters", UserPage.class);
        menu.menuItems.addAll(this.getRepositoryFilterItems(params));
        menu.menuItems.addAll(this.getTimeFilterItems(params));
        if (menu.menuItems.size() > 0) {
            menu.menuItems.add(new Menu.ParameterMenuItem(this.getString("gb.reset")));
        }
        navLinks.add(menu);
    }

    static List<Language> getLanguages() {
        return Arrays.asList(new Language("\u010cesky", "cs"), new Language("Deutsch", "de"), new Language("English", "en"), new Language("Espa\u00f1ol", "es"), new Language("Fran\u00e7ais", "fr"), new Language("Italiano", "it"), new Language("\u65e5\u672c\u8a9e", "ja"), new Language("\ud55c\uad6d\ub9d0", "ko"), new Language("Nederlands", "nl"), new Language("Norsk", "no"), new Language("J\u0119zyk Polski", "pl"), new Language("Portugu\u00eas", "pt_BR"), new Language("\u0420\u0443\u0441\u0441\u043a\u0438\u0439", "ru"), new Language("\u7c21\u9ad4\u4e2d\u6587", "zh_CN"), new Language("\u6b63\u9ad4\u4e2d\u6587", "zh_TW"));
    }

    static Language getPreferredLanguage(Locale locale, List<Language> languages) {
        Language preferredLanguage = null;
        if (locale != null) {
            String localeCode = locale.getLanguage();
            if (!StringUtils.isEmpty(locale.getCountry())) {
                localeCode = localeCode + "_" + locale.getCountry();
            }
            for (Language language : languages) {
                if (language.code.equals(localeCode)) {
                    preferredLanguage = language;
                    continue;
                }
                if (preferredLanguage != null || !language.code.startsWith(locale.getLanguage())) continue;
                preferredLanguage = language;
            }
        }
        return preferredLanguage;
    }

    private void addPreferences(UserModel user) {
        Locale sessionLocale;
        String lc;
        Form prefs = new Form("prefsForm");
        Locale locale = user.getPreferences().getLocale();
        if (locale == null && StringUtils.isEmpty(lc = this.app().settings().getString("web.forceDefaultLocale", null)) && (sessionLocale = GitBlitWebSession.get().getLocale()) != null) {
            locale = sessionLocale;
        }
        List<Language> languages = UserPage.getLanguages();
        Language preferredLanguage = UserPage.getPreferredLanguage(locale, languages);
        Model displayName = Model.of((Serializable)((Object)user.getDisplayName()));
        Model emailAddress = Model.of((Serializable)((Object)(user.emailAddress == null ? "" : user.emailAddress)));
        Model language = Model.of((Serializable)preferredLanguage);
        Model emailMeOnMyTicketChanges = Model.of((Serializable)Boolean.valueOf(user.getPreferences().isEmailMeOnMyTicketChanges()));
        Model transport = Model.of((Serializable)((Object)user.getPreferences().getTransport()));
        prefs.add(new Component[]{new TextOption("displayName", this.getString("gb.displayName"), this.getString("gb.displayNameDescription"), (IModel<String>)displayName).setVisible(this.app().authentication().supportsDisplayNameChanges(user))});
        prefs.add(new Component[]{new TextOption("emailAddress", this.getString("gb.emailAddress"), this.getString("gb.emailAddressDescription"), (IModel<String>)emailAddress).setVisible(this.app().authentication().supportsEmailAddressChanges(user))});
        prefs.add(new Component[]{new ChoiceOption<Language>("language", this.getString("gb.languagePreference"), this.getString("gb.languagePreferenceDescription"), (IModel<Language>)language, languages)});
        prefs.add(new Component[]{new BooleanOption("emailMeOnMyTicketChanges", this.getString("gb.emailMeOnMyTicketChanges"), this.getString("gb.emailMeOnMyTicketChangesDescription"), (IModel<Boolean>)emailMeOnMyTicketChanges).setVisible(this.app().notifier().isSendingMail())});
        ArrayList<Constants.Transport> availableTransports = new ArrayList<Constants.Transport>();
        if (this.app().services().isServingSSH()) {
            availableTransports.add(Constants.Transport.SSH);
        }
        if (this.app().services().isServingHTTP()) {
            availableTransports.add(Constants.Transport.HTTP);
        }
        if (this.app().services().isServingHTTPS()) {
            availableTransports.add(Constants.Transport.HTTPS);
        }
        if (this.app().services().isServingGIT()) {
            availableTransports.add(Constants.Transport.GIT);
        }
        prefs.add(new Component[]{new ChoiceOption("transport", this.getString("gb.transportPreference"), this.getString("gb.transportPreferenceDescription"), transport, availableTransports)});
        prefs.add(new Component[]{new AjaxButton("save", (IModel)displayName, (IModel)emailAddress, (IModel)language, (IModel)emailMeOnMyTicketChanges, (IModel)transport){
            private static final long serialVersionUID = 1L;
            final /* synthetic */ IModel val$displayName;
            final /* synthetic */ IModel val$emailAddress;
            final /* synthetic */ IModel val$language;
            final /* synthetic */ IModel val$emailMeOnMyTicketChanges;
            final /* synthetic */ IModel val$transport;
            {
                this.val$displayName = iModel;
                this.val$emailAddress = iModel2;
                this.val$language = iModel3;
                this.val$emailMeOnMyTicketChanges = iModel4;
                this.val$transport = iModel5;
                super(x0);
            }

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                UserModel user = GitBlitWebSession.get().getUser();
                user.displayName = (String)this.val$displayName.getObject();
                user.emailAddress = (String)this.val$emailAddress.getObject();
                Language lang = (Language)this.val$language.getObject();
                if (lang != null) {
                    user.getPreferences().setLocale(lang.code);
                }
                user.getPreferences().setEmailMeOnMyTicketChanges((Boolean)this.val$emailMeOnMyTicketChanges.getObject());
                user.getPreferences().setTransport((Constants.Transport)((Object)this.val$transport.getObject()));
                try {
                    UserPage.this.app().gitblit().reviseUser(user.username, user);
                    this.setRedirect(true);
                    this.setResponsePage(UserPage.class, WicketUtils.newUsernameParameter(user.username));
                }
                catch (GitBlitException gitBlitException) {
                    // empty catch block
                }
            }
        }});
        this.add(new Component[]{new Fragment("preferencesLink", "preferencesLinkFragment", (MarkupContainer)this).setRenderBodyOnly(true)});
        Fragment fragment = new Fragment("preferencesTab", "preferencesTabFragment", (MarkupContainer)this);
        fragment.add(new Component[]{prefs});
        this.add(new Component[]{fragment.setRenderBodyOnly(true)});
    }

    private void addSshKeys(UserModel user) {
        Fragment keysTab = new Fragment("sshKeysTab", "sshKeysTabFragment", (MarkupContainer)this);
        keysTab.add(new Component[]{new SshKeysPanel("sshKeysPanel", user)});
        this.add(new Component[]{new Fragment("sshKeysLink", "sshKeysLinkFragment", (MarkupContainer)this).setRenderBodyOnly(true)});
        this.add(new Component[]{keysTab.setRenderBodyOnly(true)});
    }
}

