/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.panels;

import com.gitblit.Constants;
import com.gitblit.models.RepositoryModel;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.panels.BasePanel;
import com.gitblit.wicket.panels.BooleanOption;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.form.AjaxFormChoiceComponentUpdatingBehavior;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Radio;
import org.apache.wicket.markup.html.form.RadioGroup;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;

public class AccessPolicyPanel
extends BasePanel {
    private static final long serialVersionUID = 1L;
    private final RepositoryModel repository;
    private final AjaxFormChoiceComponentUpdatingBehavior callback;
    private RadioGroup<AccessPolicy> policiesGroup;

    public AccessPolicyPanel(String wicketId, RepositoryModel repository) {
        this(wicketId, repository, null);
    }

    public AccessPolicyPanel(String wicketId, RepositoryModel repository, AjaxFormChoiceComponentUpdatingBehavior callback) {
        super(wicketId);
        this.repository = repository;
        this.callback = callback;
    }

    protected void onInitialize() {
        Constants.AuthorizationControl defaultControl;
        super.onInitialize();
        AccessPolicy anonymousPolicy = new AccessPolicy(this.getString("gb.anonymousPolicy"), this.getString("gb.anonymousPolicyDescription"), "blank.png", Constants.AuthorizationControl.AUTHENTICATED, Constants.AccessRestrictionType.NONE);
        AccessPolicy authenticatedPushPolicy = new AccessPolicy(this.getString("gb.authenticatedPushPolicy"), this.getString("gb.authenticatedPushPolicyDescription"), "lock_go_16x16.png", Constants.AuthorizationControl.AUTHENTICATED, Constants.AccessRestrictionType.PUSH);
        AccessPolicy namedPushPolicy = new AccessPolicy(this.getString("gb.namedPushPolicy"), this.getString("gb.namedPushPolicyDescription"), "lock_go_16x16.png", Constants.AuthorizationControl.NAMED, Constants.AccessRestrictionType.PUSH);
        AccessPolicy clonePolicy = new AccessPolicy(this.getString("gb.clonePolicy"), this.getString("gb.clonePolicyDescription"), "lock_pull_16x16.png", Constants.AuthorizationControl.NAMED, Constants.AccessRestrictionType.CLONE);
        AccessPolicy viewPolicy = new AccessPolicy(this.getString("gb.viewPolicy"), this.getString("gb.viewPolicyDescription"), "shield_16x16.png", Constants.AuthorizationControl.NAMED, Constants.AccessRestrictionType.VIEW);
        ArrayList<AccessPolicy> policies = new ArrayList<AccessPolicy>();
        if (this.app().settings().getBoolean("git.allowAnonymousPushes", false)) {
            policies.add(anonymousPolicy);
        }
        policies.add(authenticatedPushPolicy);
        policies.add(namedPushPolicy);
        policies.add(clonePolicy);
        policies.add(viewPolicy);
        Constants.AccessRestrictionType defaultRestriction = this.repository.accessRestriction;
        if (defaultRestriction == null) {
            defaultRestriction = Constants.AccessRestrictionType.fromName(this.app().settings().getString("git.defaultAccessRestriction", Constants.AccessRestrictionType.PUSH.name()));
        }
        if ((defaultControl = this.repository.authorizationControl) == null) {
            defaultControl = Constants.AuthorizationControl.fromName(this.app().settings().getString("git.defaultAuthorizationControl", Constants.AuthorizationControl.NAMED.name()));
        }
        AccessPolicy defaultPolicy = namedPushPolicy;
        for (AccessPolicy policy : policies) {
            if (policy.type != defaultRestriction || policy.control != defaultControl) continue;
            defaultPolicy = policy;
        }
        this.policiesGroup = new RadioGroup("policiesGroup", (IModel)new Model((Serializable)defaultPolicy));
        ListView<AccessPolicy> policiesList = new ListView<AccessPolicy>("policies", policies){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<AccessPolicy> item) {
                AccessPolicy p = (AccessPolicy)item.getModelObject();
                item.add(new Component[]{new Radio("radio", item.getModel())});
                item.add(new Component[]{WicketUtils.newImage("image", p.image)});
                item.add(new Component[]{new Label("name", p.name)});
                item.add(new Component[]{new Label("description", p.description)});
            }
        };
        this.policiesGroup.add(new Component[]{policiesList});
        if (this.callback != null) {
            this.policiesGroup.add(new IBehavior[]{this.callback});
            this.policiesGroup.setOutputMarkupId(true);
        }
        this.add(new Component[]{this.policiesGroup});
        if (this.app().settings().getBoolean("web.allowForking", true)) {
            Fragment fragment = new Fragment("allowForks", "allowForksFragment", (MarkupContainer)this);
            fragment.add(new Component[]{new BooleanOption("allowForks", this.getString("gb.allowForks"), this.getString("gb.allowForksDescription"), (IModel<Boolean>)new PropertyModel((Object)this.repository, "allowForks"))});
            this.add(new Component[]{fragment});
        } else {
            this.add(new Component[]{new Label("allowForks").setVisible(false)});
        }
        this.setOutputMarkupId(true);
    }

    public void updateModel(RepositoryModel repository) {
        AccessPolicy policy = (AccessPolicy)this.policiesGroup.getModelObject();
        repository.authorizationControl = policy.control;
        repository.accessRestriction = policy.type;
    }

    protected boolean getStatelessHint() {
        return false;
    }

    public static class AccessPolicy
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final String name;
        final String description;
        final String image;
        final Constants.AuthorizationControl control;
        final Constants.AccessRestrictionType type;

        AccessPolicy(String name, String description, String img, Constants.AuthorizationControl control, Constants.AccessRestrictionType type) {
            this.name = name;
            this.description = description;
            this.image = img;
            this.control = control;
            this.type = type;
        }

        public String toString() {
            return this.name;
        }
    }
}

