/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.panels;

import com.gitblit.AvatarGenerator;
import com.gitblit.models.UserModel;
import com.gitblit.wicket.ExternalImage;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.panels.BasePanel;
import org.apache.wicket.Component;
import org.eclipse.jgit.lib.PersonIdent;

public class AvatarImage
extends BasePanel {
    private static final long serialVersionUID = 1L;

    public AvatarImage(String id, PersonIdent person) {
        this(id, person, 0);
    }

    public AvatarImage(String id, PersonIdent person, int width) {
        this(id, person.getName(), person.getEmailAddress(), "gravatar", width, true);
    }

    public AvatarImage(String id, PersonIdent person, String cssClass, int width, boolean identicon) {
        this(id, person.getName(), person.getEmailAddress(), cssClass, width, identicon);
    }

    public AvatarImage(String id, UserModel user, String cssClass, int width, boolean identicon) {
        this(id, user.getDisplayName(), user.emailAddress, cssClass, width, identicon);
    }

    public AvatarImage(String id, String username, String emailaddress, String cssClass, int width, boolean identicon) {
        super(id);
        AvatarGenerator avatarGenerator = (AvatarGenerator)this.app().runtime().getInjector().getInstance(AvatarGenerator.class);
        String url = avatarGenerator.getURL(username, emailaddress, identicon, width);
        ExternalImage image = new ExternalImage("image", url);
        if (cssClass != null) {
            WicketUtils.setCssClass((Component)image, cssClass);
        }
        this.add(new Component[]{image});
        WicketUtils.setHtmlTooltip((Component)image, username);
        this.setVisible(this.app().settings().getBoolean("web.allowGravatar", true));
    }

    public void setTooltip(String tooltip) {
        WicketUtils.setHtmlTooltip(this.get("image"), tooltip);
    }
}

