/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.panels;

import com.gitblit.Constants;
import com.gitblit.utils.TimeUtils;
import com.gitblit.wicket.GitBlitWebApp;
import com.gitblit.wicket.GitBlitWebSession;
import com.gitblit.wicket.WicketUtils;
import java.io.Serializable;
import java.util.ResourceBundle;
import java.util.TimeZone;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasePanel
extends Panel {
    private static final long serialVersionUID = 1L;
    private transient TimeUtils timeUtils;
    private transient Logger logger;

    public BasePanel(String wicketId) {
        super(wicketId);
    }

    protected GitBlitWebApp app() {
        return GitBlitWebApp.get();
    }

    protected Logger logger() {
        if (this.logger == null) {
            this.logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
        }
        return this.logger;
    }

    protected String getContextUrl() {
        return this.getRequest().getRelativePathPrefixToContextRoot();
    }

    protected TimeZone getTimeZone() {
        return this.app().settings().getBoolean("web.useClientTimezone", false) ? GitBlitWebSession.get().getTimezone() : this.app().getTimezone();
    }

    protected TimeUtils getTimeUtils() {
        if (this.timeUtils == null) {
            ResourceBundle bundle;
            try {
                bundle = ResourceBundle.getBundle("com.gitblit.wicket.GitBlitWebApp", GitBlitWebSession.get().getLocale());
            }
            catch (Throwable t) {
                bundle = ResourceBundle.getBundle("com.gitblit.wicket.GitBlitWebApp");
            }
            this.timeUtils = new TimeUtils(bundle, this.getTimeZone());
        }
        return this.timeUtils;
    }

    protected void setPersonSearchTooltip(Component component, String value, Constants.SearchType searchType) {
        if (searchType.equals((Object)Constants.SearchType.AUTHOR)) {
            WicketUtils.setHtmlTooltip(component, this.getString("gb.searchForAuthor") + " " + value);
        } else if (searchType.equals((Object)Constants.SearchType.COMMITTER)) {
            WicketUtils.setHtmlTooltip(component, this.getString("gb.searchForCommitter") + " " + value);
        }
    }

    public static class JavascriptTextPrompt
    extends AttributeModifier {
        private static final long serialVersionUID = 1L;
        private String initialValue = "";

        public JavascriptTextPrompt(String event, String msg, String value) {
            super(event, true, (IModel)new Model((Serializable)((Object)msg)));
            this.initialValue = value;
        }

        protected String newValue(String currentValue, String message) {
            String result = "var userText = prompt('" + message + "','" + (this.initialValue == null ? "" : this.initialValue) + "'); return userText; ";
            return result;
        }
    }

    public static class JavascriptEventConfirmation
    extends AttributeModifier {
        private static final long serialVersionUID = 1L;

        public JavascriptEventConfirmation(String event, String msg) {
            super(event, true, (IModel)new Model((Serializable)((Object)msg)));
        }

        protected String newValue(String currentValue, String replacementValue) {
            String prefix;
            String result = prefix = "var conf = confirm('" + replacementValue + "'); if (!conf) return false; ";
            if (currentValue != null) {
                result = prefix + currentValue;
            }
            return result;
        }
    }
}

