/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.panels;

import com.gitblit.wicket.panels.BasePanel;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.model.IModel;
import org.parboiled.common.StringUtils;

public class BooleanChoiceOption<T>
extends BasePanel {
    private static final long serialVersionUID = 1L;
    final CheckBox checkbox;
    final DropDownChoice<T> choice;

    public BooleanChoiceOption(String wicketId, String title, String description, IModel<Boolean> checkboxModel, IModel<T> choiceModel, List<T> choices) {
        super(wicketId);
        this.add(new Component[]{new Label("name", title)});
        this.add(new Component[]{new Label("description", description).setVisible(!StringUtils.isEmpty((String)description))});
        this.checkbox = new CheckBox("checkbox", checkboxModel);
        this.checkbox.setOutputMarkupId(true);
        this.choice = new DropDownChoice("choice", choiceModel, choices);
        this.choice.setOutputMarkupId(true);
        this.setup();
    }

    private void setup() {
        this.add(new Component[]{this.checkbox});
        this.add(new Component[]{this.choice.setMarkupId("choice").setEnabled(this.choice.getChoices().size() > 0)});
        this.choice.setEnabled(((Boolean)this.checkbox.getModelObject()).booleanValue());
        this.checkbox.add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = 1L;

            protected void onUpdate(AjaxRequestTarget target) {
                BooleanChoiceOption.this.choice.setEnabled(((Boolean)BooleanChoiceOption.this.checkbox.getModelObject()).booleanValue());
                target.addComponent(BooleanChoiceOption.this.choice);
                if (!BooleanChoiceOption.this.choice.isEnabled()) {
                    BooleanChoiceOption.this.choice.setModelObject(null);
                }
            }
        }});
    }
}

