/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.panels;

import com.gitblit.servlet.DownloadZipServlet;
import com.gitblit.wicket.panels.BasePanel;
import com.gitblit.wicket.panels.LinkPanel;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.markup.repeater.data.ListDataProvider;

public class CompressedDownloadsPanel
extends BasePanel {
    private static final long serialVersionUID = 1L;

    public CompressedDownloadsPanel(String id, final String baseUrl, final String repositoryName, final String objectId, final String path) {
        super(id);
        List<String> types = this.app().settings().getStrings("web.compressedDownloads");
        if (types.isEmpty()) {
            types.add(DownloadZipServlet.Format.zip.name());
            types.add(DownloadZipServlet.Format.gz.name());
        }
        ListDataProvider refsDp = new ListDataProvider(types);
        DataView<String> refsView = new DataView<String>("compressedLinks", (IDataProvider)refsDp){
            private static final long serialVersionUID = 1L;
            int counter;

            protected void onBeforeRender() {
                super.onBeforeRender();
                this.counter = 0;
            }

            public void populateItem(Item<String> item) {
                String compressionType = (String)item.getModelObject();
                DownloadZipServlet.Format format = DownloadZipServlet.Format.fromName(compressionType);
                String href = DownloadZipServlet.asLink(baseUrl, repositoryName, objectId, path, format);
                LinkPanel c = new LinkPanel("compressedLink", null, format.name(), href);
                c.setNoFollow();
                item.add(new Component[]{c});
                Label lb = new Label("linkSep", "|");
                lb.setVisible(this.counter > 0);
                lb.setRenderBodyOnly(true);
                item.add(new Component[]{lb.setEscapeModelStrings(false)});
                item.setRenderBodyOnly(true);
                ++this.counter;
            }
        };
        this.add(new Component[]{refsView});
        this.setVisible(this.app().settings().getBoolean("web.allowZipDownloads", true));
    }
}

