/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.panels;

import com.gitblit.utils.DiffUtils;
import com.gitblit.wicket.WicketUtils;
import java.text.MessageFormat;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;

public class DiffStatPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    final int total;
    final int insertions;
    final int deletions;
    final boolean inline;

    public DiffStatPanel(String wicketId, int insertions, int deletions) {
        this(wicketId, insertions, deletions, false);
    }

    public DiffStatPanel(String wicketId, int insertions, int deletions, boolean inline) {
        super(wicketId);
        this.insertions = insertions;
        this.deletions = deletions;
        this.total = insertions + deletions;
        this.inline = inline;
    }

    protected void onInitialize() {
        super.onInitialize();
        String diffStat = MessageFormat.format(this.getString("gb.diffStat"), "" + this.insertions, "" + this.deletions);
        WicketUtils.setHtmlTooltip((Component)this, diffStat);
        DiffUtils.NormalizedDiffStat n = DiffUtils.normalizeDiffStat(5, this.insertions, this.deletions);
        String segment = this.inline ? "&#9679;" : "&#9632;";
        this.add(new Component[]{new Label("total", String.valueOf(this.total))});
        this.add(new Component[]{new Label("insertions", this.timesRepeat(n.insertions, segment)).setEscapeModelStrings(false).setVisible(n.insertions > 0)});
        this.add(new Component[]{new Label("deletions", this.timesRepeat(n.deletions, segment)).setEscapeModelStrings(false).setVisible(n.deletions > 0)});
        this.add(new Component[]{new Label("blank", this.timesRepeat(n.blanks, segment)).setEscapeModelStrings(false).setVisible(n.blanks > 0)});
        if (this.inline) {
            WicketUtils.setCssClass((Component)this, "diffstat-inline");
        } else {
            WicketUtils.setCssClass((Component)this, "diffstat");
        }
        this.setVisible(this.total > 0);
    }

    String timesRepeat(int cnt, String s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < cnt; ++i) {
            sb.append(s);
        }
        return sb.toString();
    }
}

