/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.panels;

import com.gitblit.models.RepositoryModel;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.freemarker.FreemarkerPanel;
import com.gitblit.wicket.ng.NgController;
import com.gitblit.wicket.panels.BasePanel;
import com.gitblit.wicket.panels.LinkPanel;
import java.io.Serializable;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.HeaderContributor;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.markup.html.basic.Label;

public class FilterableRepositoryList
extends BasePanel {
    private static final long serialVersionUID = 1L;
    private final List<RepositoryModel> repositories;
    private String title;
    private String iconClass;
    private boolean allowCreate;

    public FilterableRepositoryList(String id, List<RepositoryModel> repositories) {
        super(id);
        this.repositories = repositories;
    }

    public void setTitle(String title, String iconClass) {
        this.title = title;
        this.iconClass = iconClass;
    }

    public void setAllowCreate(boolean value) {
        this.allowCreate = value;
    }

    protected void onInitialize() {
        super.onInitialize();
        String id = this.getId();
        String ngCtrl = id + "Ctrl";
        String ngList = id + "List";
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("ngCtrl", ngCtrl);
        values.put("ngList", ngList);
        FreemarkerPanel panel = new FreemarkerPanel("listComponent", "FilterableRepositoryList.fm", values);
        panel.setParseGeneratedMarkup(true);
        panel.setRenderBodyOnly(true);
        this.add(new Component[]{panel});
        String listTitle = StringUtils.isEmpty(this.title) ? this.getString("gb.repositories") : this.title;
        panel.add(new Component[]{new Label(ngList + "Title", MessageFormat.format("{0} ({1})", listTitle, this.repositories.size()))});
        if (StringUtils.isEmpty(this.iconClass)) {
            panel.add(new Component[]{new Label(ngList + "Icon").setVisible(false)});
        } else {
            Label icon = new Label(ngList + "Icon");
            WicketUtils.setCssClass((Component)icon, this.iconClass);
            panel.add(new Component[]{icon});
        }
        if (this.allowCreate) {
            panel.add(new Component[]{new LinkPanel(ngList + "Button", "btn btn-mini", this.getString("gb.newRepository"), this.app().getNewRepositoryPage())});
        } else {
            panel.add(new Component[]{new Label(ngList + "Button").setVisible(false)});
        }
        String format = this.app().settings().getString("web.datestampShortFormat", "MM/dd/yy");
        SimpleDateFormat df = new SimpleDateFormat(format);
        df.setTimeZone(this.getTimeZone());
        ArrayList<RepoListItem> list = new ArrayList<RepoListItem>();
        for (RepositoryModel repo : this.repositories) {
            String name = StringUtils.stripDotGit(repo.name);
            String path = "";
            if (name.indexOf(47) > -1) {
                path = name.substring(0, name.lastIndexOf(47) + 1);
                name = name.substring(name.lastIndexOf(47) + 1);
            }
            RepoListItem item = new RepoListItem();
            item.n = name;
            item.p = path;
            item.r = repo.name;
            item.i = repo.description;
            item.s = this.app().repositories().getStarCount(repo);
            item.t = this.getTimeUtils().timeAgo(repo.lastChange);
            item.d = df.format(repo.lastChange);
            item.c = StringUtils.getColor(StringUtils.stripDotGit(repo.name));
            item.y = !repo.isBare ? 3 : (repo.isMirror ? 2 : (repo.isFork() ? 1 : 0));
            list.add(item);
        }
        NgController ctrl = new NgController(ngCtrl);
        ctrl.addVariable(ngList, list);
        this.add(new IBehavior[]{new HeaderContributor((IHeaderContributor)ctrl)});
    }

    protected class RepoListItem
    implements Serializable {
        private static final long serialVersionUID = 1L;
        String r;
        String n;
        String p;
        String t;
        String d;
        String i;
        long s;
        String c;
        int y;

        protected RepoListItem() {
        }
    }
}

