/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.panels;

import com.gitblit.Constants;
import com.gitblit.models.PathModel;
import com.gitblit.models.RefModel;
import com.gitblit.models.RepositoryCommit;
import com.gitblit.models.SubmoduleModel;
import com.gitblit.utils.ArrayUtils;
import com.gitblit.utils.JGitUtils;
import com.gitblit.utils.MarkdownUtils;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.BlobDiffPage;
import com.gitblit.wicket.pages.BlobPage;
import com.gitblit.wicket.pages.CommitDiffPage;
import com.gitblit.wicket.pages.CommitPage;
import com.gitblit.wicket.pages.GitSearchPage;
import com.gitblit.wicket.pages.HistoryPage;
import com.gitblit.wicket.pages.TreePage;
import com.gitblit.wicket.panels.BasePanel;
import com.gitblit.wicket.panels.CommitHeaderPanel;
import com.gitblit.wicket.panels.LinkPanel;
import com.gitblit.wicket.panels.PathBreadcrumbsPanel;
import com.gitblit.wicket.panels.RefsPanel;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.markup.repeater.data.ListDataProvider;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.StringResourceModel;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;

public class HistoryPanel
extends BasePanel {
    private static final long serialVersionUID = 1L;
    private final boolean hasMore;

    /*
     * WARNING - void declaration
     */
    public HistoryPanel(String wicketId, final String repositoryName, String objectId, final String path, Repository r, int limit, int pageOffset, boolean showRemoteRefs) {
        super(wicketId);
        void var16_27;
        boolean hasSubmodule;
        boolean isSubmodule;
        boolean pageResults = limit <= 0;
        int itemsPerPage = this.app().settings().getInteger("web.itemsPerPage", 50);
        if (itemsPerPage <= 1) {
            itemsPerPage = 50;
        }
        RevCommit commit = JGitUtils.getCommit(r, objectId);
        PathModel matchingPath = null;
        HashMap<String, SubmoduleModel> submodules = new HashMap<String, SubmoduleModel>();
        if (commit == null) {
            String msg = MessageFormat.format("Failed to find history of **{0}** *{1}*", path, objectId);
            this.logger().error(msg + " " + repositoryName);
            this.add(new Component[]{new Label("commitHeader", MarkdownUtils.transformMarkdown(msg)).setEscapeModelStrings(false)});
            this.add(new Component[]{new Label("breadcrumbs")});
        } else {
            List<PathModel.PathChangeModel> paths = JGitUtils.getFilesInCommit(r, commit);
            this.add(new Component[]{new CommitHeaderPanel("commitHeader", repositoryName, commit)});
            this.add(new Component[]{new PathBreadcrumbsPanel("breadcrumbs", repositoryName, path, objectId)});
            for (SubmoduleModel submoduleModel : JGitUtils.getSubmodules(r, commit.getTree())) {
                submodules.put(submoduleModel.path, submoduleModel);
            }
            for (PathModel pathModel : paths) {
                if (!pathModel.path.equals(path)) continue;
                matchingPath = pathModel;
                break;
            }
            if (matchingPath == null) {
                try {
                    Throwable throwable = null;
                    try (TreeWalk tw = new TreeWalk(r);){
                        tw.reset();
                        tw.setRecursive(true);
                        tw.addTree((AnyObjectId)commit.getTree());
                        tw.setFilter(PathFilterGroup.createFromStrings(Collections.singleton(path)));
                        while (tw.next()) {
                            if (!tw.getPathString().equals(path)) continue;
                            matchingPath = new PathModel.PathChangeModel(tw.getPathString(), tw.getPathString(), null, 0L, tw.getRawMode(0), tw.getObjectId(0).getName(), commit.getId().getName(), DiffEntry.ChangeType.MODIFY);
                        }
                    }
                    catch (Throwable throwable2) {
                        Throwable throwable3 = throwable2;
                        throw throwable2;
                    }
                }
                catch (Exception tw) {
                    // empty catch block
                }
            }
        }
        final boolean isTree = matchingPath == null ? true : matchingPath.isTree();
        boolean bl = isSubmodule = matchingPath == null ? false : matchingPath.isSubmodule();
        if (isSubmodule) {
            SubmoduleModel submodule = this.getSubmodule(submodules, repositoryName, matchingPath == null ? null : matchingPath.path);
            String string = submodule.gitblitPath;
            hasSubmodule = submodule.hasSubmodule;
        } else {
            String string = "";
            hasSubmodule = false;
        }
        Map<ObjectId, List<RefModel>> allRefs = JGitUtils.getAllRefs(r, showRemoteRefs);
        List<RevCommit> commits = pageResults ? JGitUtils.getRevLog(r, objectId, path, pageOffset * itemsPerPage, itemsPerPage) : JGitUtils.getRevLog(r, objectId, path, 0, limit);
        this.hasMore = commits.size() >= itemsPerPage;
        final int hashLen = this.app().settings().getInteger("web.shortCommitIdLength", 6);
        ArrayList<RepositoryCommit> repoCommits = new ArrayList<RepositoryCommit>(commits.size());
        for (RevCommit c : commits) {
            RepositoryCommit repoCommit = new RepositoryCommit(repositoryName, "", c);
            if (allRefs.containsKey(c)) {
                repoCommit.setRefs(allRefs.get(c));
            }
            repoCommits.add(repoCommit);
        }
        ListDataProvider dp = new ListDataProvider(repoCommits);
        DataView<RepositoryCommit> logView = new DataView<RepositoryCommit>("commit", (IDataProvider)dp, (String)var16_27, hasSubmodule, objectId){
            private static final long serialVersionUID = 1L;
            int counter;
            final /* synthetic */ String val$submodulePath;
            final /* synthetic */ boolean val$hasSubmodule;
            final /* synthetic */ String val$objectId;
            {
                this.val$submodulePath = string3;
                this.val$hasSubmodule = bl3;
                this.val$objectId = string4;
                super(x0, x1);
            }

            public void populateItem(Item<RepositoryCommit> item) {
                String shortMessage;
                RepositoryCommit entry = (RepositoryCommit)item.getModelObject();
                Date date = entry.getAuthorIdent().getWhen();
                item.add(new Component[]{WicketUtils.createDateLabel("commitDate", date, HistoryPanel.this.getTimeZone(), HistoryPanel.this.getTimeUtils())});
                String author = entry.getAuthorIdent().getName();
                LinkPanel authorLink = new LinkPanel("commitAuthor", "list", author, GitSearchPage.class, WicketUtils.newSearchParameter(repositoryName, null, author, Constants.SearchType.AUTHOR));
                HistoryPanel.this.setPersonSearchTooltip((Component)authorLink, author, Constants.SearchType.AUTHOR);
                item.add(new Component[]{authorLink});
                if (entry.getParentCount() > 1) {
                    item.add(new Component[]{WicketUtils.newImage("commitIcon", "commit_merge_16x16.png")});
                } else {
                    item.add(new Component[]{WicketUtils.newBlankImage("commitIcon")});
                }
                String trimmedMessage = shortMessage = entry.getShortMessage();
                trimmedMessage = !ArrayUtils.isEmpty(entry.getRefs()) ? StringUtils.trimString(shortMessage, 60) : StringUtils.trimString(shortMessage, 78);
                LinkPanel shortlog = new LinkPanel("commitShortMessage", "list subject", trimmedMessage, CommitPage.class, WicketUtils.newObjectParameter(repositoryName, entry.getName()));
                if (!shortMessage.equals(trimmedMessage)) {
                    WicketUtils.setHtmlTooltip((Component)shortlog, shortMessage);
                }
                item.add(new Component[]{shortlog});
                item.add(new Component[]{new RefsPanel("commitRefs", repositoryName, entry.getRefs())});
                if (isTree) {
                    item.add(new Component[]{new Label("hashLabel", this.getString("gb.tree") + "@")});
                    LinkPanel commitHash = new LinkPanel("hashLink", null, entry.getName().substring(0, hashLen), TreePage.class, WicketUtils.newObjectParameter(repositoryName, entry.getName()));
                    WicketUtils.setCssClass((Component)commitHash, "shortsha1");
                    WicketUtils.setHtmlTooltip((Component)commitHash, entry.getName());
                    item.add(new Component[]{commitHash});
                    Fragment links = new Fragment("historyLinks", "treeLinks", (MarkupContainer)this);
                    links.add(new Component[]{new BookmarkablePageLink("commitdiff", CommitDiffPage.class, WicketUtils.newObjectParameter(repositoryName, entry.getName()))});
                    item.add(new Component[]{links});
                } else if (isSubmodule) {
                    Repository repository = HistoryPanel.this.app().repositories().getRepository(repositoryName);
                    String submoduleId = JGitUtils.getSubmoduleCommitId(repository, path, entry.getCommit());
                    repository.close();
                    if (StringUtils.isEmpty(submoduleId)) {
                        item.add(new Component[]{new Label("hashLabel").setVisible(false)});
                        item.add(new Component[]{new Label("hashLink").setVisible(false)});
                    } else {
                        item.add(new Component[]{new Label("hashLabel", this.val$submodulePath + "@")});
                        LinkPanel commitHash = new LinkPanel("hashLink", null, submoduleId.substring(0, hashLen), TreePage.class, WicketUtils.newObjectParameter(this.val$submodulePath, submoduleId));
                        WicketUtils.setCssClass((Component)commitHash, "shortsha1");
                        WicketUtils.setHtmlTooltip((Component)commitHash, submoduleId);
                        item.add(new Component[]{commitHash.setEnabled(this.val$hasSubmodule)});
                    }
                    Fragment links = new Fragment("historyLinks", "treeLinks", (MarkupContainer)this);
                    links.add(new Component[]{new BookmarkablePageLink("commitdiff", CommitDiffPage.class, WicketUtils.newObjectParameter(repositoryName, entry.getName()))});
                    item.add(new Component[]{links});
                } else {
                    item.add(new Component[]{new Label("hashLabel", this.getString("gb.blob") + "@")});
                    LinkPanel commitHash = new LinkPanel("hashLink", null, entry.getName().substring(0, hashLen), BlobPage.class, WicketUtils.newPathParameter(repositoryName, entry.getName(), path));
                    WicketUtils.setCssClass((Component)commitHash, "sha1");
                    WicketUtils.setHtmlTooltip((Component)commitHash, entry.getName());
                    item.add(new Component[]{commitHash});
                    Fragment links = new Fragment("historyLinks", "blobLinks", (MarkupContainer)this);
                    links.add(new Component[]{new BookmarkablePageLink("commitdiff", CommitDiffPage.class, WicketUtils.newObjectParameter(repositoryName, entry.getName()))});
                    links.add(new Component[]{new BookmarkablePageLink("difftocurrent", BlobDiffPage.class, WicketUtils.newBlobDiffParameter(repositoryName, entry.getName(), this.val$objectId, path)).setEnabled(this.counter > 0)});
                    item.add(new Component[]{links});
                }
                WicketUtils.setAlternatingBackground(item, this.counter);
                ++this.counter;
            }
        };
        this.add(new Component[]{logView});
        if (limit <= 0) {
            this.add(new Component[]{new Label("moreHistory", "").setVisible(false)});
        } else if (pageResults) {
            this.add(new Component[]{new Label("moreHistory", "").setVisible(false)});
        } else if (commits.size() == limit) {
            this.add(new Component[]{new LinkPanel("moreHistory", "link", (IModel<String>)new StringResourceModel("gb.moreHistory", (Component)this, null), HistoryPage.class, WicketUtils.newPathParameter(repositoryName, objectId, path))});
        } else {
            this.add(new Component[]{new Label("moreHistory", "").setVisible(false)});
        }
    }

    public boolean hasMore() {
        return this.hasMore;
    }

    protected SubmoduleModel getSubmodule(Map<String, SubmoduleModel> submodules, String repositoryName, String path) {
        String name;
        SubmoduleModel model = submodules.get(path);
        if (model == null) {
            model = new SubmoduleModel(path.substring(path.lastIndexOf(47) + 1), path, path);
            model.hasSubmodule = false;
            model.gitblitPath = model.name;
            return model;
        }
        List<String> patterns = this.app().settings().getStrings("git.submoduleUrlPatterns");
        String submoduleName = StringUtils.extractRepositoryPath(model.url, patterns.toArray(new String[0]));
        String currentPath = "";
        if (repositoryName.indexOf(47) > -1) {
            currentPath = repositoryName.substring(0, repositoryName.lastIndexOf(47) + 1);
        }
        ArrayList<String> candidates = new ArrayList<String>();
        candidates.add(currentPath + StringUtils.stripDotGit(submoduleName));
        candidates.add((String)candidates.get(candidates.size() - 1) + ".git");
        if (submoduleName.lastIndexOf(47) > -1) {
            name = submoduleName.substring(submoduleName.lastIndexOf(47) + 1);
            candidates.add(currentPath + StringUtils.stripDotGit(name));
            candidates.add((String)candidates.get(candidates.size() - 1) + ".git");
        }
        candidates.add(StringUtils.stripDotGit(submoduleName));
        candidates.add((String)candidates.get(candidates.size() - 1) + ".git");
        if (submoduleName.lastIndexOf(47) > -1) {
            name = submoduleName.substring(submoduleName.lastIndexOf(47) + 1);
            candidates.add(StringUtils.stripDotGit(name));
            candidates.add((String)candidates.get(candidates.size() - 1) + ".git");
        }
        LinkedHashSet paths = new LinkedHashSet(candidates);
        for (String candidate : paths) {
            if (!this.app().repositories().hasRepository(candidate)) continue;
            model.hasSubmodule = true;
            model.gitblitPath = candidate;
            return model;
        }
        model.gitblitPath = (String)candidates.get(0);
        return model;
    }
}

