/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.panels;

import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.WicketUtils;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.behavior.SimpleAttributeModifier;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.link.ExternalLink;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class LinkPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    private final IModel<String> labelModel;

    public LinkPanel(String wicketId, String linkCssClass, String label, Class<? extends WebPage> clazz) {
        this(wicketId, null, linkCssClass, (IModel<String>)new Model((Serializable)((Object)label)), clazz, null, false);
    }

    public LinkPanel(String wicketId, String linkCssClass, String label, Class<? extends WebPage> clazz, PageParameters parameters) {
        this(wicketId, null, linkCssClass, (IModel<String>)new Model((Serializable)((Object)label)), clazz, parameters, false);
    }

    public LinkPanel(String wicketId, String linkCssClass, String label, Class<? extends WebPage> clazz, PageParameters parameters, boolean newWindow) {
        this(wicketId, null, linkCssClass, (IModel<String>)new Model((Serializable)((Object)label)), clazz, parameters, newWindow);
    }

    public LinkPanel(String wicketId, String bootstrapIcon, String linkCssClass, String label, Class<? extends WebPage> clazz, PageParameters parameters, boolean newWindow) {
        this(wicketId, bootstrapIcon, linkCssClass, (IModel<String>)new Model((Serializable)((Object)label)), clazz, parameters, newWindow);
    }

    public LinkPanel(String wicketId, String linkCssClass, IModel<String> model, Class<? extends WebPage> clazz, PageParameters parameters) {
        this(wicketId, null, linkCssClass, model, clazz, parameters, false);
    }

    public LinkPanel(String wicketId, String bootstrapIcon, String linkCssClass, IModel<String> model, Class<? extends WebPage> clazz, PageParameters parameters, boolean newWindow) {
        super(wicketId);
        this.labelModel = model;
        BookmarkablePageLink link = null;
        link = parameters == null ? new BookmarkablePageLink("link", clazz) : new BookmarkablePageLink("link", clazz, parameters);
        if (newWindow) {
            link.add(new IBehavior[]{new SimpleAttributeModifier("target", (CharSequence)"_blank")});
        }
        if (linkCssClass != null) {
            link.add(new IBehavior[]{new SimpleAttributeModifier("class", (CharSequence)linkCssClass)});
        }
        Label icon = new Label("icon");
        if (StringUtils.isEmpty(bootstrapIcon)) {
            link.add(new Component[]{icon.setVisible(false)});
        } else {
            WicketUtils.setCssClass((Component)icon, bootstrapIcon);
            link.add(new Component[]{icon});
        }
        link.add(new Component[]{new Label("label", this.labelModel).setRenderBodyOnly(true)});
        this.add(new Component[]{link});
    }

    public LinkPanel(String wicketId, String linkCssClass, String label, String href) {
        this(wicketId, linkCssClass, label, href, false);
    }

    public LinkPanel(String wicketId, String linkCssClass, String label, String href, boolean newWindow) {
        super(wicketId);
        this.labelModel = new Model((Serializable)((Object)label));
        ExternalLink link = new ExternalLink("link", href);
        if (newWindow) {
            link.add(new IBehavior[]{new SimpleAttributeModifier("target", (CharSequence)"_blank")});
        }
        if (linkCssClass != null) {
            link.add(new IBehavior[]{new SimpleAttributeModifier("class", (CharSequence)linkCssClass)});
        }
        link.add(new Component[]{new Label("icon").setVisible(false)});
        link.add(new Component[]{new Label("label", this.labelModel)});
        this.add(new Component[]{link});
    }

    public LinkPanel(String wicketId, String linkCssClass, String label, Link<?> link) {
        super(wicketId);
        this.labelModel = new Model((Serializable)((Object)label));
        if (linkCssClass != null) {
            link.add(new IBehavior[]{new SimpleAttributeModifier("class", (CharSequence)linkCssClass)});
        }
        link.add(new Component[]{new Label("icon").setVisible(false)});
        link.add(new Component[]{new Label("label", this.labelModel)});
        this.add(new Component[]{link});
    }

    public void setNoFollow() {
        Component c = this.get("link");
        c.add(new IBehavior[]{new SimpleAttributeModifier("rel", (CharSequence)"nofollow")});
    }

    public void setTooltip(String tooltip) {
        Component c = this.get("link");
        c.add(new IBehavior[]{new SimpleAttributeModifier("title", (CharSequence)tooltip)});
    }
}

