/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.panels;

import com.gitblit.utils.MarkdownUtils;
import com.gitblit.wicket.GitBlitWebApp;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AbstractAjaxTimerBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.util.time.Duration;

public class MarkdownTextArea
extends TextArea {
    private static final long serialVersionUID = 1L;
    protected String repositoryName;
    protected String text = "";

    public MarkdownTextArea(String id, final IModel<String> previewModel, final Label previewLabel) {
        super(id);
        this.setModel((IModel)new PropertyModel((Object)this, "text"));
        this.add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onblur"){
            private static final long serialVersionUID = 1L;

            protected void onUpdate(AjaxRequestTarget target) {
                MarkdownTextArea.this.renderPreview((IModel<String>)previewModel);
                if (target != null) {
                    target.addComponent((Component)previewLabel);
                }
            }
        }});
        this.add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = 1L;

            protected void onUpdate(AjaxRequestTarget target) {
                MarkdownTextArea.this.renderPreview((IModel<String>)previewModel);
                if (target != null) {
                    target.addComponent((Component)previewLabel);
                }
            }
        }});
        this.add(new IBehavior[]{new KeepAliveBehavior()});
        this.setOutputMarkupId(true);
    }

    protected void renderPreview(IModel<String> previewModel) {
        if (this.text == null) {
            return;
        }
        String html = MarkdownUtils.transformGFM(GitBlitWebApp.get().settings(), this.text, this.repositoryName);
        String safeHtml = GitBlitWebApp.get().xssFilter().relaxed(html);
        previewModel.setObject((Object)safeHtml);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setRepository(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    private class KeepAliveBehavior
    extends AbstractAjaxTimerBehavior {
        private static final long serialVersionUID = 1L;

        public KeepAliveBehavior() {
            super(Duration.minutes((int)5));
        }

        protected void onTimer(AjaxRequestTarget target) {
            target.focusComponent(null);
        }
    }
}

