/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.panels;

import com.gitblit.Constants;
import com.gitblit.models.UserModel;
import com.gitblit.transport.ssh.SshKey;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.GitBlitWebSession;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.panels.BasePanel;
import com.gitblit.wicket.panels.ChoiceOption;
import com.gitblit.wicket.panels.TextAreaOption;
import com.gitblit.wicket.panels.TextOption;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.markup.repeater.data.ListDataProvider;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class SshKeysPanel
extends BasePanel {
    private static final long serialVersionUID = 1L;
    private final UserModel user;
    private final boolean canWriteKeys;

    public SshKeysPanel(String wicketId, UserModel user) {
        super(wicketId);
        this.user = user;
        this.canWriteKeys = this.app().keys().supportsWritingKeys(user);
    }

    protected void onInitialize() {
        super.onInitialize();
        this.setOutputMarkupId(true);
        Model keyFeedback = Model.of((Serializable)((Object)""));
        final ArrayList<SshKey> keys = new ArrayList<SshKey>(this.app().keys().getKeys(this.user.username));
        ListDataProvider<SshKey> dp = new ListDataProvider<SshKey>(keys){

            public IModel<SshKey> model(final SshKey key) {
                return new IModel<SshKey>(){

                    public SshKey getObject() {
                        return key;
                    }

                    public void setObject(SshKey object) {
                    }

                    public void detach() {
                        key.detachPublicKey();
                    }
                };
            }
        };
        DataView<SshKey> keysView = new DataView<SshKey>("keys", (IDataProvider)dp, (IModel)keyFeedback){
            private static final long serialVersionUID = 1L;
            final /* synthetic */ IModel val$keyFeedback;
            {
                this.val$keyFeedback = iModel;
                super(x0, x1);
            }

            public void populateItem(Item<SshKey> item) {
                final SshKey key = (SshKey)item.getModelObject();
                item.add(new Component[]{new Label("comment", key.getComment())});
                item.add(new Component[]{new Label("fingerprint", key.getFingerprint())});
                item.add(new Component[]{new Label("permission", key.getPermission().toString())});
                item.add(new Component[]{new Label("algorithm", key.getAlgorithm())});
                AjaxLink<Void> delete = new AjaxLink<Void>("delete"){
                    private static final long serialVersionUID = 1L;

                    public void onClick(AjaxRequestTarget target) {
                        if (SshKeysPanel.this.app().keys().removeKey(((SshKeysPanel)SshKeysPanel.this).user.username, key)) {
                            keys.clear();
                            keys.addAll(SshKeysPanel.this.app().keys().getKeys(((SshKeysPanel)SshKeysPanel.this).user.username));
                            target.addComponent((Component)SshKeysPanel.this);
                        }
                        val$keyFeedback.setObject((Object)"");
                    }
                };
                if (!SshKeysPanel.this.canWriteKeys) {
                    delete.setVisibilityAllowed(false);
                }
                item.add(new Component[]{delete});
            }
        };
        this.add(new Component[]{keysView});
        Form addKeyForm = new Form("addKeyForm");
        Model keyData = Model.of((Serializable)((Object)""));
        addKeyForm.add(new Component[]{new TextAreaOption("addKeyData", this.getString("gb.key"), null, "span5", (IModel<String>)keyData)});
        Model keyPermission = Model.of((Serializable)((Object)Constants.AccessPermission.PUSH));
        addKeyForm.add(new Component[]{new ChoiceOption<Constants.AccessPermission>("addKeyPermission", this.getString("gb.permission"), this.getString("gb.sshKeyPermissionDescription"), (IModel<Constants.AccessPermission>)keyPermission, Arrays.asList(Constants.AccessPermission.SSHPERMISSIONS))});
        Model keyComment = Model.of((Serializable)((Object)""));
        addKeyForm.add(new Component[]{new TextOption("addKeyComment", this.getString("gb.sshKeyComment"), this.getString("gb.sshKeyCommentDescription"), "span5", (IModel<String>)keyComment)});
        Component addKeyFeedback = new Label("addKeyFeedback", (IModel)keyFeedback).setOutputMarkupId(true);
        WicketUtils.setCssStyle(addKeyFeedback, "color: red; font-weight: bold;");
        addKeyForm.add(new Component[]{addKeyFeedback});
        addKeyForm.add(new Component[]{new AjaxButton("addKeyButton", (IModel)keyData, (IModel)keyFeedback, addKeyFeedback, (IModel)keyPermission, (IModel)keyComment, keys){
            private static final long serialVersionUID = 1L;
            final /* synthetic */ IModel val$keyData;
            final /* synthetic */ IModel val$keyFeedback;
            final /* synthetic */ Component val$addKeyFeedback;
            final /* synthetic */ IModel val$keyPermission;
            final /* synthetic */ IModel val$keyComment;
            final /* synthetic */ List val$keys;
            {
                this.val$keyData = iModel;
                this.val$keyFeedback = iModel2;
                this.val$addKeyFeedback = component;
                this.val$keyPermission = iModel3;
                this.val$keyComment = iModel4;
                this.val$keys = list;
                super(x0);
            }

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                UserModel user = GitBlitWebSession.get().getUser();
                String data = (String)this.val$keyData.getObject();
                if (StringUtils.isEmpty(data)) {
                    this.val$keyFeedback.setObject((Object)this.getString("gb.addSshKeyErrorEmpty"));
                    target.addComponent(this.val$addKeyFeedback);
                    return;
                }
                SshKey key = new SshKey(data);
                try {
                    key.getPublicKey();
                }
                catch (Exception e) {
                    this.val$keyFeedback.setObject((Object)this.getString("gb.addSshKeyErrorFormat"));
                    target.addComponent(this.val$addKeyFeedback);
                    return;
                }
                Constants.AccessPermission permission = (Constants.AccessPermission)((Object)this.val$keyPermission.getObject());
                key.setPermission(permission);
                String comment = (String)this.val$keyComment.getObject();
                if (!StringUtils.isEmpty(comment)) {
                    key.setComment(comment);
                }
                if (SshKeysPanel.this.app().keys().addKey(user.username, key)) {
                    this.val$keyData.setObject((Object)"");
                    this.val$keyPermission.setObject((Object)Constants.AccessPermission.PUSH);
                    this.val$keyComment.setObject((Object)"");
                    this.val$keys.clear();
                    this.val$keys.addAll(SshKeysPanel.this.app().keys().getKeys(user.username));
                    this.val$keyFeedback.setObject((Object)"");
                    target.addComponent((Component)SshKeysPanel.this);
                } else {
                    this.val$keyFeedback.setObject((Object)"Key not added.");
                }
            }
        }});
        if (!this.canWriteKeys) {
            addKeyForm.setVisibilityAllowed(false);
        }
        this.add(new Component[]{addKeyForm});
    }
}

