/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.panels;

import com.gitblit.models.TeamModel;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.EditTeamPage;
import com.gitblit.wicket.panels.BasePanel;
import com.gitblit.wicket.panels.LinkPanel;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.markup.repeater.data.ListDataProvider;

public class TeamsPanel
extends BasePanel {
    private static final long serialVersionUID = 1L;

    public TeamsPanel(String wicketId, boolean showAdmin) {
        super(wicketId);
        Fragment adminLinks = new Fragment("adminPanel", "adminLinks", (MarkupContainer)this);
        adminLinks.add(new Component[]{new BookmarkablePageLink("newTeam", EditTeamPage.class)});
        this.add(new Component[]{adminLinks.setVisible(showAdmin)});
        final List<TeamModel> teams = this.app().users().getAllTeams();
        DataView<TeamModel> teamsView = new DataView<TeamModel>("teamRow", (IDataProvider)new ListDataProvider(teams)){
            private static final long serialVersionUID = 1L;
            private int counter;

            protected void onBeforeRender() {
                super.onBeforeRender();
                this.counter = 0;
            }

            public void populateItem(Item<TeamModel> item) {
                final TeamModel entry = (TeamModel)item.getModelObject();
                LinkPanel editLink = new LinkPanel("teamname", "list", entry.name, EditTeamPage.class, WicketUtils.newTeamnameParameter(entry.name));
                WicketUtils.setHtmlTooltip((Component)editLink, this.getString("gb.edit") + " " + entry.name);
                item.add(new Component[]{editLink});
                item.add(new Component[]{new Label("accountType", entry.accountType.name())});
                item.add(new Component[]{new Label("members", entry.users.size() > 0 ? "" + entry.users.size() : "")});
                item.add(new Component[]{new Label("repositories", entry.repositories.size() > 0 ? "" + entry.repositories.size() : "")});
                Fragment teamLinks = new Fragment("teamLinks", "teamAdminLinks", (MarkupContainer)this);
                teamLinks.add(new Component[]{new BookmarkablePageLink("editTeam", EditTeamPage.class, WicketUtils.newTeamnameParameter(entry.name))});
                Link<Void> deleteLink = new Link<Void>("deleteTeam"){
                    private static final long serialVersionUID = 1L;

                    public void onClick() {
                        if (TeamsPanel.this.app().users().deleteTeam(entry.name)) {
                            teams.remove(entry);
                            this.info(MessageFormat.format("Team ''{0}'' deleted.", entry.name));
                        } else {
                            this.error((Serializable)((Object)MessageFormat.format("Failed to delete team ''{0}''!", entry.name)));
                        }
                    }
                };
                deleteLink.add(new IBehavior[]{new BasePanel.JavascriptEventConfirmation("onclick", MessageFormat.format("Delete team \"{0}\"?", entry.name))});
                teamLinks.add(new Component[]{deleteLink});
                item.add(new Component[]{teamLinks});
                WicketUtils.setAlternatingBackground(item, this.counter);
                ++this.counter;
            }
        };
        this.add(new Component[]{teamsView.setVisible(showAdmin)});
    }
}

