/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.panels;

import com.gitblit.models.RepositoryModel;
import com.gitblit.models.UserModel;
import com.gitblit.tickets.QueryResult;
import com.gitblit.tickets.TicketLabel;
import com.gitblit.utils.ArrayUtils;
import com.gitblit.utils.BugtraqProcessor;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.GitBlitWebSession;
import com.gitblit.wicket.TicketsUI;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.TicketsPage;
import com.gitblit.wicket.pages.UserPage;
import com.gitblit.wicket.panels.AvatarImage;
import com.gitblit.wicket.panels.BasePanel;
import com.gitblit.wicket.panels.LinkPanel;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.PageParameters;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.behavior.SimpleAttributeModifier;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.markup.repeater.data.ListDataProvider;
import org.eclipse.jgit.lib.Repository;

public class TicketListPanel
extends BasePanel {
    private static final long serialVersionUID = 1L;

    public TicketListPanel(String wicketId, List<QueryResult> list, final boolean showSwatch, final boolean showRepository) {
        super(wicketId);
        ListDataProvider dp = new ListDataProvider(list);
        DataView<QueryResult> dataView = new DataView<QueryResult>("row", (IDataProvider)dp){
            private static final long serialVersionUID = 1L;

            protected void populateItem(Item<QueryResult> item) {
                String pattern;
                int count;
                final QueryResult ticket = (QueryResult)item.getModelObject();
                if (showSwatch) {
                    String color = StringUtils.getColor(StringUtils.stripDotGit(ticket.repository));
                    WicketUtils.setCssStyle(item, MessageFormat.format("border-left: 2px solid {0};", color));
                }
                PageParameters tp = WicketUtils.newObjectParameter(ticket.repository, "" + ticket.number);
                if (showRepository) {
                    String name = StringUtils.stripDotGit(ticket.repository);
                    PageParameters rp = WicketUtils.newOpenTicketsParameter(ticket.repository);
                    LinkPanel link = new LinkPanel("ticketsLink", null, name, TicketsPage.class, rp);
                    WicketUtils.setCssBackground((Component)link, name);
                    item.add(new Component[]{link});
                } else {
                    item.add(new Component[]{new Label("ticketsLink").setVisible(false)});
                }
                Label icon = TicketsUI.getStateIcon("state", ticket.type, ticket.status, ticket.severity);
                WicketUtils.addCssClass((Component)icon, TicketsUI.getSeverityClass(ticket.severity));
                item.add(new Component[]{icon});
                item.add(new Component[]{new Label("id", "" + ticket.number)});
                UserModel creator = TicketListPanel.this.app().users().getUserModel(ticket.createdBy);
                if (creator != null) {
                    item.add(new Component[]{new LinkPanel("createdBy", null, creator.getDisplayName(), UserPage.class, WicketUtils.newUsernameParameter(ticket.createdBy))});
                } else {
                    item.add(new Component[]{new Label("createdBy", ticket.createdBy)});
                }
                item.add(new Component[]{WicketUtils.createDateLabel("createDate", ticket.createdAt, GitBlitWebSession.get().getTimezone(), TicketListPanel.this.getTimeUtils(), false)});
                if (ticket.updatedAt == null) {
                    item.add(new Component[]{new Label("updated").setVisible(false)});
                } else {
                    Fragment updated = new Fragment("updated", "updatedFragment", (MarkupContainer)this);
                    UserModel updater = TicketListPanel.this.app().users().getUserModel(ticket.updatedBy);
                    if (updater != null) {
                        updated.add(new Component[]{new LinkPanel("updatedBy", null, updater.getDisplayName(), UserPage.class, WicketUtils.newUsernameParameter(ticket.updatedBy))});
                    } else {
                        updated.add(new Component[]{new Label("updatedBy", ticket.updatedBy)});
                    }
                    updated.add(new Component[]{WicketUtils.createDateLabel("updateDate", ticket.updatedAt, GitBlitWebSession.get().getTimezone(), TicketListPanel.this.getTimeUtils(), false)});
                    item.add(new Component[]{updated});
                }
                item.add(new Component[]{new LinkPanel("title", "list subject", StringUtils.trimString(ticket.title, 78), TicketsPage.class, tp)});
                ListDataProvider labelsProvider = new ListDataProvider(ticket.getLabels());
                DataView<String> labelsView = new DataView<String>("labels", (IDataProvider)labelsProvider){
                    private static final long serialVersionUID = 1L;

                    public void populateItem(Item<String> labelItem) {
                        TicketLabel tLabel;
                        Label label;
                        RepositoryModel repository = TicketListPanel.this.app().repositories().getRepositoryModel(ticket.repository);
                        if (repository == null) {
                            label = new Label("label", (String)labelItem.getModelObject());
                            tLabel = new TicketLabel((String)labelItem.getModelObject());
                        } else {
                            Repository db = TicketListPanel.this.app().repositories().getRepository(repository.name);
                            BugtraqProcessor btp = new BugtraqProcessor(TicketListPanel.this.app().settings());
                            String content = btp.processText(db, repository.name, (String)labelItem.getModelObject());
                            String safeContent = TicketListPanel.this.app().xssFilter().relaxed(content);
                            db.close();
                            label = new Label("label", safeContent);
                            label.setEscapeModelStrings(false);
                            tLabel = TicketListPanel.this.app().tickets().getLabel(repository, (String)labelItem.getModelObject());
                        }
                        String background = MessageFormat.format("background-color:{0};", tLabel.color);
                        label.add(new IBehavior[]{new SimpleAttributeModifier("style", (CharSequence)background)});
                        labelItem.add(new Component[]{label});
                    }
                };
                item.add(new Component[]{labelsView});
                if (StringUtils.isEmpty(ticket.responsible)) {
                    item.add(new Component[]{new Label("responsible").setVisible(false)});
                } else {
                    UserModel responsible = TicketListPanel.this.app().users().getUserModel(ticket.responsible);
                    if (responsible == null) {
                        responsible = new UserModel(ticket.responsible);
                    }
                    AvatarImage avatar = new AvatarImage("responsible", responsible.getDisplayName(), responsible.emailAddress, null, 16, true);
                    avatar.setTooltip(this.getString("gb.responsible") + ": " + responsible.getDisplayName());
                    item.add(new Component[]{avatar});
                }
                Label v = new Label("votes", "" + ticket.votesCount);
                WicketUtils.setHtmlTooltip((Component)v, this.getString("gb.votes"));
                item.add(new Component[]{v.setVisible(ticket.votesCount > 0)});
                item.add(new Component[]{new Label("watching").setVisible(ticket.isWatching(GitBlitWebSession.get().getUsername()))});
                Label priorityIcon = TicketsUI.getPriorityIcon("priority", ticket.priority);
                WicketUtils.addCssClass((Component)priorityIcon, TicketsUI.getPriorityClass(ticket.priority));
                item.add(new Component[]{priorityIcon.setVisible(true)});
                String css = TicketsUI.getLozengeClass(ticket.status, true);
                Label l = new Label("status", ticket.status.toString());
                WicketUtils.setCssClass((Component)l, css);
                item.add(new Component[]{l});
                ArrayList<TicketsUI.Indicator> indicators = new ArrayList<TicketsUI.Indicator>();
                if (ticket.commentsCount > 0) {
                    count = ticket.commentsCount;
                    pattern = this.getString("gb.nComments");
                    if (count == 1) {
                        pattern = this.getString("gb.oneComment");
                    }
                    indicators.add(new TicketsUI.Indicator("fa fa-comment", count, pattern));
                }
                if (!ArrayUtils.isEmpty(ticket.participants) && (count = ticket.participants.size()) > 1) {
                    pattern = this.getString("gb.nParticipants");
                    indicators.add(new TicketsUI.Indicator("fa fa-user", count, pattern));
                }
                if (!ArrayUtils.isEmpty(ticket.attachments)) {
                    count = ticket.attachments.size();
                    pattern = this.getString("gb.nAttachments");
                    if (count == 1) {
                        pattern = this.getString("gb.oneAttachment");
                    }
                    indicators.add(new TicketsUI.Indicator("fa fa-file", count, pattern));
                }
                if (ticket.patchset != null) {
                    count = ticket.patchset.commits;
                    pattern = this.getString("gb.nCommits");
                    if (count == 1) {
                        pattern = this.getString("gb.oneCommit");
                    }
                    indicators.add(new TicketsUI.Indicator("fa fa-code", count, pattern));
                }
                if (!StringUtils.isEmpty(ticket.milestone)) {
                    indicators.add(new TicketsUI.Indicator("fa fa-bullseye", ticket.milestone));
                }
                ListDataProvider indicatorsDp = new ListDataProvider(indicators);
                DataView<TicketsUI.Indicator> indicatorsView = new DataView<TicketsUI.Indicator>("indicators", (IDataProvider)indicatorsDp){
                    private static final long serialVersionUID = 1L;

                    public void populateItem(Item<TicketsUI.Indicator> item) {
                        TicketsUI.Indicator indicator = (TicketsUI.Indicator)item.getModelObject();
                        String tooltip = indicator.getTooltip();
                        Label icon = new Label("icon");
                        WicketUtils.setCssClass((Component)icon, indicator.css);
                        item.add(new Component[]{icon});
                        if (indicator.count > 0) {
                            Label count = new Label("count", "" + indicator.count);
                            item.add(new Component[]{count.setVisible(!StringUtils.isEmpty(tooltip))});
                        } else {
                            item.add(new Component[]{new Label("count").setVisible(false)});
                        }
                        WicketUtils.setHtmlTooltip(item, tooltip);
                    }
                };
                item.add(new Component[]{indicatorsView});
            }
        };
        this.add(new Component[]{dataView});
    }
}

