/*
 * Decompiled with CFR 0.152.
 */
package com.syntevo.bugtraq;

import com.syntevo.bugtraq.BugtraqConfigEntry;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BugtraqConfig {
    private static final String DOT_GIT_BUGTRAQ = ".gitbugtraq";
    private static final String DOT_TGITCONFIG = ".tgitconfig";
    private static final String BUGTRAQ = "bugtraq";
    private static final String URL = "url";
    private static final String ENABLED = "enabled";
    private static final String LOG_REGEX = "logregex";
    private static final String LOG_FILTERREGEX = "logfilterregex";
    private static final String LOG_LINKREGEX = "loglinkregex";
    private static final String LOG_LINKTEXT = "loglinktext";
    private static final String PROJECTS = "projects";
    @NotNull
    private final List<BugtraqConfigEntry> entries;

    @Nullable
    public static BugtraqConfig read(@NotNull Repository repository) throws IOException, ConfigInvalidException {
        StoredConfig config;
        Config baseConfig = BugtraqConfig.getBaseConfig(repository, DOT_GIT_BUGTRAQ);
        if (baseConfig == null) {
            baseConfig = BugtraqConfig.getBaseConfig(repository, DOT_TGITCONFIG);
        }
        HashSet allNames = new HashSet();
        try {
            config = repository.getConfig();
        }
        catch (RuntimeException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw ex;
        }
        if (BugtraqConfig.getString(null, URL, (Config)config, baseConfig) != null) {
            allNames.add(null);
        } else {
            allNames.addAll(config.getSubsections(BUGTRAQ));
            if (baseConfig != null) {
                allNames.addAll(baseConfig.getSubsections(BUGTRAQ));
            }
        }
        ArrayList<BugtraqConfigEntry> entries = new ArrayList<BugtraqConfigEntry>();
        for (String name : allNames) {
            ArrayList<String> projects;
            String projectsList;
            String enabled;
            String url = BugtraqConfig.getString(name, URL, (Config)config, baseConfig);
            if (url == null || (enabled = BugtraqConfig.getString(name, ENABLED, (Config)config, baseConfig)) != null && !"true".equals(enabled)) continue;
            String idRegex = BugtraqConfig.getString(name, LOG_REGEX, (Config)config, baseConfig);
            if (idRegex == null) {
                return null;
            }
            String filterRegex = BugtraqConfig.getString(name, LOG_FILTERREGEX, (Config)config, baseConfig);
            String linkRegex = BugtraqConfig.getString(name, LOG_LINKREGEX, (Config)config, baseConfig);
            if (filterRegex == null && linkRegex == null) {
                String[] split = idRegex.split("\n", Integer.MAX_VALUE);
                if (split.length == 2) {
                    filterRegex = split[0];
                    idRegex = split[1];
                } else {
                    String logIdRegexN;
                    ArrayList<String> logIdRegexs = new ArrayList<String>();
                    for (int index = 1; index < Integer.MAX_VALUE && (logIdRegexN = BugtraqConfig.getString(name, LOG_REGEX + index, (Config)config, baseConfig)) != null; ++index) {
                        logIdRegexs.add(logIdRegexN);
                    }
                    if (logIdRegexs.size() > 1) {
                        throw new ConfigInvalidException("More than three logregex entries found. This is not supported anymore since bugtraq version 0.3, use logfilterregex and loglinkregex instead.");
                    }
                    if (logIdRegexs.size() == 1) {
                        filterRegex = idRegex;
                        idRegex = (String)logIdRegexs.get(0);
                    }
                }
            }
            if ((projectsList = BugtraqConfig.getString(name, PROJECTS, (Config)config, baseConfig)) != null) {
                projects = new ArrayList<String>();
                StringTokenizer tokenizer = new StringTokenizer(projectsList, ",", false);
                while (tokenizer.hasMoreTokens()) {
                    projects.add(tokenizer.nextToken().trim());
                }
                if (projects.isEmpty()) {
                    throw new ConfigInvalidException("'" + name + ".projects' must specify at least one project or be not present at all.");
                }
            } else {
                projects = null;
            }
            String linkText = BugtraqConfig.getString(name, LOG_LINKTEXT, (Config)config, baseConfig);
            entries.add(new BugtraqConfigEntry(url, idRegex, linkRegex, filterRegex, linkText, projects));
        }
        if (entries.isEmpty()) {
            return null;
        }
        return new BugtraqConfig(entries);
    }

    BugtraqConfig(@NotNull List<BugtraqConfigEntry> entries) {
        this.entries = entries;
    }

    @NotNull
    public List<BugtraqConfigEntry> getEntries() {
        return Collections.unmodifiableList(this.entries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static Config getBaseConfig(@NotNull Repository repository, @NotNull String configFileName) throws IOException, ConfigInvalidException {
        FileBasedConfig baseConfig;
        if (repository.isBare()) {
            String content = null;
            RevWalk rw = new RevWalk(repository);
            TreeWalk tw = new TreeWalk(repository);
            tw.setFilter(PathFilterGroup.createFromStrings((String[])new String[]{configFileName}));
            try {
                Ref ref = repository.getRef("HEAD");
                if (ref == null) {
                    Config config = null;
                    return config;
                }
                ObjectId headId = ref.getTarget().getObjectId();
                if (headId == null || ObjectId.zeroId().equals((AnyObjectId)headId)) {
                    Config config = null;
                    return config;
                }
                RevCommit commit = rw.parseCommit((AnyObjectId)headId);
                RevTree tree = commit.getTree();
                tw.reset((AnyObjectId)tree);
                while (tw.next()) {
                    ObjectId entid = tw.getObjectId(0);
                    FileMode entmode = tw.getFileMode(0);
                    if (FileMode.REGULAR_FILE != entmode) continue;
                    ObjectLoader ldr = repository.open((AnyObjectId)entid, 3);
                    content = new String(ldr.getCachedBytes(), BugtraqConfig.guessEncoding(commit));
                    break;
                }
            }
            finally {
                rw.dispose();
                tw.close();
            }
            if (content == null) {
                baseConfig = null;
            } else {
                Config config = new Config();
                config.fromText(content);
                baseConfig = config;
            }
        } else {
            File baseFile = new File(repository.getWorkTree(), configFileName);
            if (baseFile.isFile()) {
                FileBasedConfig fileConfig = new FileBasedConfig(baseFile, repository.getFS());
                fileConfig.load();
                baseConfig = fileConfig;
            } else {
                baseConfig = null;
            }
        }
        return baseConfig;
    }

    @NotNull
    private static Charset guessEncoding(RevCommit commit) {
        try {
            return commit.getEncoding();
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException e) {
            return StandardCharsets.UTF_8;
        }
    }

    @Nullable
    private static String getString(@Nullable String subsection, @NotNull String key, @NotNull Config config, @Nullable Config baseConfig) {
        String value = config.getString(BUGTRAQ, subsection, key);
        if (value != null) {
            return BugtraqConfig.trimMaybeNull(value);
        }
        if (baseConfig != null) {
            return BugtraqConfig.trimMaybeNull(baseConfig.getString(BUGTRAQ, subsection, key));
        }
        return value;
    }

    @Nullable
    private static String trimMaybeNull(@Nullable String string) {
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        return string;
    }
}

