/*
 * Decompiled with CFR 0.152.
 */
package com.syntevo.bugtraq;

import com.syntevo.bugtraq.BugtraqEntry;
import com.syntevo.bugtraq.BugtraqException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BugtraqConfigEntry {
    private final String url;
    private final List<String> projects;
    private final List<BugtraqEntry> entries;

    public BugtraqConfigEntry(@NotNull String url, @NotNull String logIdRegex, @Nullable String logLinkRegex, @Nullable String logFilterRegex, @Nullable String logLinkText, @Nullable List<String> projects) throws BugtraqException {
        this.url = url;
        this.projects = projects;
        this.entries = new ArrayList<BugtraqEntry>();
        if (projects == null) {
            this.entries.add(new BugtraqEntry(url, logIdRegex, logLinkRegex, logFilterRegex, logLinkText));
        } else {
            for (String project : projects) {
                String projectUrl = this.url.replace("%PROJECT%", project);
                String projectLogIdRegex = logIdRegex.replace("%PROJECT%", project);
                String projectLogLinkRegex = logLinkRegex != null ? logLinkRegex.replace("%PROJECT%", project) : null;
                String projectLogFilterRegex = logFilterRegex != null ? logFilterRegex.replace("%PROJECT%", project) : null;
                String projectLogLinkText = logLinkText != null ? logLinkText.replace("%PROJECT%", project) : null;
                this.entries.add(new BugtraqEntry(projectUrl, projectLogIdRegex, projectLogLinkRegex, projectLogFilterRegex, projectLogLinkText));
            }
        }
    }

    @NotNull
    public String getUrl() {
        return this.url;
    }

    @Nullable
    public List<String> getProjects() {
        return this.projects != null ? Collections.unmodifiableList(this.projects) : null;
    }

    public List<BugtraqEntry> getEntries() {
        return this.entries;
    }
}

